/* ============================================================
 * File  : streamtuned.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2004-02-12
 * Description : streamtuned gui
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#ifndef MYTHSTREAM_H
#define MYTHSTREAM_H

#include <qwidget.h>
#include <qdatetime.h>
#include <qprocess.h>

#include <mythtv/uitypes.h>
#include <mythtv/xmlparse.h>
#include <mythtv/oldsettings.h>
#include <mythtv/mythwidgets.h>
#include <mythtv/mythdialogs.h>

#include <qrect.h>
#include <qtimer.h>
#include <qbitmap.h>

#include "../libs/streambrowser.h"
#include "../libs/streamconfig.h"
#include "../libs/storageconfig.h"
#include "../libs/streamstorage.h"

#include "../libs/speechproc.h"


class FFTBox : public QWidget
{
   Q_OBJECT

   public:
     FFTBox(QWidget *parent, int barcnt, unsigned int x, unsigned int y, unsigned int w, unsigned int h);
     ~FFTBox();

     void resetDisplay();
     void paintEvent( QPaintEvent * );

   public slots:
     void setPercentage(Spectrum* percent);

   private slots:
     void buildFFTBackground();

   private:
     Spectrum *percentage;
     int barCount;
     int barWidth;
     int gaugeWidth;
     float div;
     bool go;

     QPixmap bckPict, fftPict, drawPict;
     QBitmap fftMask;

     QTimer *grabTimer;

};


class PlayerState : public QObject
{
   Q_OBJECT

   public:

     enum DisplayStatus
     {
        browse = 0,
        audio,
        video
        //, information
     };

     PlayerState();

     void streamStatusChanged(QString status);
     void browserActivityDetected();
 //    void toggleInformationRequested();
     void videoDetected(bool video);
     bool pollMe(); // returns true on displayState change

     QString getStreamStatus()        { return streamStatus;  }
     DisplayStatus getDisplayStatus() { return displayStatus; }
     bool isVideoActive()             { return playingVideo;  }

   private:

     QString streamStatus;
     bool playingVideo;
     DisplayStatus displayStatus;

     int displayResetDelay;
};

class MythStream : public MythDialog
{
    Q_OBJECT

  public:

    MythStream(MythMainWindow *parent,
               const char *name = 0);
    ~MythStream();
  
  protected:
    bool eventFilter( QObject *obj, QEvent *ev);

  private slots:
    void slotItemTreeSwitchedTo(int itemTreeLoaded);
    void slotHarvesterBusy(bool busy, QString message);
    void slotVideoActive(bool active);
    void slotUserMessage(QString&, QString&);
    void slotGuardInfoField();
    void slotValuesUpdated(int updatedType);
    void slotStorageEvent(int ident, int eventType, bool error);
    void slotWebStorageMaybeReady();
    void slotEditString(QString &line, QString label, bool& cancelled);
    void slotPopResponse(void);
    void slotPopStreamEditBox(QString &errorMessage);

  private:
    void LoadWindow(QDomElement &element);
    void updateBackground();
    void paintEvent(QPaintEvent *e);

    void getStreamStatusValues();
    void getStreamPlayValues();
    void checkShowPlayer();
    void getFolderList();
    void getItemList();
    void displayDetails();

    QString getCurrentItemName(QString type);

    //void parseFont(QDomElement& e);
    void parseContainer(QDomElement& e, QString& name, QRect& area);

    void updateTopView();
    void updateMidView();
    void updateBotView(bool clearOnly);

    void keyPressEvent( QKeyEvent *k );

    void loadUIImageType(UIImageType *icon, QChar prefix);
    void loadField(const QString& container, const QString& field, QString& value);
    void loadListFields(const QString& container, const QString& fieldbasename, QStringList& value, int cursor);
    void loadBar(const QString& container, const QString& field, int value);
    void loadIconSource(QString containerName, QString name, QPixmap &source);
    UITextType * findTtype(const QString field);
    bool processAction( QString action );

    void selectStorageByIndex(ReposStorage *storageBin, StreamStorage *streamStorage, int index);

    void toggleSpeech();
    void stopSpeech();

    QString popParameterBox(QString myString, QString label, bool &cancelled);
    
    SpeechProc *speechProc;
    
    XMLParse     *m_Theme;
    QRect        m_TopRect;
    QRect        m_MidRect;
    QRect        m_BotRect;
    QRect        m_VideoRect;
    QRect        m_VideoMaxRect;
    QRect        m_ViewerRect;
    QRect        m_ViewerMaxRect;
    unsigned int m_ItemDisplaySize;
    unsigned int m_FolderDisplaySize;
    bool clearVideo;
    bool harvesting;

    QRect m_fftRect;
    FFTBox *fft;

    StreamBrowser *streamBrowser;

    void reportEvent(QString msg); // message clears in 4 sec
    void setMessage(QString msg);  // "permanent" message

    // state
    QString currentStreamStatus; // idle, buffering, playing, paused, stopping, stopped, nostream
    StreamBrowser::ItemTreeLoaded itemTreeLoaded;
    PlayerState playerState;
 
    QTimer *infoTimer;   // clears message and info field
    bool infoTimerRerun; // message came in during timer pending, rerun timer on timeout

    StreamStorage *streamStorage;
    ReposStorage *storageBin;

    int displayedVolume;
    int commandPending; // state <>0 means input expected

    // popup boxes
    MythPopupBox *popBox;
    MythLineEdit *editBox;
    QObject *buttonPushed;
    
    // stream item icons
    QPixmap streamPict, downloadPict, urlPict, unknownPict, scheduledPict, emptyPict,
            recordingPict, recordedPict, generalPict, headerPict, markedPict,
            leftPict, rightPict, infoPict, htmlPict;
};

// ----------------------------------------------------------------------

void selectStorages(ReposStorage *storageBin, StreamStorage *streamStorage, int ident = 0);



#endif /* STREAMTUNED_H */
