#!/usr/bin/perl
# Mod_Frontpage configuration script
# (C) 2001 Jean-Michel Dault and Mandrakesoft
# You can use it according to the Apache licence
# Please send modifications to: <jmdault@mandrakesoft.com> and
# mbr@freebsd.org so modules can benefit from it!
#
# Modified for the FreeBSD ports system and to work with
# FP extensions 5.0 from Martin Blapp <mbr@freebsd.org>
#

$flavor=`uname`;
if (-e "/etc/mandrake-release") {$flavor="Mandrake";}

if ($flavor eq "FreeBSD") { $thechoice="/usr/local/sbin/httpd"; 
} elsif ($flavor eq "Mandrake") { $thechoice="/usr/sbin/httpd"; 
} else {
    print "Enter the path of your httpd binary.\n";
    print "It should be something like /usr/local/apache/bin).\n";
    print "If you don't know, enter the word 'findit'. I will try to look\n";
    print "for you... but it will take a few minutes.\n";
    print "Your choice: ";
    $thechoice=<STDIN>;
    chop $thechoice;
}

if ($thechoice eq "") {$thechoice="findit"};

if ($thechoice eq "findit") {
 print "\nTrying to find httpd.... please be patient!\n";
 $thechoice=`find / -type f -iname httpd 2>/dev/null|grep bin| \
	xargs -n 1 file|grep linked|cut -f1 -d: 2>/dev/null`;
 chop $thechoice;
 ($test1,$test2,@junk)=split(/\n/,$thechoice);
 if ($test2)  {die "\nSorry, found more than 1 potential httpd...\n"; }
}

print "\nUsing: $thechoice\n";

print "\nLet's see if it's a valid httpd...";
$_=`$thechoice -v`;
if (/Server version:/) { print " YES!\n";
} else { die "\n\nSorry, can't find Apache version!\n"; }

$httpd=$thechoice;
$thechoice=~s|/httpd||;

print "sbindir is $thechoice, trying to find apxs...";

$sbindir=$thechoice;
$apxs="$thechoice/apxs";
$apachectl="$thechoice/apachectl";
$_=`file $apxs`;
if (/can't stat/) {die "\nSorry, can't find $apxs\n";}
print "Found!\n";

$confdir=`$apxs -q SYSCONFDIR`; 
print "Config directory: $confdir\n";
$cc=`$apxs -q CC`;
print "Compiler: $cc\n";
$cflags=`$apxs -q CFLAGS`;
print "CFLAGS: $cflags\n";
$includedir=`$apxs -q INCLUDEDIR`;
print "Include directory: $includedir\n";
$libexecdir=`$apxs -q LIBEXECDIR`;
print "Libexecdir: $libexecdir\n";
print "\n";

$tmpfile="/tmp/frontpage.$$";
#Mandrake now has two config files, one main and one included
#if we build on another distro, it ignores it
`cat $confdir/httpd.conf $confdir/commonhttpd.conf > $tmpfile 2>/dev/null`;

open(FILE,"$tmpfile") or die "Can't find $tmpfile!\n";
print "Reading httpd.conf...\n";
while(<FILE>) {
    if (!$user && /^\s*User (\w*)/i) {
	$user=$1;
    }
    if (!$group && /^\s*Group (\w*)/i) {
	$group=$1;
    }
    if (!$userdir && /^\s*UserDir (\w*)/i) {
	$userdir=$1;
    }
    if (!$serverroot && /\s*^ServerRoot (\S*)/i) {
	$serverroot=$1;
    }
    if (!$errorlog && /^\s*ErrorLog (\S*)/i) {
	$errorlog=$1;
	$errorlog=~ s/error_log/fpexec_log/;
    }
    if (!$documentroot && /^\s*DocumentRoot (\S*)/i) {
	$documentroot=$1;
    }
}
close(FILE);
`rm -f $tmpfile`;

print "Apache user: $user, group: $group\n";
print "Userdir: $userdir\n";
print "ServerRoot: $serverroot\n";
print "ErrorLog: $errorlog\n";
$_=$errorlog;
if (/^\//) { 
    print "ErrorLog is absolute\n";
} else {
    print "ErrorLog was relative, expanded to ";
    $errorlog="$serverroot/$errorlog";
    print "$errorlog\n";
}
print "DocumentRoot: $documentroot\n";

$_=`ls -dln $documentroot|cut -c 17-30`;
if (/^(\d*)(\s*)(\d*)/) {
    $uid=$1; $gid=$3;
    print "Content uid $uid, gid $gid\n";
}

#
# Check the user for sanity
# Should be 48 for Mandrake, 80 for BSD

if ($flavor eq "FreeBSD") { $defaultid=80;
} elsif ($flavor eq "Mandrake") { $defaultid=48;
} else { $defaultid=99; }

if ($uid < $defaultid) {
    print "UID too low! Using default value 100\n";
    $uid=100;
}
if ($gid < $defaultid) {
    print "GID too low! Using default value 100\n";
    $gid=100;
}


### Create Makefile
$install=`which install`;
chop $install;
open(MTMP,"Makefile.in") or die "Can't find Makefile.tmpl\n";
open(MAKF,"> Makefile") or die "Can't create Makefile\n";
print "Creating Makefile\n";
while(<MTMP>) {
$_=~ s|\$\(apxs\)|$apxs|;
$_=~ s|\$\(apachectl\)|$apachectl|;
$_=~ s|\$\(cc\)|$cc|;
$_=~ s|\$\(includedir\)|$includedir|;
$_=~ s|\$\(cflags\)|$cflags|;
$_=~ s|\$\(sbindir\)|$sbindir|;
$_=~ s|\$\(install\)|$install|;
#$_=~ s|\$\(\)|$|;
#$_=~ s|\$\(\)|$|;
$_=~ s|\$\(fpexec_uidcaller\)|$user|;
$_=~ s|\$\(fpexec_gidcaller\)|$group|;
$_=~ s|\$\(fpexec_uidmin\)|$uid|;
$_=~ s|\$\(fpexec_gidmin\)|$gid|;
$_=~ s|\$\(fpexec_logexec\)|$errorlog|;
$_=~ s|\$\(fpexec_userdir\)|$userdir|;
$_=~ s|\$\(fpexec_docroot\)|$documentroot|;
$_=~ s|"\$\(fpexec_bin\)|\\\\\"$sbindir\/fpexec\\\\|;
$_=~ s|"\$\(fpstatic_bin\)|\\\\\"$sbindir\/fpstatic\\\\|;
$_=~ s|\$\(httpdconf\)|$httpdconf|;
$_=~ s|\$\(libexecdir\)|$libexecdir|;
if ($flavor eq "FreeBSD") { $_=~ s|root.root|root:wheel|;}
print MAKF $_;
}

