#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 07 August 2008 13:48:46 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon1b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#
# $Id: cartoon1b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#

from traceback import print_exc

## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_18 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_18,20,342)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_18=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_19 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_19,16,285)
    Scale_19.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_19.inputPortByName['filter'].widget.set("NEAREST", run=False)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_19=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_20 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_20,15,226)
    apply(Read_Image_20.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_20.inputPortByName['filename'].rebindWidget()
    Read_Image_20.inputPortByName['filename'].widget.set("/home/vareille/dev/Data/crnCartoon0000_movie/crnCartoon0000.png", run=False)
    Read_Image_20.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_20=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_22 = Iterate(constrkw={}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_22,14,142)
    apply(iterate_22.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_22=None

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_24 = Filelist(constrkw={}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_24,13,34)
    Filelist_24.inputPortByName['match_str'].widget.set("cartoonMovie/crnCartoon*png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_24.configure(function=code)
    apply(Filelist_24.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_24=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon10 ##
if Read_Image_20 is not None and Scale_19 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_20, Scale_19, "image", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Image_20 and Scale_19 in network masterNet"
if Scale_19 is not None and Show_Image_18 is not None:
    try:
        masterNet.connectNodes(
            Scale_19, Show_Image_18, "scaledImage", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Scale_19 and Show_Image_18 in network masterNet"
if Filelist_24 is not None and iterate_22 is not None:
    try:
        masterNet.connectNodes(
            Filelist_24, iterate_22, "filelist", "listToLoopOver", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_24 and iterate_22 in network masterNet"
if iterate_22 is not None and Read_Image_20 is not None:
    try:
        masterNet.connectNodes(
            iterate_22, Read_Image_20, "oneItem", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between iterate_22 and Read_Image_20 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

