########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Monday 16 April 2007 15:12:23 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/ImageFigure_net.py,v 1.6 2007/10/08 20:20:31 vareille Exp $
#
# $Id: ImageFigure_net.py,v 1.6 2007/10/08 20:20:31 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Histogram ##
    from Vision.matplotlibNodes import HistogramNE
    Histogram_0 = HistogramNE(constrkw = {}, name='Histogram', library=matplotliblib)
    masterNet.addNode(Histogram_0,90,230)
    Histogram_0.inputPortByName['bins'].widget.set(50, run=False)
    Histogram_0.inputPortByName['patch_facecolor'].widget.set("green", run=False)
    apply(Histogram_0.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore HistogramNE named Histogram in network masterNet"
    print_exc()
    Histogram_0=None

try:
    ## saving node Draw Area ##
    from Vision.matplotlibNodes import MPLDrawAreaNE
    Draw_Area_1 = MPLDrawAreaNE(constrkw = {}, name='Draw Area', library=matplotliblib)
    masterNet.addNode(Draw_Area_1,177,164)
    Draw_Area_1.inputPortByName['left'].widget.set(0.147222222222, run=False)
    Draw_Area_1.inputPortByName['hold'].widget.set(1, run=False)
    Draw_Area_1.inputPortByName['title'].widget.set("Histogram of IQ ", run=False)
    Draw_Area_1.inputPortByName['xlabel'].widget.set("Smarts", run=False)
    Draw_Area_1.inputPortByName['ylabel'].widget.set("Probability", run=False)
except:
    print "WARNING: failed to restore MPLDrawAreaNE named Draw Area in network masterNet"
    print_exc()
    Draw_Area_1=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_2 = Viewer(constrkw = {}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_2,309,381)
    ##
    ## Saving State for Viewer
    Viewer_2.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 417, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 492, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 470, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -21.220682144165039], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 21.220682144165039], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 325, 'd1scale': 0.012999999999999999}
    apply(Viewer_2.vi.cameras[0].Set, (), state)

    state = {'end': 26.856655027923544, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 15.584708746728857, 'mode': 'GL_LINEAR'}
    apply(Viewer_2.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [5.0, 5.0000009536743164, 3.2785532511070414e-08], 'rotation': [0.63510572910308838, 0.54812270402908325, -0.54424458742141724, 0.0, -0.20086479187011719, 0.79754817485809326, 0.56883227825164795, 0.0, 0.74585121870040894, -0.25194907188415527, 0.61662602424621582, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'outline': False, 'inheritStippleLines': 0, 'inheritShadeModel': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2.0, 'scissorW': 200, 'cull': 'back', 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'antialiased': False, 'inheritCulling': False, 'inheritLineWidth': 0, 'shading': 'smooth', 'translation': [-5.0, -5.0000004768371582, 7.7612560289708199e-07], 'transparent': False, 'sharpColorBoundaries': True, 'inheritStipplePolygons': 0, 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritBackPolyMode': False, 'scissor': 0, 'lighting': True, 'lineWidth': 2.0, 'inheritXform': 0}
    apply(Viewer_2.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_2.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_2.vi.rootObject:
        Viewer_2.vi.rootObject.clipP = []
        Viewer_2.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_2=None

try:
    ## saving node ImageFigure ##
    from Vision.matplotlibNodes import MPLImageNE
    ImageFigure_3 = MPLImageNE(constrkw = {}, name='ImageFigure', library=matplotliblib)
    masterNet.addNode(ImageFigure_3,168,370)
except:
    print "WARNING: failed to restore MPLImageNE named ImageFigure in network masterNet"
    print_exc()
    ImageFigure_3=None

try:
    ## saving node oneTexturedQuad ##
    from DejaVu.VisionInterface.GeometryNodes import OneTexturedQuadNE
    oneTexturedQuad_4 = OneTexturedQuadNE(constrkw = {}, name='oneTexturedQuad', library=vizlib)
    masterNet.addNode(oneTexturedQuad_4,345,243)
    oneTexturedQuad_4.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore OneTexturedQuadNE named oneTexturedQuad in network masterNet"
    print_exc()
    oneTexturedQuad_4=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_5 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_5,32,11)
    ReadTable_5.inputPortByName['filename'].widget.set("Data/histogram_data.dat", run=False)
    ReadTable_5.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_5.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_5.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_5=None

masterNet.freeze()

## saving connections for network ImageFigure ##
if Draw_Area_1 is not None and Histogram_0 is not None:
    try:
        masterNet.connectNodes(
            Draw_Area_1, Histogram_0, "drawAreaDef", "drawAreaDef", blocking=True)
    except:
        print "WARNING: failed to restore connection between Draw_Area_1 and Histogram_0 in network masterNet"
if Histogram_0 is not None and ImageFigure_3 is not None:
    try:
        masterNet.connectNodes(
            Histogram_0, ImageFigure_3, "plot", "plots", blocking=True)
    except:
        print "WARNING: failed to restore connection between Histogram_0 and ImageFigure_3 in network masterNet"
if ImageFigure_3 is not None and oneTexturedQuad_4 is not None:
    try:
        masterNet.connectNodes(
            ImageFigure_3, oneTexturedQuad_4, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between ImageFigure_3 and oneTexturedQuad_4 in network masterNet"
if oneTexturedQuad_4 is not None and Viewer_2 is not None:
    try:
        masterNet.connectNodes(
            oneTexturedQuad_4, Viewer_2, "oneTexturedQuad", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between oneTexturedQuad_4 and Viewer_2 in network masterNet"
if ReadTable_5 is not None and Histogram_0 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_5, Histogram_0, "data", "values", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_5 and Histogram_0 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

def loadSavedStates_Viewer_2(self=Viewer_2, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## End Object root

    ##
    ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0, 0, 0, 1), 'd2off': 1, 'height': 417, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 492, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 32.399999999999999, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 470, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -21.220682144165039], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 21.220682144165039], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 325, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 26.856655027923544, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 15.584708746728857, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [5.0, 5.0000009536743164, 3.2785532511070414e-08], 'rotation': [0.63510572910308838, 0.54812270402908325, -0.54424458742141724, 0.0, -0.20086479187011719, 0.79754817485809326, 0.56883227825164795, 0.0, 0.74585121870040894, -0.25194907188415527, 0.61662602424621582, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'outline': False, 'inheritStippleLines': 0, 'inheritShadeModel': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': True, 'pointWidth': 2.0, 'scissorW': 200, 'cull': 'back', 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [1.0, 1.0, 1.0], 'antialiased': False, 'inheritCulling': False, 'inheritLineWidth': 0, 'shading': 'smooth', 'translation': [-5.0, -5.0000004768371582, 7.7612560289708199e-07], 'transparent': False, 'sharpColorBoundaries': True, 'inheritStipplePolygons': 0, 'name': 'root', 'backPolyMode': 'fill', 'inheritFrontPolyMode': False, 'inheritBackPolyMode': False, 'scissor': 0, 'lighting': True, 'lineWidth': 2.0, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_2.restoreStates_cb = Viewer_2.restoreStatesFirstRun = loadSavedStates_Viewer_2
Viewer_2.menu.add_separator()
Viewer_2.menu.add_command(label='Restore states', command=Viewer_2.restoreStates_cb)
