#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 07 August 2008 15:22:44 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon2b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#
# $Id: cartoon2b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#

from traceback import print_exc

## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_15 = Filelist(constrkw={}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_15,15,8)
    Filelist_15.inputPortByName['match_str'].widget.set("cartoonMovie/*.png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_15.configure(function=code)
    apply(Filelist_15.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_15=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_17 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_17,15,342)
    apply(Read_Image_17.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_17.inputPortByName['filename'].rebindWidget()
    Read_Image_17.inputPortByName['filename'].widget.set("", run=False)
    Read_Image_17.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_17=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_18 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_18,15,390)
    Scale_18.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_18.inputPortByName['filter'].widget.set("NEAREST", run=False)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_18=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_19 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_19,15,445)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_19=None

try:
    ## saving node ThumbWheelInt ##
    from Vision.StandardNodes import ThumbWheelIntNE
    ThumbWheelInt_22 = ThumbWheelIntNE(constrkw={}, name='ThumbWheelInt', library=stdlib)
    masterNet.addNode(ThumbWheelInt_22,113,174)
    apply(ThumbWheelInt_22.inputPortByName['thumbwheel'].widget.configure, (), {'max': 100, 'oneTurn': 30.0, 'min': 0})
    ThumbWheelInt_22.inputPortByName['thumbwheel'].widget.set(73, run=False)
    apply(ThumbWheelInt_22.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ThumbWheelIntNE named ThumbWheelInt in network masterNet"
    print_exc()
    ThumbWheelInt_22=None

try:
    ## saving node DialInt ##
    from Vision.StandardNodes import DialIntNE
    DialInt_23 = DialIntNE(constrkw={}, name='DialInt', library=stdlib)
    masterNet.addNode(DialInt_23,719,121)
    DialInt_23.inputPortByName['dial'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore DialIntNE named DialInt in network masterNet"
    print_exc()
    DialInt_23=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_24 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_24,15,284)
    Index_24.inputPortByName['index'].rebindWidget()
    Index_24.inputPortByName['index'].widget.set(0, run=False)
    Index_24.inputPortByName['index'].unbindWidget()
    apply(Index_24.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_24=None

try:
    ## saving node indexMax ##
    from NetworkEditor.macros import MacroNode
    indexMax_25 = MacroNode(name='indexMax')
    masterNet.addNode(indexMax_25, 130, 106)
    from Vision.StandardNodes import Len
    len_47 = Len(constrkw={}, name='len', library=stdlib)
    indexMax_25.macroNetwork.addNode(len_47,198,86)
    apply(len_47.inputPortByName['in1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    apply(len_47.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Operator2
    sub_48 = Operator2(constrkw={}, name='sub', library=stdlib)
    indexMax_25.macroNetwork.addNode(sub_48,202,160)
    apply(sub_48.inputPortByName['data1'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    sub_48.inputPortByName['operation'].widget.set("sub", run=False)
    sub_48.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(sub_48.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    _1_49 = Eval(constrkw={}, name='-1', library=stdlib)
    indexMax_25.macroNetwork.addNode(_1_49,259,98)
    _1_49.inputPortByName['command'].widget.set("1", run=False)
    _1_49.inputPortByName['importString'].widget.set("", run=False)
    apply(_1_49.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network indexMax ##
    indexMax_25.macroNetwork.freeze()
    if len_47 is not None and sub_48 is not None:
        try:
            indexMax_25.macroNetwork.connectNodes(
                len_47, sub_48, "length", "data1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between len_47 and sub_48 in network indexMax_25.macroNetwork"
    if _1_49 is not None and sub_48 is not None:
        try:
            indexMax_25.macroNetwork.connectNodes(
                _1_49, sub_48, "result", "data2", blocking=True
                , splitratio=[1.0, 0.6875])
        except:
            print "WARNING: failed to restore connection between _1_49 and sub_48 in network indexMax_25.macroNetwork"
    input_Ports_26 = indexMax_25.macroNetwork.ipNode
    if input_Ports_26 is not None and len_47 is not None:
        try:
            indexMax_25.macroNetwork.connectNodes(
                input_Ports_26, len_47, "new", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_26 and len_47 in network indexMax_25.macroNetwork"
    output_Ports_27 = indexMax_25.macroNetwork.opNode
    if sub_48 is not None and output_Ports_27 is not None:
        try:
            indexMax_25.macroNetwork.connectNodes(
                sub_48, output_Ports_27, "result", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between sub_48 and output_Ports_27 in network indexMax_25.macroNetwork"
    indexMax_25.macroNetwork.unfreeze()
    indexMax_25.shrink()
    apply(indexMax_25.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named indexMax in network masterNet"
    print_exc()
    indexMax_25=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon2 ##
if Read_Image_17 is not None and Scale_18 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_17, Scale_18, "image", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Image_17 and Scale_18 in network masterNet"
if Scale_18 is not None and Show_Image_19 is not None:
    try:
        masterNet.connectNodes(
            Scale_18, Show_Image_19, "scaledImage", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Scale_18 and Show_Image_19 in network masterNet"
if ThumbWheelInt_22 is not None and Index_24 is not None:
    try:
        masterNet.connectNodes(
            ThumbWheelInt_22, Index_24, "value", "index", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ThumbWheelInt_22 and Index_24 in network masterNet"
if Filelist_15 is not None and Index_24 is not None:
    try:
        masterNet.connectNodes(
            Filelist_15, Index_24, "filelist", "data", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_15 and Index_24 in network masterNet"
if Index_24 is not None and Read_Image_17 is not None:
    try:
        masterNet.connectNodes(
            Index_24, Read_Image_17, "data", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Index_24 and Read_Image_17 in network masterNet"
indexMax_25 = masterNet.nodes[7]
if Filelist_15 is not None and indexMax_25 is not None:
    try:
        masterNet.connectNodes(
            Filelist_15, indexMax_25, "filelist", "len_in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_15 and indexMax_25 in network masterNet"
if indexMax_25 is not None and ThumbWheelInt_22 is not None:
    try:
        masterNet.connectNodes(
            indexMax_25, ThumbWheelInt_22, "sub_result", "maxi", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between indexMax_25 and ThumbWheelInt_22 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

