/* SVN FILE: $Id$ */
/**
* Project Name : ManDVD
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/

/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Implementation: dvdbuild
//
// Description: Functions (backend) for DVD-build
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//

#include <dvdbuild.h>
#include <mainfrm.h>

/* Code in this file should assosiate to encoding and building of a Video DVD */

/* Button generate DVD stucture clicked */
void mainfrm::bt_gener_struct_clicked()
{
    // ***********************************
    // *** Lancement de la gnration du DVD ***
    // ***********************************

    foundMovie = false;

    if (path_out->text() != "") {
	priority = 10 - sliderpriorite->value();
	bt_lire_DVD->setDisabled(true);
	bt_grave->setDisabled(true);
	bt_grave_2->setDisabled(true);
	bt_grave_3->setDisabled(true);
	btgrpprio->setDisabled(true);
	buttonGroupAudio->setDisabled(true);
	bt_param_encode->setDisabled(true);
	buttonGroupHQ->setDisabled(true);
	optencode->hide();
	lecture_console->clear();
	etape_1->setText(table_message[56]);
	etape_2->setText(table_message[57]);
	etape_3->setText(table_message[58]);

	// **************************************************
	// *** Gnration du fichier pour encodage des fichiers vido ***
	// **************************************************

	progress_fleche->setGeometry(32, 24, 22, 22);
	progress_fleche->show();
	Box_Encode->setEnabled(true);
	bt_gener_struct->setDisabled(true);
	bt_et_05->setDisabled(true);
	buttonGroup62->setDisabled(true);

	pb_001->setProgress(0);
	pb_002->setProgress(0);
	pb_007->setProgress(0);
	pb_008->setProgress(0);

	int compteur = 0;
	int compteur_2 = 0;

	aspectdvdauth = "";	// Set aspect en menu to 16:9 if present
	progress = 0;
	globalprogress = 0;
	currentprogress = 0;
	rc_001 = 0;		// g++ Warningfix MB
	rc_002 = 0;		// g++ Warningfix MB
	adjustforintro = 0;
	tmp_001 = "";

	if (fautyrencoder == 1) {
	    QString tmp_format;

	    QFile myfic(path_out->text() + "/encode.sh");

	    if (myfic.open(IO_WriteOnly)) {
		myfic.writeBlock("#!/bin/bash\n", 12);

		tmp_001 = "rm -f " + path_out->text() + "/gibvide*.mpg\n";
		myfic.writeBlock(tmp_001, tmp_001.length());
		if (pathintro != "") {
		    tmp_001 = "rm -f gibintromenu.mpg\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		}

		QString aencoder;
		QString vfilter;
		float decalage;
		QString wdecalage;
		QString thetest;
		QString txtdes;
		QString deinterlace;	/* More deinterlace filters */
		QString myEDL;
		QString audioenc;	/* String used with mencoder audioencoding  */
		QString hqparameters = "";

		// Set hq encoding parameters or not
		if (hqencode->isChecked() == true)
		    hqparameters = HQPARAM;
		else
		    hqparameters = "";

		while (compteur < max_boutons) {
		    // Pick up audiobitrate from filelist in main windowv
		    QListViewItem *i = lst_video_1->firstChild();
		    QString vidfile = table_boutons_lien[compteur][1];

		    while (i) {
			if (i->text(1) == vidfile) {
			    QString tmp = i->text(9);
			    audio_bitrate = tmp.toInt();
			}
			i = i->nextSibling();
		    }
		    /* EXPERIMENTAL - BREAK PAL STANDARD */
		    // Determin if movie is not 25fps and PAL project
		    // If bitrate is 30 encode NTSC 30000/1001
		    QString fps_encode = "";
		    fps_encode = table_boutons_lien[compteur][9];

		    if ((fps_encode.toInt() == 30
			 || fps_encode.toDouble() == 29.97)
			&& projfps == 25) {
			fps_encode = " -ofps 30000/1001 ";	// Dont reencode framerate to lower
			table_boutons_lien[compteur][9] = "29.97";
		    } else {
			fps_encode =
			    " -ofps " + QString::number(projfps) + " ";
		    }

		    if (audio_bitrate == 0)
			audio_bitrate = DEFAULTAUDIOBR;	// Incase no bitrate is picked up go to default
		    /*
		       Fixing choice to force audioencode to AC3  
		     */
		    if (audioencode2->isChecked() == true) {
			/* Perform two checks to avoid strange bitrates and always go a bit higher on AC3 from mp3 */
			if (audio_bitrate < 192)
			    audio_bitrate = DEFAULTAUDIOBR / 2;
			else if (audio_bitrate <= 384
				 && audio_bitrate > 192)
			    audio_bitrate = DEFAULTAUDIOBR;
			else if (audio_bitrate > 384)
			    audio_bitrate = 448;	// Max valid for DVD

			audioenc =
			    AUDIOENC + QString::number(audio_bitrate);
		    } else {
			audioenc = NOAUDIOENC;
		    }

		    if (btformat->isChecked() == true) {
			video_format = "4/3";
			aspectdvdauth = "4:3";
		    } else if (btformat_2->isChecked() == true) {
			video_format = "16/9";
			aspectdvdauth = "16:9";
		    } else {
			// Get video format for current moive if not forced to encode in 4/3 or 16/9
			video_format = table_boutons_lien[compteur][5];
			aspectdvdauth = "4:3";
			QListViewItem *i = lst_video_1->firstChild();
			// Find out if some movie is widescr and set dvd ti widescr
			while (i) {
			    if (i->text(5) == "16/9") {
				aspectdvdauth = "16:9";
				break;
			    }
			    i = i->nextSibling();
			}
		    }
		    // Ignore button if its a chapterbutton
		    if (table_boutons_lien[compteur][3] != "$$CHAP$$") {
			tmp4sub = table_boutons_lien[compteur][5];
			rc_001 = tmp4sub.find("$$$", 0);
			if (rc_001 != -1) {
			    tmp_002 =
				tmp4sub.mid(rc_001 + 3,
					    tmp4sub.length() - (rc_001 +
								3));
			    path_subtitle = "-sub \"" + tmp_002 + "\"";
			    if (lineEdit12->text() != "") {
				path_subtitle =
				    path_subtitle + " -font \"" +
				    lineEdit12->text() +
				    "\" -subfont-text-scale " +
				    QString::number(slider10->value()) +
				    " -subpos " +
				    QString::number(slider10_2->value());
			    } else {
				path_subtitle =
				    path_subtitle + " -subpos " +
				    QString::number(slider10_2->value());
			    }
			    yasubtitle = 1;
			    tmp_format = tmp4sub.mid(0, rc_001);
			} else {
			    path_subtitle = "";
			    yasubtitle = 0;
			    tmp_format = table_boutons_lien[compteur][5];
			}

			// DEBUGING
			//printf(tmp_format);
			//printf("=================================\n");

			aencoder = table_boutons_lien[compteur][2];
			rc_001 = aencoder.find("/*EDL/*", 0);
			if (rc_001 == -1) {
			    vfilter =
				aencoder.mid(1, aencoder.length() - 1);
			    myEDL = "";
			} else {
			    if (rc_001 + 8 >= (int) aencoder.length())	// Cast to avoid cc-warning
			    {
				vfilter = "";
			    } else {
				vfilter =
				    aencoder.mid(rc_001 + 7,
						 aencoder.length() -
						 (rc_001 + 7));
			    }
			    myEDL = "-edl " + aencoder.mid(8, rc_001 - 8);
			}

			/* Trying to always encode audio and deinterlace if choosen */
			if (aencoder.mid(0, 1) == "1"
			    || tmp_format != video_format
			    || audioencode2->isChecked()
			    || desinter->isChecked()) {
			    // *** Test A/V Sync et calcul ***
			    tmp_004 = table_boutons_lien[compteur][6];
			    rc_003 = tmp_004.find("##", 0);
			    if (rc_003 != -1) {
				tmp_008 = "";
				rc_003 = rc_003 + 2;

				while (rc_003 < (int) tmp_004.length())	// Cast to avoid cc-warning
				{
				    tmp_008 =
					tmp_008 + tmp_004.mid(rc_003, 1);
				    rc_003 = rc_003 + 1;
				}

				rc_001 = tmp_008.toInt(&ok, 10);
				if (ok == true) {
				    avvalue->setValue(rc_001);
				} else {
				    avvalue->setValue(0);
				}
			    }
			    rc_003 = 2;
			    tmp_008 = "";

			    while (tmp_004.mid(rc_003, 1) != "#") {
				tmp_008 = tmp_008 + tmp_004.mid(rc_003, 1);
				rc_003 = rc_003 + 1;
			    }

			    rc_001 = tmp_008.toInt(&ok, 10);
			    if (ok == true) {
				decalage = avvalue->value() - rc_001;
			    } else {
				decalage = 0;
			    }
			    if (decalage == 0) {
				wdecalage = "";
			    } else {
				float myval = decalage / 1000;

				thetest.setNum(myval, 'f', 3);
				wdecalage = " -delay " + thetest;
			    }

			    /*
			       Deinterlacing 
			     */
			    if (desinter->isChecked() == true) {
				txtdes = INTERLACE;
				deinterlace = DEINTERLACEFILTER;
			    } else {
				txtdes = "";
				deinterlace = " ";
			    }

			    rc_001 = 0;
			    tmp_002 = table_boutons_lien[compteur][1];
			    rc_003 =
				tmp_002.find(".", tmp_002.length() - 5);
			    if (rc_001 != -1) {
				if (tmp_002.mid(rc_003 + 1, 3) == "avi"
				    || tmp_002.mid(rc_003 + 1, 3) == "avi")
				{
				    tmp_003 = "AVI";
				} else {
				    tmp_003 = "OTH";
				}
			    }

			    if (tmp_003 == "OTH") {
				if (projfps == 29) {
				    QString toutf =
					table_boutons_lien[compteur][1] +
					"\"\n";
				    toutf = toutf.utf8();	// Make it handle UTF8 filenames

				    tmp_001 =
					"nice -n " +
					QString::number(priority) +
					" mencoder -v -channels 6 -oac " +
					audioenc + " -ovc lavc " + myEDL +
					" -subcp " +
					comboencoding->currentText() +
					" -of mpeg -mpegopts format=dvd -vf"
					+ deinterlace + "scale=" +
					QString::number(projwid) + ":" +
					QString::number(projhau) +
					",harddup" + vfilter +
					" -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:"
					+ txtdes +
					"vrc_maxrate=9800:vbitrate=" +
					QString::number(slidevbitrate->
							value()) +
					":keyint=15:" + hqparameters +
					"vstrict=0:aspect=" +
					video_format +
					" -ofps 30000/1001 " +
					path_subtitle + " " + wdecalage +
					" -o \"" + path_out->text() +
					"/gibvideo" +
					QString::number(compteur_2) +
					".mpg\" \"" + toutf;
				} else {
				    QString toutf =
					table_boutons_lien[compteur][1] +
					"\"\n";
				    toutf = toutf.utf8();	// Make it handle UTF8 filenames

				    tmp_001 = "nice -n " + QString::number(priority) + " mencoder -v -channels 6 -oac " + audioenc + " -ovc lavc " + myEDL + " -subcp " + comboencoding->currentText() + " -of mpeg -mpegopts format=dvd -vf" + deinterlace + "scale=" + QString::number(projwid) + ":" + QString::number(projhau) + ",harddup" + vfilter + " -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:" + txtdes + "vrc_maxrate=9800:vbitrate=" + QString::number(slidevbitrate->value()) + ":keyint=15:" + hqparameters + "vstrict=0:aspect=" + video_format + fps_encode +	//" -ofps " +
					//QString::number(projfps) + " " +
					path_subtitle + " " + wdecalage +
					" -o \"" + path_out->text() +
					"/gibvideo" +
					QString::number(compteur_2) +
					".mpg\" \"" + toutf;
				}
			    } else {
				if (projfps == 29) {
				    QString toutf =
					table_boutons_lien[compteur][1] +
					"\"\n";
				    toutf = toutf.utf8();	// Make it handle UTF8 filenames

				    tmp_001 =
					"nice -n " +
					QString::number(priority) +
					" mencoder -v -channels 6 -oac " +
					audioenc + " -ovc lavc " + myEDL +
					" -subcp " +
					comboencoding->currentText() +
					" -of mpeg -mpegopts format=dvd -vf "
					+ deinterlace + "scale=" +
					QString::number(projwid) + ":" +
					QString::number(projhau) +
					",harddup" + vfilter +
					" -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:"
					+ txtdes +
					"vrc_maxrate=9800:vbitrate=" +
					QString::number(slidevbitrate->
							value()) +
					":keyint=18:" + hqparameters +
					"vstrict=0:aspect=" +
					video_format +
					" -ofps 30000/1001 " +
					path_subtitle + " " + wdecalage +
					" -o \"" + path_out->text() +
					"/gibvideo" +
					QString::number(compteur_2) +
					".mpg\" \"" + toutf;
				} else {
				    QString toutf =
					table_boutons_lien[compteur][1] +
					"\"\n";
				    toutf = toutf.utf8();	// Make it handle UTF8 filenames

				    tmp_001 = "nice -n " + QString::number(priority) + " mencoder -v -channels 6 -oac " + audioenc + " -ovc lavc " + myEDL + " -subcp " + comboencoding->currentText() + " -of mpeg -mpegopts format=dvd -vf " + deinterlace + "scale=" + QString::number(projwid) + ":" + QString::number(projhau) + ",harddup" + vfilter + " -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:" + txtdes + "vrc_maxrate=9800:vbitrate=" + QString::number(slidevbitrate->value()) + ":keyint=15:" + hqparameters + "vstrict=0:aspect=" + video_format + fps_encode +	//" -ofps " +
					//QString::number(projfps) + " " +
					path_subtitle + " " + wdecalage +
					" -o \"" + path_out->text() +
					"/gibvideo" +
					QString::number(compteur_2) +
					".mpg\" \"" + toutf;
				}
			    }
			    myfic.writeBlock(tmp_001, tmp_001.length());
			    compteur_2 = compteur_2 + 1;
			} else {
			    tmp_001 =
				"ln -s -f \"" +
				table_boutons_lien[compteur][1] + "\" \"" +
				path_out->text() + "/gibvideo" +
				QString::number(compteur_2) + ".mpg\"\n";
			    myfic.writeBlock(tmp_001, tmp_001.length());
			    compteur_2 = compteur_2 + 1;
			}
			tmp_001 = "echo \"GIBOSTEP+1\"\n";
			myfic.writeBlock(tmp_001, tmp_001.length());
		    }
		    compteur = compteur + 1;
		}

		if (pathintro != "") {
		    adjustforintro = 1;
		    if (projfps == 29) {
			tmp_001 =
			    "nice -n " + QString::number(priority) +
			    " mencoder -v -channels 6 -oac " + audioenc +
			    " -ovc lavc -of mpeg -mpegopts format=dvd -vf "
			    + deinterlace +
			    "scale=720:480,harddup -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:vrc_maxrate=9800:vbitrate="
			    + QString::number(slidevbitrate->value()) +
			    ":keyint=18:" + hqparameters +
			    "vstrict=0:aspect=" + video_format +
			    " -ofps 30000/1001 -o \"" + path_out->text() +
			    "/gibintromenu.mpg\" \"" + pathintro + "\"\n";
		    } else {
			tmp_001 =
			    "nice -n " + QString::number(priority) +
			    " mencoder -v -channels 6 -oac " + audioenc +
			    " -ovc lavc -of mpeg -mpegopts format=dvd -vf "
			    + deinterlace +
			    "scale=720:576,harddup -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:vrc_maxrate=9800:vbitrate="
			    + QString::number(slidevbitrate->value()) +
			    ":keyint=15:" + hqparameters +
			    "vstrict=0:aspect=" + video_format +
			    " -ofps " + QString::number(projfps) +
			    " -o \"" + path_out->text() +
			    "/gibintromenu.mpg\" \"" + pathintro + "\"\n";
		    }

		    myfic.writeBlock(tmp_001, tmp_001.length());
		    tmp_001 = "echo \"GIBOSTEP+1\"\n";
		    myfic.writeBlock(tmp_001, tmp_001.length());
		    progress = 100 / (nombre_video + 1);
		} else {
		    progress = 100 / nombre_video;
		    adjustforintro = 0;
		}
		myfic.close();

		/*
		   Launch process to start encoding 
		 */
		lecture_console->append
		    (tr
		     ("--> Output from encoding files ------------------------------------------------------------"));

		proc_001 = new QProcess(this);
		proc_001->addArgument("bash");
		proc_001->addArgument(path_out->text() + "/encode.sh");

		connect(proc_001, SIGNAL(readyReadStdout()), this,
			SLOT(readFromStdout()));
		connect(proc_001, SIGNAL(processExited()), this,
			SLOT(spmuxSubs()));
		//              SLOT(fin_encode()));

		if (!proc_001->start()) {
		    QMessageBox::warning(this, MANDVDVER,
					 table_message[0] + "mencoder");
		    bt_et_05->setEnabled(true);
		    btgrpprio->setEnabled(true);
		    buttonGroupAudio->setEnabled(true);
		    bt_gener_struct->setEnabled(true);
		    buttonGroup62->setEnabled(true);
		} else {
		    btcancelencode->setEnabled(true);
		}
	    } else {
		QMessageBox::warning(this, MANDVDVER, table_message[8]);
		btgrpprio->setEnabled(true);
		buttonGroupAudio->setEnabled(true);
		bt_gener_struct->setEnabled(true);
		buttonGroup62->setEnabled(true);
		bt_et_05->setEnabled(true);
	    }
	} else {
	    rc_002 = 0;
	    spmuxSubs();
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[9]);
	bt_et_05->setEnabled(true);
	btgrpprio->setEnabled(true);
	buttonGroupAudio->setEnabled(true);
	buttonGroup62->setEnabled(true);
	bt_gener_struct->setEnabled(true);
    }
}


/* This method runs as a QProcess and produces output in the program console
 * and also some encoding information to the GUI when encoding video.
**/
void mainfrm::readFromStdout()
{
    // ****************************
    // *** Lecture de la sortie console ***   
    // ****************************
    lineEdit1->setText(proc_001->readStdout());
    tmp_001 = lineEdit1->text();

    rc_001 = tmp_001.find("%", 0);

    /* First pos of Stream file in mencoder output */
    int i = tmp_001.find("STREAM: Description: File", 0, true);

    if (i > 0 && foundMovie == false) {
	foundMovie = true;

	int j = tmp_001.findRev(".", i, false);
	int k = tmp_001.findRev("/", i, false);

	QString moviemess = tmp_001.mid(k + 1, (j - k) + 3);
	textLabel1->setText(table_message[54] + moviemess);
    }

    /* Pic up encoding speed half way thru the encoding process to GUI */
    int k = tmp_001.contains("(50%)");
    if (k > 0) {
	foundMovie = false;
	int l = tmp_001.findRev("fps");
	QString addmess = tmp_001.mid(k + 2, (l - k) + 1);
	textLabel1->setText(table_message[54] + table_message[75] +
			    addmess);
    }

    if (rc_001 != -1 && tmp_001.mid(0, 4) == "Pos:") {
	tmp_002 = tmp_001.mid((rc_001 - 2), 2);
	rc_001 = tmp_002.toInt(&ok, 10);

	/* rc_001 moving from 0 - 100 */
	if (ok == true) {
	    if (rc_001 > pb_001->progress()) {
		pb_001->setProgress(rc_001);

		if (nombre_video == 0)
		    pb_002->setProgress(rc_001);
		else {
		    /* Check if movie encode advanced, if so advance global encoding */
		    if (rc_001 > progress) {
			currentprogress =
			    rc_001 / (nombre_video - adjustforintro);
			pb_002->setProgress(globalprogress +
					    currentprogress);
			progress = rc_001;
		    }
		    /* Next movie -- reset */
		    if (rc_001 < progress) {
			progress = 0;
			globalprogress += currentprogress;
		    }
		}
	    }
	}
    }
    // *** Test si changement d'tape ***
    rc_001 = tmp_001.find("GIBOSTEP+1", 0);

    if (rc_001 != -1) {
	pb_001->setProgress(0);
    }
    // *** Test si erreur ***
    lineEdit1->setText(proc_001->readStderr());
    tmp_001 = lineEdit1->text();

    rc_001 = tmp_001.find("Seek failed", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    // Error handlign with input files that need force AC3 encoding
    rc_001 = tmp_001.find("incompatible with '-oac copy'", 0);
    if (rc_001 != -1) {
	audioencode->setChecked(false);
	audioencode2->setChecked(true);
	rc_002 = 1;
    }

    rc_001 = tmp_001.find("File not found:", 0);
    if (rc_001 != -1) {
	rc_001 = tmp_001.find("File not found: 'frameno.avi'", 0);
	if (rc_001 == -1) {
	    rc_002 = 1;
	}
    }

    lecture_console->append(lineEdit1->text());
    lecture_console->append(proc_001->readStdout());
}

/* Prepare to render subtitles into movie 
 * Post: All movies must be encoded before this process starts.
 * Pre : Call a QProcess to rendering subs with spmux */
void mainfrm::spmuxSubs()
{
    int movienum = 0;
    int totnumvideos = 0;
    int subcounter = 0;
    int fontsize = 20;		// Size of font sub 720x

    QFile file(path_out->text() + "/spmuxmandvd.sh");
    if (file.open(IO_WriteOnly)) {
	file.writeBlock("#!/bin/bash\n", 12);
    }
    // Dummy srt if no real srt is availeble for a movie
    QFile filesrte(path_out->text() + "/empty.srt");
    if (filesrte.open(IO_WriteOnly)) {
	QString empty =
	    tr
	    ("1\n00:00:10,000 --> 00:05:00,000\nNo subtitle availible for this movie in this language\n\n");
	filesrte.writeBlock(empty, empty.length());
	filesrte.close();
    }
    // Check how many videos to be encoded
    QListViewItem *videolist = lst_video_1->firstChild();

    while (videolist) {
	totnumvideos++;

	// Mark intromovie posision
	if (videolist->text(2) == "9")
	    totnumvideos--;

	videolist = videolist->nextSibling();
    }

    // Write dummy subs for all movies all languages first
    /* Code for subtitles in dvdauth (Set all availible languages ! */
    listViewSubTitle_2->sort();
    QListViewItem *lsub = listViewSubTitle_2->firstChild();

    QString sublang = "";
    QString subtaken = "";
    subcounter = -1;

    // Adjust fontsize if not standard DVD 
    if (projwid == 352)
	fontsize = 16;

    if (projwid == 1280)
	fontsize = 24;

    while (lsub) {
	sublang = lsub->text(0);
	sublang = sublang.lower();
	sublang = sublang.left(2);

	if (QString::compare(subtaken, sublang) != 0) {
	    subcounter++;
	    movienum = 0;

	    // Run thru all movies for this language
	    while (movienum < totnumvideos) {

		// Try to read actual read movie framerate
		QString movieFR = table_boutons_lien[movienum][9];

		if (movieFR.toDouble() == 0.0)
		    movieFR = QString::number(projfps);	// Else proj standard

		QString subxmlfile =
		    "spmuxGV" + QString::number(movienum) +
		    sublang + ".xml";
		QFile sfile(path_out->text() + subxmlfile);

		if (sfile.open(IO_WriteOnly)) {
		    sfile.writeBlock("<subpictures>\n", 14);
		    sfile.writeBlock("   <stream>\n", 12);
		    QString xmlappend =
			"      <textsub filename=\"" +
			path_out->text() + "empty.srt\"";
		    xmlappend =
			xmlappend + " characterset=\"ISO8859-1\"\n";
		    xmlappend =
			xmlappend + "\tfontsize=\"" +
			QString::number(fontsize) +
			"\" font=\"devedesans.ttf\"\n";
		    xmlappend =
			xmlappend +
			"\thorizontal-alignment=\"center\" vertical-alignment=\"bottom\"\n";
		    xmlappend =
			xmlappend +
			"\tleft-margin=\"60\" right-margin=\"60\" top-margin=\"20\" bottom-margin=\"30\"\n";
		    xmlappend =
			xmlappend + "\tsubtitle-fps=\"" + movieFR +
			"\" movie-fps=\"" + movieFR + "\"";
		    xmlappend =
			xmlappend + " movie-width=\"" +
			QString::number(projwid) +
			"\" movie-height=\"" +
			QString::number(projhau) + "\" />\n";
		    sfile.writeBlock(xmlappend, xmlappend.length());
		    sfile.writeBlock("   </stream>\n", 13);
		    sfile.writeBlock("</subpictures>\n", 15);
		    sfile.close();

		    // Write to spmuxmandvd.sh what to encode
		    QString spmuxcom =
			"spumux -s" + QString::number(subcounter) + " ";
		    spmuxcom =
			spmuxcom + path_out->text() + subxmlfile +
			" < " + path_out->text() + "gibvideo" +
			QString::number(movienum) +
			".mpg > " + path_out->text() + "outfile.mpg \n";
		    spmuxcom =
			spmuxcom + "rm -f " + path_out->text() +
			"gibvideo" + QString::number(movienum) + ".mpg\n";
		    spmuxcom =
			spmuxcom + "mv " + path_out->text() +
			"outfile.mpg " + path_out->text() +
			"gibvideo" + QString::number(movienum) + ".mpg\n";
		    file.writeBlock(spmuxcom, spmuxcom.length());
		}
		movienum++;
	    }
	    subtaken = sublang;	// Mark language as found
	}
	lsub = lsub->nextSibling();	// Find next unic language
    }

    file.close();		// Close spmuxmandvd.sh 

    // Find real subtitles for movie and replace dummys with the real ones
    movienum = 0;
    QString movielist[40][1];
    int movieidx = 0;
    QString tempmovie = "";

    while (movienum < max_boutons) {
	tempmovie = table_boutons_lien[movienum][1];

	if (tempmovie.contains("|||") != 1) {
	    movielist[movieidx][0] = table_boutons_lien[movienum][1];
	    movielist[movieidx][1] = table_boutons_lien[movienum][9];
	    movieidx++;
	}
	movienum++;
    }

    movienum = 0;

    while (movienum < totnumvideos) {
	subcounter = 0;
	QListViewItem *lsub = listViewSubTitle_2->firstChild();	// Subfile data

	while (lsub) {
	    // Check if sub availible for this movie
	    if (movielist[movienum][0] == lsub->text(2)) {
		// Generate a sub encode spmux xml file for every subtitle
		QString xmlappend = "";
		QString sublang = lsub->text(0);
		sublang = sublang.lower();
		sublang = sublang.left(2);	// Languagecode for sub
		QString subxmlfile;

		subxmlfile =
		    "spmuxGV" + QString::number(movienum) +
		    sublang + ".xml";

		// Try to read actual read movie framerate
		QString movieFR = movielist[movienum][1];

		if (movieFR.toDouble() == 0.0)
		    movieFR = QString::number(projfps);	// Else proj standard

		QFile sfile(path_out->text() + subxmlfile);
		if (sfile.open(IO_WriteOnly | IO_Truncate)) {
		    sfile.writeBlock("<subpictures>\n", 14);
		    sfile.writeBlock("   <stream>\n", 12);
		    xmlappend =
			"      <textsub filename=\"" + lsub->text(1) +
			"\"";
		    xmlappend =
			xmlappend + " characterset=\"ISO8859-1\"\n";
		    xmlappend =
			xmlappend +
			"\tfontsize=\"" + QString::number(fontsize) +
			"\" font=\"devedesans.ttf\"\n";
		    xmlappend =
			xmlappend +
			"\thorizontal-alignment=\"center\" vertical-alignment=\"bottom\"\n";
		    xmlappend =
			xmlappend +
			"\tleft-margin=\"60\" right-margin=\"60\" top-margin=\"20\" bottom-margin=\"30\"\n";
		    xmlappend =
			xmlappend + "\tsubtitle-fps=\"" + movieFR +
			"\" movie-fps=\"" + movieFR + "\"";
		    xmlappend =
			xmlappend + " movie-width=\"" +
			QString::number(projwid) +
			"\" movie-height=\"" +
			QString::number(projhau) + "\" />\n";
		    sfile.writeBlock(xmlappend, xmlappend.length());
		    sfile.writeBlock("   </stream>\n", 13);
		    sfile.writeBlock("</subpictures>\n", 15);
		    sfile.close();
		}
	    }
	    lsub = lsub->nextSibling();
	}
	movienum++;
    }

    file.close();

    if (btcancelencode->isEnabled())
	writeSpmuxXml();
    else
	fin_encode();
}

/* Launch a process to render all subs  */
void mainfrm::writeSpmuxXml()
{

    if (listViewSubTitle_2->firstChild() != 0) {
	lecture_console->append
	    (tr
	     ("\n--> Output from rendering substitles --------------------------------------------------\n"));

	proc_spmux = new QProcess(this);
	proc_spmux->addArgument("bash");
	proc_spmux->addArgument(path_out->text() + "/spmuxmandvd.sh");

	spmuxp->reset();
	spmuxp->raise();
	spmuxp->show();
	spmuxp->setProgress(0);
	btcancelencode->setDisabled(true);

	connect(proc_spmux, SIGNAL(readyReadStderr()), this,
		SLOT(ReadStdoutSpmux()));
	connect(proc_spmux, SIGNAL(processExited()), this,
		SLOT(doneSpmuxSubs()));

	if (!proc_spmux->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "spmux :-(");
	    bt_et_05->setEnabled(true);
	    btgrpprio->setEnabled(true);
	    buttonGroupAudio->setEnabled(true);
	    bt_gener_struct->setEnabled(true);
	    buttonGroup62->setEnabled(true);
	} else {
	    btcancelencode->setEnabled(true);
	}
    } else {
	fin_encode();
    }
}

/* Running when rendering subtitles and appending information to the console 
 * Pre : All movies must be encoded to go on the DVD 
 * Post: Subtitles has ben renderd into the movie */
void mainfrm::ReadStdoutSpmux()
{
    lineEdit1->setText(proc_spmux->readStderr());
    lecture_console->append(lineEdit1->text());

    tmp_001 = lineEdit1->text();
    int i = tmp_001.find("STAT:", 0, FALSE);

    if (i != -1) {
	tmp_001 = tmp_001.mid(i + 6, 7);
	spmuxp->setLabelText(tr("Rendering subtitle: ") + tmp_001);
    }

    tmp_001 = tmp_001.mid(2, 2);
    spmuxp->setProgress(tmp_001.toInt());

    if (spmuxp->wasCanceled()) {
	QMessageBox mb(MANDVDVER,
		       tr
		       ("Interrup rendering!\nYou need to start all over to encode again if you stop now.\nAre you sure?."),
		       QMessageBox::Question,
		       QMessageBox::Yes | QMessageBox::Default,
		       QMessageBox::No | QMessageBox::Escape,
		       QMessageBox::NoButton);

	if (mb.exec() == QMessageBox::Yes) {
	    proc_spmux->kill();
	    // Call function that aborts encoding also
	    btcancelencode_clicked();
	    fautyrencoder = 1;	// Need to reencode videos again!?
	} else
	    spmuxp->reset();
    }
}

/* Run after rendering of subs are ready 
 * Pre : Subtitles has ben renderd into the movie 
 * Post: (Optional if things to do are needed)
*/
void mainfrm::doneSpmuxSubs()
{
    // Things to do after spmuxing is done
    spmuxp->hide();
    spmuxp->reset();
    fin_encode();
}


/* Run by process that converts images with convert.
 * Adds output to program consol if any from process stderr.
*/
void mainfrm::convertImgStdout()
{
    lineEdit1->setText(imgconv->readStderr());
    tmp_001 = lineEdit1->text();
    lecture_console->append(lineEdit1->text());
}


/* Run after al videos has been encoded */
void mainfrm::fin_encode()
{
// ***********************************
// *** Fin de l'encodage des fichiers vido ***
// ***********************************
    btcancelencode->setDisabled(true);

    if (rc_002 == 0) {
	imgconv = new QProcess(this);
	imgconv->addArgument("bash");

	pb_001->setProgress(100);
	pb_002->setProgress(100);

// *** Cration des fichiers xml ***

	progress_fleche->setGeometry(32, 164, 22, 22);
	etape_1->setText("<b>" + table_message[56] + "</b>");

// **************************************
// *** Sauvegarde des diffrents tats du menu ***
// **************************************
	pb_007->setProgress(0);
	pb_008->setProgress(0);
	//
	QImage tmpimg = my_pixmap_001->pixmap()->convertToImage();
	QImage tmpimg_2;
	QImage tmpimg_3;
	QImage tmpimg_4;
	QImage tmpimg_5;

	if (projfps == 29) {
	    tmpimg_2 = tmpimg.smoothScale(720, 480);
	} else {
	    tmpimg_2 = tmpimg.smoothScale(720, 576, QImage::ScaleFree);
	}
	tmpimg_2.save(path_out->text() + "/normal.jpg", "JPEG", 100);
	tmpimg = my_pixmap_002->pixmap()->convertToImage();

	/* Encodeingmessage */
	textLabel1->setText(table_message[54] +
			    " DVD-Intro gibintromenu.mpg");

	if (projfps == 29) {
	    tmpimg_2 = tmpimg.smoothScale(720, 480);
	    tmpimg_5 = tmpimg_2.convertDepth(8);
	} else {
	    tmpimg_2 = tmpimg.smoothScale(720, 576);
	    tmpimg_5 = tmpimg_2.convertDepth(8);
	}

	tmpimg_5.setNumColors(4);
	QPixmap mypix_002(tmpimg_5);
	mypix_002.save(path_out->text() + "/survolee.png", "PNG");
	tmpimg = my_pixmap_003->pixmap()->convertToImage();

	if (projfps == 29) {
	    tmpimg_4 = tmpimg.smoothScale(720, 480);
	    tmpimg_3 = tmpimg_4.convertDepth(8);
	} else {
	    tmpimg = tmpimg.smoothScale(720, 576, QImage::ScaleFree);
	    tmpimg_3 = tmpimg.convertDepth(8);
	}

	tmpimg_3.setNumColors(4);
	QPixmap mypix_003(tmpimg_3);
	mypix_003.save(path_out->text() + "/cliquee.png", "PNG");

	if (maskeditDone) {
	    QString convscript =
		"convert " + wpathtotalproj +
		"cliquee.png -colors 2 -depth 8 " + wpathtotalproj +
		"cliquee.png\nconvert " + wpathtotalproj +
		"survolee.png -colors 2 -depth 8 " + wpathtotalproj +
		"survolee.png\n";
	    QFile sfile(wpathtotalproj + "/convertimg.sh");

	    if (sfile.open(IO_WriteOnly)) {
		sfile.writeBlock("#!/bin/bash\n", 12);
		sfile.writeBlock(convscript, convscript.length());
	    }
	    sfile.close();

	    imgconv = new QProcess(this);
	    imgconv->addArgument("bash");
	    imgconv->addArgument(wpathtotalproj + "convertimg.sh");
	    lecture_console->append(tr
				    ("--> Converting mask images to 4 colors -------------------------\n"));

	    connect(imgconv, SIGNAL(readyReadStderr()), this,
		    SLOT(convertImgStdout()));

	    connect(imgconv, SIGNAL(processExited()), this,
		    SLOT(ConfigMenu()));

	    if (!imgconv->start()) {
		QMessageBox::warning(this, MANDVDVER,
				     table_message[0] + "convert :-(");
	    }
	} else {
	    // No mask edit done - Move on
	    ConfigMenu();
	}
    } else {
	// Just move on. This is an effect of splitting into functions
	ConfigMenu();
    }
}

/* Configure DVD menu and continue to athor the disc */
void mainfrm::ConfigMenu()
{
    if (rc_002 == 0) {
	int compteur;
	compteur = 0;
	int compteur_1;
	int compteur_2;
	int compteur_3;
	int x_max;
	int y_max;
	tmp_001 = "";

	QFile myfic(path_out->text() + "/genmenu.xml");

	if (myfic.open(IO_WriteOnly)) {
	    myfic.writeBlock("<subpictures>\n", 14);
	    myfic.writeBlock("<stream>\n", 9);
	    myfic.writeBlock("<spu\n", 5);
	    myfic.writeBlock("force=\"yes\"\n", 12);
	    myfic.writeBlock("transparent=\"FFFFFF\"\n", 21);
	    myfic.writeBlock("start=\"00:00:00.00\"\n", 20);
	    myfic.writeBlock("select=\"cliquee.png\"\n", 21);
	    myfic.writeBlock("highlight=\"survolee.png\">\n", 26);

	    while (compteur < max_boutons) {
		x_max =
		    table_boutons_pos[compteur][0] +
		    table_boutons_pos[compteur][2];
		if (table_boutons_lien[compteur][7] == "") {
		    y_max =
			table_boutons_pos[compteur][1] +
			table_boutons_pos[compteur][3] + 7;
		    int t = y_max / 2;
		    y_max = t * 2;
		} else {
		    y_max =
			table_boutons_pos[compteur][1] +
			(table_boutons_pos[compteur][3] + 7);
		    int t = y_max / 2;
		    y_max = t * 2;
		}

		// *** CALCUL POUR NTSC CAR ON REDIMENSIONNE L'IMAGE DE 720x576 -> 720x480 ***
		if (projfps == 29) {
		    table_boutons_pos[compteur][1] =
			table_boutons_pos[compteur][1] / 1.2;
		    y_max = y_max / 1.2;
		    int t = y_max / 2;
		    y_max = t * 2;
		}
		//
		tmp_001 =
		    "<button name =\"" + QString::number(compteur) +
		    "\" x0 = \"" +
		    QString::number(table_boutons_pos[compteur][0]) +
		    "\" y0 = \"" +
		    QString::number(table_boutons_pos[compteur][1]) +
		    "\" x1 = \"" + QString::number(x_max) + "\" y1 = \"" +
		    QString::number(y_max) + "\"/>\n";

		myfic.writeBlock(tmp_001, tmp_001.length());
		compteur = compteur + 1;
	    }

	    myfic.writeBlock("</spu>\n", 7);
	    myfic.writeBlock("</stream>\n", 10);
	    myfic.writeBlock("</subpictures>\n", 15);
	    myfic.close();
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[8]);
	    bt_gener_struct->setEnabled(true);
	    bt_lire_DVD->setDisabled(true);
	    bt_grave->setDisabled(true);
	}

// *** G�n�ration des images pour le menu anim� ***
	if (path_fond == "Menu anime") {
	    compteur_1 = 0;
	    QPixmap local_pixmap;

	    compteur_2 = wfin - wdebut;
	    pb_007->setTotalSteps(compteur_2);
	    QImage myimg_local;

	    QPainter mypainter(this);

	    mypainter.end();
	    QImage tmpimg1;

	    QImage tmpimg2;

	    if (namemaskimport->text() != "") {
		QPixmap mypix8(namemaskimport->text());

		if (projfps == 29) {
		    tmpimg2 = mypix8.convertToImage();
		    tmpimg1 =
			tmpimg2.smoothScale(720, 480, QImage::ScaleFree);
		} else {
		    tmpimg2 = mypix8.convertToImage();
		    tmpimg1 =
			tmpimg2.smoothScale(720, 576, QImage::ScaleFree);
		}
	    }

	    while (compteur_1 < compteur_2) {

		tmp_001 = QString::number(compteur_1);
		tmp_002 = "gibmenanim000000";
		tmp_002.replace(tmp_002.length() - tmp_001.length(),
				tmp_001.length(), tmp_001);
		if (projfps == 29) {
		    tmpimg2.load(wpathtotalproj + "/" + tmp_002 + ".jpg");
		    myimg_local =
			tmpimg2.smoothScale(720, 480, QImage::ScaleFree);
		} else {
		    tmpimg2.load(wpathtotalproj + "/" + tmp_002 + ".jpg");
		    myimg_local =
			tmpimg2.smoothScale(720, 576, QImage::ScaleFree);
		}

		if (namemaskimport->text() != "") {
		    bitBlt(&myimg_local, 0, 0, &tmpimg1, 0, 0, 720, -1);
		}

		local_pixmap.convertFromImage(myimg_local);
		cache_pixmap->setPixmap(local_pixmap);

		mypainter.begin(cache_pixmap->pixmap());
		mypainter.setPen(couleur_1);
		mypainter.setFont(myfont);

		compteur_3 = 0;

		while (compteur_3 < max_boutons) {
		    if (table_boutons_lien[compteur_3][7] == "") {
			mypainter.drawText(table_boutons_pos[compteur_3]
					   [0],
					   (table_boutons_pos[compteur_3]
					    [1] +
					    (table_boutons_pos[compteur_3]
					     [3] / 2)) - 4,
					   table_boutons_lien[compteur_3]
					   [0]);
		    } else {
			wsavbtmenu.load(table_boutons_lien[compteur_3][7],
					0);
			mypainter.drawImage(table_boutons_pos[compteur_3]
					    [0],
					    table_boutons_pos[compteur_3]
					    [1],
					    wsavbtmenu.smoothScale
					    (table_boutons_pos[compteur_3]
					     [2],
					     table_boutons_pos[compteur_3]
					     [3], QImage::ScaleFree), 0, 0,
					    table_boutons_pos[compteur_3]
					    [2],
					    table_boutons_pos[compteur_3]
					    [3]);
		    }

		    compteur_3 = compteur_3 + 1;
		}
		mypainter.end();
		//
		cache_pixmap->pixmap()->save(wpathtotalproj + "/xxx" +
					     tmp_002 + ".jpg", "JPEG");
		pb_007->setProgress(compteur_1);
		compteur_1 = compteur_1 + 1;
	    }
	    pb_007->setProgress(compteur_2);
	} else {
	    pb_007->setProgress(pb_007->totalSteps());
	}
	// *** Generate menu.sh script for menu generation ***
	QFile myfic_3(path_out->text() + "/menu.sh");

	if (myfic_3.open(IO_WriteOnly)) {
	    tmp_001 = "#!/bin/sh\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "cd \"" + path_out->text() + "\"\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f ${1}.mpg\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -rf DVD\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());

	    if (path_fond_musical == "") {
		/* For no background sound in menu */
		// Lame changes forced some changes and testing here
		// tmp_001 = "dd if=/dev/zero bs=4 count=1920 | lame -b 128 -s 48 /dev/stdin > silent.mpa\n";
		/* Test with arecord since dd did not work anymore. */
		// tmp_001 = "arecord -d 2 </dev/zero  | lame -b 128 -s 48 /dev/stdin  silent.mpa\n";

		/* Ver 2.5-5: New command line wirh dd to work with lame 3.98 */
		tmp_001 =
		    "dd if=/dev/zero bs=4 count=1920 | lame -b 128 -s 48 -r - silent.mpa\n";
	    } else {
		tmp_001 =
		    "mplayer \"" + path_fond_musical +
		    "\" -vo null -ao pcm:file=\"" + path_out->text() +
		    "/silent.pcm\"\n";
		myfic_3.writeBlock(tmp_001, tmp_001.length());
		tmp_001 =
		    "nice -n " + QString::number(priority) +
		    " mp2enc -r 48000 -o silent.mpa < silent.pcm\n";
	    }

	    myfic_3.writeBlock(tmp_001, tmp_001.length());

	    // *** Test pour menu anim ***           
	    if (path_fond == "Menu anime") {
		if (sliderqos->value() == 0) {
		    tmp_006 = "2000";
		} else {
		    if (sliderqos->value() == 0) {
			tmp_006 = "5000";
		    } else {
			tmp_006 = "10000";
		    }
		}
		if (projfps == 25) {
		    tmp_001 =
			"jpeg2yuv -f " + QString::number(projfps) +
			" -I p -l " +
			QString::number(nbre_occur->value()) + " -j \"" +
			wpathtotalproj +
			"/xxxgibmenanim%06d.jpg\" | mpeg2enc -f 3 -b " +
			tmp_006 + " -n p -o ${1}.m2v\n";
		} else {
		    tmp_001 =
			"jpeg2yuv -f " + QString::number(projfps) +
			" -I p -l " +
			QString::number(nbre_occur->value()) + " -j \"" +
			wpathtotalproj +
			"/xxxgibmenanim%06d.jpg\" | mpeg2enc -f 3 -b " +
			tmp_006 + " -n n -o ${1}.m2v\n";
		}
		myfic_3.writeBlock(tmp_001, tmp_001.length());
	    } else {
		if (projfps == 25) {
		    // Experimental: ppmtoy4m -n 60 -F 25:1 -I -p |y4mscaler -O preset=3DDVD -O infer=3DEXACT | 
		    tmp_001 =
			"jpegtopnm ${2} | ppmtoy4m -n 1 -F 25:1 -I t -A 59:54 -L -S 420mpeg2 | mpeg2enc -f 8 -H -n p -o ${1}.m2v\n";
		} else {
		    tmp_001 =
			"jpegtopnm ${2} | pnmscale -xysize 720 480 | ppmtoy4m -n 1 -F 30000:1001 -I t -A 10:11 -L -S 420mpeg2 | mpeg2enc -f 8 -n n -o ${1}.m2v\n";
		}
		myfic_3.writeBlock(tmp_001, tmp_001.length());
	    }
	    tmp_001 =
		"mplex -f 8 -o /dev/stdout ${1}.m2v silent.mpa | spumux -m dvd -v 2 ${1}.xml > ${1}.mpg\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f xxxgibmen*.*\n";
	    myfic_3.writeBlock(tmp_001, tmp_001.length());
	    myfic_3.close();
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[8]);
	    buttonGroup62->setEnabled(true);
	    btgrpprio->setEnabled(true);
	    buttonGroupAudio->setEnabled(true);
	    bt_param_encode->setEnabled(true);
	    buttonGroupHQ->setEnabled(true);
	    bt_gener_struct->setEnabled(true);
	    bt_lire_DVD->setDisabled(true);
	    bt_grave->setDisabled(true);
	    bt_et_05->setEnabled(true);
	}

	// Call function to generate the dvdauth xml file
	writeDvdauthXml();
	spmuxp->hide();		// Shows up for some dam reason
	progress_fleche->setGeometry(32, 224, 22, 22);
	etape_3->setText("<b>" + table_message[58] + "</b>");

	lecture_console->append
	    (tr
	     ("--> Output from generation of menu  ------------------------------------------------------------"));

	rc_002 = 0;
	// Only start external process and exec menu.sh if not already done
	if (fautyrencoder == 1) {
	    proc_003 = new QProcess(this);
	    proc_003->addArgument("bash");
	    proc_003->addArgument(path_out->text() + "/menu.sh");
	    proc_003->addArgument("genmenu");
	    proc_003->addArgument("normal.jpg");

	    connect(proc_003, SIGNAL(readyReadStderr()), this,
		    SLOT(stdout_menu()));
	    connect(proc_003, SIGNAL(processExited()), this,
		    SLOT(fin_genmenu()));

/*
	Tell me if the shit hits the fan 
*/
	    if (!proc_003->start()) {
		// Trying some error handling
		QMessageBox::critical(0,
				      tr("Fatal error"),
				      tr
				      ("Could not start the uic command."),
				      tr("Quit"));
		exit(-1);
	    }
	}
	if (!proc_003->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "bash");
	    bt_gener_struct->setEnabled(true);
	    bt_param_encode->setEnabled(true);
	    buttonGroupHQ->setEnabled(true);
	    btgrpprio->setEnabled(true);
	    buttonGroupAudio->setEnabled(true);
	    bt_et_05->setEnabled(true);
	    buttonGroup62->setEnabled(true);
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[10]);
	buttonGroup62->setEnabled(true);
	bt_et_05->setEnabled(true);
	bt_gener_struct->setEnabled(true);
	btgrpprio->setEnabled(true);
	buttonGroupAudio->setEnabled(true);
	bt_param_encode->setEnabled(true);
	buttonGroupHQ->setEnabled(true);
	bt_lire_DVD->setDisabled(true);
	bt_grave->setDisabled(true);
    }
}


/* Cancelbutton clicked for abort of encoding! */
void mainfrm::btcancelencode_clicked()
{
    rc_002 = 1;
    proc_001->kill();
    btcancelencode->setDisabled(true);
}

/* This function generats the dvdauth.xml file for building the DVD */
void mainfrm::writeDvdauthXml()
{
    // *** Generate XML for DVD Author ***        
    int cpt_004;
    int cpt_005;
    int cpt_006;

    progress_fleche->setGeometry(32, 194, 22, 22);
    etape_2->setText("<b>" + table_message[57] + "</b>");
    QFile myfic_2(path_out->text() + "/dvdauthor.xml");

    int compteur = 0;

    if (myfic_2.open(IO_WriteOnly)) {
	/*
	   Maybe better if it is changed to UTF-8?  
	   tmp_001 = "<?xml version='1.0' encoding='iso-8859-15'?>";
	 */
	tmp_001 = "<?xml version='1.0' encoding='iso-8859-15'?>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "<dvdauthor dest=\"" + path_out->text() + "DVD\">\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	myfic_2.writeBlock("<vmgm>\n", 7);
	myfic_2.writeBlock("\t<fpc> jump menu 1; </fpc>\n", 27);
	myfic_2.writeBlock("\t<menus>\n", 9);

	if (projfps == 29) {
	    tmp_001 =
		"\t\t<video format=\"" + videostandard->currentText() +
		"\" aspect=\"" + aspectdvdauth +
		"\" resolution=\"720x480\" />\n";
	} else {
	    tmp_001 =
		"\t\t<video format=\"" + videostandard->currentText() +
		"\" aspect=\"" + aspectdvdauth +
		"\" resolution=\"720x576\" />\n";
	}

	myfic_2.writeBlock(tmp_001, tmp_001.length());
	//
	tmp_001 = "\t\t<pgc>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());

	if (pathintro != "") {
	    tmp_001 =
		"\t\t\t<vob file=\"" + path_out->text() +
		"/gibintromenu.mpg\" pause=\"0\" />\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	}

	if (startfilm->currentText() == "DVD_Menu") {
	    tmp_001 = "\t\t\t<post>jump titleset 1 menu;</post>\n";
	} else {
	    tmp_001 = "\t\t\t<post>jump title 1;</post>\n";
	}

	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "\t\t</pgc>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "\t</menus>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "</vmgm>\n\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());

	myfic_2.writeBlock("<titleset>\n", 11);
	tmp_001 = "\t<menus>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 =
	    "\t\t<video format=\"" + videostandard->currentText() +
	    "\" aspect=\"" + aspectdvdauth + "\" resolution=\"" +
	    QString::number(projwid) + "x" + QString::number(projhau) +
	    "\" />\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "\t\t<pgc>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());

	/*
	 */
	if (loopsound->currentText() == table_message[60]) {
	    tmp_001 =
		"\t\t\t<vob file=\"" + path_out->text() +
		"/genmenu.mpg\" pause=\"0\"/>\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "<post>jump cell 1;</post>\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	} else {
	    tmp_001 =
		"\t\t\t<vob file=\"" + path_out->text() +
		"/genmenu.mpg\" pause=\"inf\"/>\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	}

	int wl_cpt1 = 0;

	while (compteur < max_boutons) {
	    // *** Recherche de la position du titre ***
	    if (table_boutons_lien[compteur][3] == "$$CHAP$$") {
		cpt_006 = 0;
		tmp_010 = table_boutons_lien[compteur][1];
		rc_001 = tmp_010.find("|||", 0);

		if (rc_001 != -1) {
		    tmp_011 = tmp_010.mid(0, rc_001);
		    cpt_005 = 1;

		    while (tmp_011 != table_boutons_lien[cpt_006][0]
			   && cpt_006 < max_boutons) {
			if (table_boutons_lien[cpt_006][3] != "$$CHAP$$") {
			    cpt_005 = cpt_005 + 1;
			}
			cpt_006 = cpt_006 + 1;
		    }
		    if (tmp_011 == table_boutons_lien[cpt_006][0]) {
			tmp_001 =
			    "\t\t\t<button name=\"" +
			    QString::number(compteur) +
			    "\"> jump title " +
			    QString::number(cpt_005) + " chapter " +
			    tmp_010.mid(rc_001 + 3,
					tmp_010.length() - (rc_001 +
							    3)) +
			    "; </button>\n";
			myfic_2.writeBlock(tmp_001, tmp_001.length());
		    } else {
			printf(tr
			       ("Error generating XML file ! Contact me"));
		    }
		} else {
		    printf(tr("Error generating XML file ! Contact me"));
		}
	    } else {
		cpt_006 = 0;
		tmp_010 = table_boutons_lien[compteur][0];
		cpt_005 = 1;

		while (tmp_010 != table_boutons_lien[cpt_006][0]
		       && cpt_006 < max_boutons) {
		    if (table_boutons_lien[cpt_006][3] != "$$CHAP$$") {
			cpt_005 = cpt_005 + 1;
		    }
		    cpt_006 = cpt_006 + 1;
		}
		if (tmp_010 == table_boutons_lien[cpt_006][0]) {
		    tmp_001 =
			"\t\t\t<button name=\"" +
			QString::number(compteur) + "\"> jump title " +
			QString::number(cpt_005) + "; </button>\n";
		} else {
		    printf(tr("Error generating XML file ! Contact me"));
		}
		myfic_2.writeBlock(tmp_001, tmp_001.length());
	    }
	    compteur = compteur + 1;
	}

	tmp_001 = "\t\t</pgc>\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	tmp_001 = "\t</menus>\n\n";
	myfic_2.writeBlock(tmp_001, tmp_001.length());
	myfic_2.writeBlock("<titles>\n", 9);

	compteur = 0;
	cpt_005 = 0;

	/* Code for subtitles in dvdauth (Set all availible languages ! */
	listViewSubTitle_2->sort();
	QListViewItem *lsub = listViewSubTitle_2->firstChild();

	tmp_001 = "";
	QString sublang = "";
	QString subtaken = "";

	while (lsub) {
	    sublang = lsub->text(0);
	    sublang = sublang.lower();
	    sublang = sublang.left(2);

	    if (QString::compare(subtaken, sublang) != 0) {
		tmp_001 =
		    tmp_001 + "\t<subpicture lang=\"" + sublang +
		    "\" />\n";
		subtaken = sublang;
	    }
	    lsub = lsub->nextSibling();
	}

	myfic_2.writeBlock(tmp_001, tmp_001.length());
	//

	while (compteur < max_boutons) {
	    if (table_boutons_lien[compteur][3] != "$$CHAP$$") {
		myfic_2.writeBlock("\t\t<pgc>\n", 8);

		if (table_boutons_lien[compteur][3] == "") {	// No chapters
		    tmp_001 =
			"\t\t\t<vob file=\"" + path_out->text() +
			"/gibvideo" + QString::number(cpt_005) +
			".mpg\"/>\n";
		} else {
		    tmp_002 = table_boutons_lien[compteur][3];	// Chapters valid
		    tmp_001 =
			"\t\t\t<vob file=\"" + path_out->text() +
			"/gibvideo" + QString::number(cpt_005) +
			".mpg\" chapters=\"" + tmp_002.mid(0,
							   tmp_002.length()
							   - 9) + "\"/>\n";
		}
		myfic_2.writeBlock(tmp_001, tmp_001.length());
		// *** Que faire apr?s la lecture du fichier ***
		if (table_boutons_lien[compteur][4] == table_message[53]) {
		    tmp_001 = "\t\t\t<post>call menu;</post>\n";
		} else {
		    cpt_004 = 0;
		    wl_cpt1 = 1;
		    while (table_boutons_lien[cpt_004][0] !=
			   table_boutons_lien[compteur][4]
			   && cpt_004 < max_boutons) {
			if (table_boutons_lien[cpt_004][3] != "$$CHAP$$") {
			    wl_cpt1 = wl_cpt1 + 1;
			}
			cpt_004 = cpt_004 + 1;
		    }
		    if (table_boutons_lien[cpt_004][0] ==
			table_boutons_lien[compteur][4]) {
			tmp_001 =
			    "\t\t\t<post>jump title " +
			    QString::number(wl_cpt1) + ";</post>\n";
		    } else {
			tmp_001 = "\t\t\t<post>call menu;</post>\n";
		    }
		}
		myfic_2.writeBlock(tmp_001, tmp_001.length());
		tmp_001 = "\t\t</pgc>\n";
		myfic_2.writeBlock(tmp_001, tmp_001.length());
		cpt_005 = cpt_005 + 1;
	    }
	    compteur = compteur + 1;
	}
	myfic_2.writeBlock("</titles>\n", 10);
	myfic_2.writeBlock("</titleset>\n\n", 13);
	myfic_2.writeBlock("</dvdauthor>\n", 13);
	myfic_2.close();
// END


    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[8]);
	buttonGroup62->setEnabled(true);
	bt_gener_struct->setEnabled(true);
	bt_lire_DVD->setDisabled(true);
	bt_param_encode->setEnabled(true);
	buttonGroupHQ->setEnabled(true);
	bt_grave->setDisabled(true);
	bt_et_05->setEnabled(true);
    }
}


void mainfrm::stdout_menu()
{
// ******************************************
// *** Lecture de la sortie console g�n�ration menu ***   
// ******************************************

    lineEdit1->setText(proc_003->readStderr());
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("s->numpal", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    rc_001 = tmp_001.find(tr("ERROR"), 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    lecture_console->append(lineEdit1->text());
}

void mainfrm::stdout_dvdauth()
{
// ******************************************
// *** Lecture de la sortie console g�n�ration menu ***   
// ******************************************
    lineEdit1->setText(proc_003->readStderr());
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find(tr("Error:"), 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    rc_001 = tmp_001.find(tr("Error "), 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    rc_001 = tmp_001.find("%", 0);
    if (rc_001 != -1) {
	tmp_002 = tmp_001.mid(rc_001 - 2, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    pb_008->setProgress(rc_001);
	}
    }

    rc_001 = tmp_001.find(tr("WARN: Partial sector read"), 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    rc_001 =
	tmp_001.find(tr("PCI/DSI information is not where expected"), 0);
    if (rc_001 != -1) {
	rc_002 = 2;
    }

    lecture_console->append(lineEdit1->text());
}

/* Menu options to finalise DVD / Fin de la generation du menu */
void mainfrm::fin_genmenu()
{
    fautyrencoder = 0;		// Indikate that all is now reencoded to prevent it from doning so again. 
    if (rc_002 == 0) {
	lecture_console->append
	    ("--> Output from DVD Author ------------------------------------------------------------");
	rc_002 = 0;
	proc_003 = new QProcess(this);
	proc_003->addArgument("nice");
	proc_003->addArgument("-n");
	proc_003->addArgument(QString::number(priority));
	proc_003->addArgument("dvdauthor");
	proc_003->addArgument("-x");
	proc_003->addArgument(path_out->text() + "/dvdauthor.xml");

	connect(proc_003, SIGNAL(readyReadStderr()), this,
		SLOT(stdout_dvdauth()));
	connect(proc_003, SIGNAL(processExited()), this,
		SLOT(fin_totale()));

	if (!proc_003->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "dvdauthor");
	    bt_et_05->setEnabled(true);
	    buttonGroup62->setEnabled(true);
	}
    } else {
	if (rc_002 == 1) {
	    QMessageBox::warning(this, MANDVDVER, table_message[11]);
	    btgrpprio->setEnabled(true);
	    buttonGroupAudio->setEnabled(true);
	    bt_param_encode->setEnabled(true);
	    buttonGroupHQ->setEnabled(true);
	    bt_gener_struct->setEnabled(true);
	    bt_et_05->setEnabled(true);
	    buttonGroup62->setEnabled(true);
	}
    }
}

void mainfrm::fin_totale()
{
// **************
// *** fin totale ***   
// **************
    pb_008->setProgress(100);
    if (rc_002 == 0) {
	//
	spmuxp->hide();
	progress_fleche->hide();
	buttonGroup62->setEnabled(true);
	bt_gener_struct->setEnabled(true);
	bt_lire_DVD->setEnabled(true);
	bt_grave->setEnabled(true);
	bt_grave_2->setEnabled(true);
	bt_grave_3->setEnabled(true);
	bt_et_05->setEnabled(true);
	bt_param_encode->setEnabled(true);
	buttonGroupHQ->setEnabled(true);
	btgrpprio->setEnabled(true);
	buttonGroupAudio->setEnabled(true);
	QMessageBox::warning(this, MANDVDVER, table_message[12]);
	// *** D�zonage du DVD ***
	FILE *fd;

	QString pathfileifo;

	pathfileifo = path_out->text() + "/DVD/VIDEO_TS/VIDEO_TS.IFO";
	fd = fopen(pathfileifo, "r+");
	if (fd != NULL) {
	    fseek(fd, 0x23, SEEK_SET);
	    putc(0x0, fd);
	    fclose(fd);
	} else {
	    printf(pathfileifo);
	    printf(tr("File open Error"));
	}
    } else {
	progress_fleche->hide();
	buttonGroup62->setEnabled(true);
	bt_gener_struct->setEnabled(true);
	btgrpprio->setEnabled(true);
	buttonGroupAudio->setEnabled(true);
	bt_param_encode->setEnabled(true);
	buttonGroupHQ->setEnabled(true);
	QMessageBox::warning(this, MANDVDVER, table_message[13]);
	bt_et_05->setEnabled(true);
    }
}

/* Play video in xine */
void mainfrm::bt_lire_DVD_clicked()
{
// ****************************
// *** Test de la cr�ation du DVD ***
// ****************************
    proc_003 = new QProcess(this);
    proc_003->addArgument("xine");
    proc_003->addArgument("dvd:/" + path_out->text() + "/DVD/VIDEO_TS/");
    if (!proc_003->start()) {
	QMessageBox::warning(this, MANDVDVER, table_message[0] + "xine");
    }
}

/* Burn DVD with internal DVD-burner clicked */
void mainfrm::bt_grave_clicked()
{
// **********************************
// *** Affichage de la fen�tre de gravage ***
// **********************************
    Etape_05->setDisabled(true);
    textEdit3->hide();
    Gravage->setEnabled(true);
    Gravage->setGeometry(240, 254, 491, 280);
    Gravage->show();
    Gravage->raise();
}

/* Exit and do not burn */
void mainfrm::bt_annul_grave_clicked()
{
// *************************
// *** Annulation du gravage ***
// *************************
    Etape_05->setEnabled(true);
    Gravage->setDisabled(true);
    Gravage->hide();
}


/* Start to burn DVD button clicked */
void mainfrm::bt_go_grave_clicked()
{
// *************************
// *** Lancement du gravage ***
// *************************

    if (pathgraveur->text() != "") {
	QFile myfic(path_out->text() + "/gravage.sh");

	if (myfic.open(IO_WriteOnly)) {
	    tmp_001 = "#!/bin/sh\n";
	    myfic.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 =
		"growisofs -Z " + pathgraveur->text() + " -dvd-compat " +
		path_out->text() + "DVD\n";
	    myfic.writeBlock(tmp_001, tmp_001.length());
	}
	myfic.close();

	bt_annul_grave->setDisabled(true);
	bt_go_grave->setDisabled(true);

	proc_003 = new QProcess(this);
	proc_003->addArgument("bash");
	proc_003->addArgument(path_out->text() + "/gravage.sh");
	connect(proc_003, SIGNAL(readyReadStderr()), this,
		SLOT(stdout_grave()));
	connect(proc_003, SIGNAL(processExited()), this,
		SLOT(fin_grave()));
	if (!proc_003->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "growisofs");
	} else {
	    message_1->show();
	    rc_002 = 0;
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[14]);
    }
}


/* Check if burning succeded */
void mainfrm::fin_grave()
{
// ****************
// *** fin gravage ***   
// ****************
    if (rc_002 == 0) {
	pb_003->setProgress(100);
	message_1->hide();
	QMessageBox::warning(this, MANDVDVER, table_message[15]);
	bt_annul_grave->setEnabled(true);
	bt_go_grave->setEnabled(true);
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[16]);
	message_1->hide();
	bt_annul_grave->setEnabled(true);
	bt_go_grave->setEnabled(true);
    }
}

void mainfrm::stdout_grave()
{
// ****************************
// *** Lecture de la sortie console ***   
// ****************************
    lineEdit1->setText(proc_003->readStderr());
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("%", 0);
    if (rc_001 != -1) {
	tmp_002 = tmp_001.mid(1, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    pb_003->setProgress(rc_001);
	}
    }
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("error", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find(" not recognized", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    rc_001 = tmp_001.find("Unable", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    textEdit3->append(lineEdit1->text());
}
