
## distro/release specific support
%if 0%{?fedora} > 4 || 0%{?rhel} > 4
%define _with_hal --with-hal
%endif

%if 0%{?fedora} > 8
# include -devel subpkg or not? 1=yes
%else
%define devel 1
%endif

Name:    mandvd
Summary: Video DVD creation tool
Epoch:   0
Version: 2.5
Release: 5%{?dist}

Group:   Applications/Archiving
License: GPLv2+
Source: /usr/src/redhat/SOURCES/%{name}-%{version}-%{release}.tar.gz
URL:    http://www.kde-apps.org/content/show.php/ManDVD?content=83906

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
ExcludeArch: s390 s390x

Requires:       dvd-slideshow >= 0.7.5
Requires:       qt3
Requires:       k3b
Requires:       mplayer, mencoder
Requires:       ffmpeg
Requires:       gimp
Requires:       mkisofs >= 2.01
Requires:       xine >= 0.99.4
Requires:       lame >= 3.98
Requires:       alsa-utils >= 1.0.14-1
Requires:       dvdauthor >= 0.6.11
Requires:       mjpegtools >= 1.8.0
Requires:       netpbm >= 10.29
Requires:       transcode >= 1.0.2
Requires:       dvd+rw-tools >= 5.21.4

BuildRequires:  qt3-devel ImageMagick desktop-file-utils

%description
ManDVD is a graphical tool for creating Video DVDs, including menus.

%prep
#%setup -q -n ManDVD-%{version}src
#%setup -q -n mandvd
%setup -q  -n %{name}-%{version}
qmake mandvd.pro
#/usr/lib64/qt-3.3/bin/qmake mandvd.pro

perl -p -i -e 's/-O2/-O0/g' Makefile

%build
make %{?_smp_mflags}

%install
install -D -m 755 %{name} $RPM_BUILD_ROOT%{_bindir}/%{name}
install -D -m 644 mandvd.desktop $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop
install -D -m 644 mandvdico.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}.png
install -D -m 644 mandvdSplash.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/mandvdSplash.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --vendor kde --delete-original \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  --add-category X-Red-Hat-Base \
  $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop


%files
%defattr(-,root,root)
%{_bindir}/mandvd
%{_datadir}/applications/kde-mandvd.desktop
#%{_datadir}/applnk/.hidden/*.desktop
%{_datadir}/pixmaps/mandvd.png
%{_datadir}/pixmaps/mandvdSplash.png

%postun
/sbin/ldconfig
touch --no-create %{_datadir}/icons/hicolor ||:
gtk-update-icon-cache -q %{_datadir}/icons/hicolor 2> /dev/null ||:
update-desktop-database %{_datadir}/applications > /dev/null 2>&1 ||:

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Thu Mar 9 2009 Mikael Böhm <micko@bag.org> 2.5-5%{?dist}
- Fixed lame command to work again with lame 3.98

* Thu Jul 7 2008 Mikael Böhm <micko@bag.org> 2.5-4%{?dist}
- Fixed various bugs for computation of estimated DVD-size outcome
- Loading project recalculate estimated DVD-size
- Adjustments to calculation of final project size, hope its more accurate now
- Calculation only performed on files that shall be reencoded and more specific
  depending on input quality.
- Removed SVCD and VCD standards and replaced it with only CDV option which
  is the half-size DVD standard. Make reasonable quality with less space
- Fix bug so now its possible to remove intro video if its the last to remove
- Fix audio encoding to handle obscure bit rates when going to AC3
- Saved project files now handle Introduction Video better
- Saved project files does not have the same name that made things bad if
  different projects where stored in the same folder
- Various language updates in English and Portuguese
- New translation of German by Kai Regenstein <kr1962@gmx.de>

* Thu Jul 4 2008 Mikael Böhm <micko@bag.org> 2.5-3%{?dist}
- Fixed serious segfault bug in chapter management
- Removing any 00:00:00 chapter if set
- Fixed spec-file to install splash image on FC9
- Encoding message in Spinbox, movie path works better now
- Sorting out more source code in separate files
- Added support for Portuguese language from: Wille Marcel wille@riseup.net
- Experiment: Settings button to bring up settings again to be able to
  change things while program is running.

* Thu Jul 2 2008 Mikael Böhm <micko@bag.org> 2.5-2%{?dist}
- Trying to fix UTF8 problems with font encoding in interface
- Changing some language definitions to #define statements to
  make translations easier in the future.
- Starting to sort out source code in different files to
  make development easier. Specially to reduce compile time
- Program cleans up some more files after closing down
- Program closing not possible by clicking on main window without
  calling internal function for cleanup
- Global progress bar runs all the time
- Import of saved project restores Intro video
- New calculations for estimation of final project size. Before it was
  only infile size that was computated, estimating not encoding outcome
- Adding support for Swedish language
- First time start disable program until language is chosen

* Thu Jun 24 2008 Mikael Böhm <micko@bag.org> 2.5-1%{?dist}
- Spelling corrections and various text updates
- Spec-file clean up and qmake without absolute path. Hopefully src.rpm can now
  rebuild on i386 (rpmbuild --rebuild -ba mandvd-2.5-x.fc9.src.rpm)
- Added ffmpeg as required in spec-file

* Sat Jun 21 2008 Mikael Böhm <micko@bag.org> 2.5-0%{?dist}
- Experimental build for FC9 
- Changing resolution to be correct for PAL and NTSC standards
- Fixing audio encoding to AC3 and setting a default higher bitrate
- Experimental filters to improve deinterlacing with mencoder
- Changing and adding some buttons to the user interface

* Mon Jan 8 2007 Arkady L. Shane <ashejn@yandex-team.ru> 2.4-1%{?dist}
- initial build for fc6
