//
// C++ Implementation: mandvd
//
// Description: Generic functions for ManDVD interface fuctions
//
// Author  : Gibault Stphane
// Modifier: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "mandvd_global.h"
#include <mandvd.h>

#include <qfontdialog.h> 
#include <qmessagebox.h> 
#include <qcombobox.h>
#include <qspinbox.h>  
#include <qcheckbox.h> 
#include <qgroupbox.h> 
#include <qstringlist.h> 
#include <qstring.h> 
#include <qpixmap.h> 
#include <qimage.h> 
#include <qpainter.h> 
#include <qdatetime.h> 
#include <qcolor.h> 
#include <qiconview.h> 
#include <qfile.h> 
#include <qrect.h> 
#include <qlabel.h> 
#include <qbuttongroup.h> 
#include <qtoolbutton.h> 
#include <qcolordialog.h> 
#include <qprogressbar.h> 
#include <qlineedit.h> 
#include <qtextedit.h> 
#include <qtabwidget.h> 
#include <qslider.h> 
#include <qfileinfo.h> 
#include <qfiledialog.h> 
#include <qdir.h> 
#include <qtextstream.h> 
#include <qlistview.h> 
#include <qregexp.h> 
#include <qdatetimeedit.h> 
#include <qradiobutton.h> 

	/* Main methods for ManDVD */

	/* Showing about dialog */
	void
	mainfrm::aboutdialog_Clicked () {

	/* Just a simple soundtest :-p */ 
	QSound sound ("/usr/share/sounds/KDE_Click.wav");
	sound.play();

	QMessageBox::about (this, table_message[63] + MANDVDVER , table_message[64] + HOMEPG );

	}

	/* Show dialog for new project again to be able to change setting on the fly  */
	void
	mainfrm::bt_change_clicked () {

	QSound sound ("/usr/share/sounds/KDE_Click.wav");
	sound.play();

	Etape_02->setDisabled (true);
	toolButton72_2->setDisabled(true);

	newproj->show ();
	newproj->raise ();

	}
	
	/* Calulate size of the DVD: Need development to handle Xvid etc  */	
	void
	mainfrm::calculsize (int action) {
	// *** Calcul de la taille du DVD ***
	QFile myfic (path_video);
	unsigned long tmp_int_001;
	bool reencodeMe = true;

	/* Read num of frames with ffmpeg. Did not know about tcprobe hahaha */
	tmp_001 = "";

	/* Check if this is a video that shall be reencoded */
	QListViewItem *lvi = lst_video_1->firstChild ();
	
	while (lvi)
	{
	/* Check if this is */
	if( lvi->text(1) == path_video )
	  {
	    QString encode = lvi->text(2);
	    if ( lvi->text(2) == "1" )
		reencodeMe = true;
	    else
		reencodeMe = false;

	    break; // Bail out of while loop
	  }
        lvi = lvi->nextSibling();
	}

	/* Start a process to run ffmpeg on the video to determine size */
	proc_ffmpeg = new QProcess (this);
	proc_ffmpeg->addArgument( "ffmpeg" );
	proc_ffmpeg->addArgument( "-i" );
	proc_ffmpeg->addArgument( path_video );

        connect( proc_ffmpeg, SIGNAL(readyReadStderr()), this, SLOT(readFromMPStdout() ));

	if ( !proc_ffmpeg->start() )
		{
		  QMessageBox::warning (this, MANDVDVER, table_message[0] + "ffmpeg");
		}

	/* Wait for process to calculate size to finish */
	if( proc_ffmpeg->isRunning ())
           sleep(1);

	/* Variable action set to 3 means that its a video to be reencoded to add */
	if( proc_ffmpeg->normalExit() && reencodeMe )
	    {
	    if (tmp_001.toULongLong() > 0)
		tmp_int_001 = tmp_001.toULongLong();
	    else
		tmp_int_001 = (unsigned long) myfic.size ();

	    }
	else
	   {
	        tmp_int_001 = (unsigned long) myfic.size ();
    	   }

	/* Calculate the new size*/
	if (action == 0)
	{
	/* Adding a video to list */
	taille_DVD = taille_DVD + ((tmp_int_001 / 1024) / 1024);
	}
	else
	{
	/* Removing a video from list */
	taille_DVD = taille_DVD - ((tmp_int_001 / 1024) / 1024);
	}

	volume->setText (table_message[52] + "<b>" + QString::number (taille_DVD) + table_message[76] + 
			"<br />" + "DVD: "  + videostandard->currentText () + " " + videosizedef->currentText ()  );
	bt_et02_con->setEnabled (true);

	/* Disc "might be" full */
	if (taille_DVD > 4400)
	{
	QMessageBox::warning (this, MANDVDVER, table_message[5]);
	}

	// *** Compteur graphique ***
	QImage tmpimg_1 = prg_001->pixmap ()->convertToImage ();
	QImage tmpimg_2 = prg_002->pixmap ()->convertToImage ();
	QImage tmpimg_3 = prg_003->pixmap ()->convertToImage ();

	bitBlt (&tmpimg_1, 0, 0, &tmpimg_2, 0, 0, -1, -1);

	if (taille_DVD > 0)
	{
	int wposition;
	wposition = 128 - ((taille_DVD * 128) / 4400);
	if (wposition < 0)
		{
		wposition = 0;
		}
	bitBlt (&tmpimg_1, 0, wposition, &tmpimg_3, 0, wposition, -1, -1);
	}
	prg_001->setPixmap (tmpimg_1);

	/* Terminate child-process at exit */
 	proc_ffmpeg->tryTerminate ();
	QTimer::singleShot( 5000, proc_ffmpeg, SLOT( kill() ) );
}

/* This method runs as a QProcess and produces output in the program console
 * and also some encoding information to the GUI when encoding video.
**/
void
mainfrm::readFromMPStdout ()
{
  int wid, hig;
  double sizefactor,sizefactorHDTV ;
  QString wd, ht;

  unsigned long totalbytesmovie = 0;

  lineEdit1->setText (proc_ffmpeg->readStderr ());
  tmp_001 = lineEdit1->text ();

  int i = tmp_001.find( QRegExp("[0-9][0-9][0-9]x[0-9][0-9][0-9]"), 0 );
  
  sizefactor = 1.0;
  sizefactorHDTV = 1.0;

  if (i > 0)
   {
     wd = tmp_001.mid( i - 1 , 4 ); 
     ht = tmp_001.mid( i + 4 , 4 ); 
     wid = wd.toInt();
     hig = ht.toInt();

     /* Asuming higher input quality, calculate for more space */
     if( wid == 720 && hig > 480)
	{
	sizefactor = 1.2;
	}

     /* Asuming higher input quality, calculate for more space */
     if( wid > 720 && hig > 480)
	{
	sizefactor = 1.4;
        sizefactorHDTV = 1.2;
	}
   }

  tmp_001 = lineEdit1->text ();

  int j = tmp_001.contains( "Duration:" );
  if (j > 0)
    {
      int k = tmp_001.find( QRegExp("[0-9][0-9]:[0-5][0-9]:[0-5][0-9].[0-9],"), 0 );
      QString tmpstr = tmp_001.mid( k , 8 ); 
      tmp_001 = tmpstr;
    }

   /* Convert time to seconds */
   QString hr = tmp_001.left( 2 );
   QString mn = tmp_001.mid( 3, 2 );
   QString sk = tmp_001.right( 2 );

   int h = hr.toInt();
   int m = mn.toInt();
   int s = sk.toInt();

   /* Must be this type unsigned long, else computation errors */
   unsigned long totalsekmovie = h*3600 + m*60 + s;

if (projwid == 720)
   totalbytesmovie = totalsekmovie * SCALEFACTOR720 * sizefactorHDTV;
   else if (projwid == 480)
      totalbytesmovie = totalsekmovie * SCALEFACTOR480;
        else
          totalbytesmovie = totalsekmovie * SCALEFACTOR352 * sizefactor;

   QString string;
   tmp_001 = string.setNum( totalbytesmovie );
}

void
mainfrm::get_video_format ()
{
  tmp_012 = "";
  lineEdit1->setText (proc_format->readStdout ());
  tmp_012 = lineEdit1->text ();
}

	/* Main dialog functions */

/* This sets the current working standard for this video project at startup */	
void mainfrm::videostandard_highlighted (const QString & txtvar) 
        {
	QString txtvalue = txtvar;

	if (txtvalue == "PAL")
	{
	videosizedef->clear ();
	videosizedef->insertItem (PALDVD);
//	videosizedef->insertItem (PALSVCD);
	videosizedef->insertItem (PALVCD);
	videosizedef->setCurrentItem (0);
	}
	else
	{
	videosizedef->clear ();
	videosizedef->insertItem (NTSCDVD);
//	videosizedef->insertItem (NTSCSVCD);
	videosizedef->insertItem (NTSCVCD);
	videosizedef->setCurrentItem (0);
	}
	}

/* This function will set resolution for the DVD from the selected value from start */
void
mainfrm::toolButton72_clicked () {

	if (lineEdit11->text () != "")
	{
		newproj->hide ();
		
		QString wl_qtr1 = videosizedef->currentText ();
		QString wl_qtr2;
		QString wid, hau;
	
		wl_qtr2 = wl_qtr1.mid (0, 3);
		rc_001 = wl_qtr2.toInt (&ok, 10);
	
		if (ok != true)
			{
			projwid = 720;
			}
		else
			{
			projwid = rc_001;
			}
	
		wl_qtr2 = wl_qtr1.mid (4, 3);
		rc_001 = wl_qtr2.toInt (&ok, 10);
	
		if (ok != true)
			{
			projhau = 576;
			}
		else
			{
			projhau = 576; // Always 576 now on theese standards 
			//projhau = rc_001;
			}
	
		if (videostandard->currentText () == "PAL")
			{
			projfps = 25;
			}
		else
			{
			projfps = 29;
			projhau = 480;	// Setting standard resolution for NTSC (Mikael)
			}
	
		wid = wid.setNum(projwid);    
		hau = hau.setNum(projhau); 
	
		wpathtotalproj = lineEdit11->text ();
		path_out->setText (wpathtotalproj);
		Etape_02->setEnabled (true);
	
		QPixmap wl_pix1 (90, 61);
		::bitBlt (&wl_pix1, 0, 0, m_pMPlayerWidget, 10, 0, 90, 61, Qt::CopyROP,
			false);
		QImage wl_img1 = prevmaskfilm->pixmap ()->convertToImage ();
		QImage wl_img2 = prevmaskfilm_2->pixmap ()->convertToImage ();
		QPixmap wl_pix2 (wl_img1);
		QPixmap wl_pix3 (wl_img2);
		::bitBlt (&wl_pix3, 5, 5, &wl_pix1, 0, 0, -1, -1, Qt::CopyROP, false);
		::bitBlt (&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
	
		bt_ajout_intro->setEnabled (true);

		/* Resset size to zero and recalculate */
		taille_DVD = 0;
	
		/* Prepare to run thru the lists of movies */
		QListViewItem *lvi = lst_video_1->firstChild ();
	
		/* Now, run thru the lists of movies and claculate size and set encoding info on all items */
		while( lvi ) 
		{
			panneau_titre->setEnabled (true);
			path_video = lvi->text(1); // This sets the video to be calculated for sixe too !
			video_size_ok = 0; video_codec_ok = 0; audio_freq_ok = 0;
	
			/* Check if vido standard is ok to not reencode */
			a_reencoder = "";
	
			// *** Pickup video information ***
			proc_format = new QProcess (this);
			proc_format->addArgument ("tcprobe");
			proc_format->addArgument ("-i");
			proc_format->addArgument (path_video);
	
			connect (proc_format, SIGNAL ( readyReadStdout() ), this, SLOT ( get_video_format() ));
	
			if (!proc_format->start ())
			{
			QMessageBox::warning (this, MANDVDVER, table_message[0] + "tcprobe");
			}
	
			/* Wait for process to get video info to finish */
			if( proc_format->isRunning ())
			sleep(1);
	
			if( proc_format->normalExit() ){
				rc_001 = tmp_012.find (" " + wid + "x" + hau , 0);
				if (rc_001 != -1){
				video_size_ok = 1;
				}
	
				rc_001 = tmp_012.find ("PTS", 0);
			
				if (rc_001 != -1)
				video_codec_ok = 1;
			
				rc_001 = tmp_012.find ("48000", 0);
			
				if (rc_001 != -1)
				audio_freq_ok = 1;
		
				if ( video_size_ok == 0 || video_codec_ok == 0 || audio_freq_ok == 0 ) 
					a_reencoder = "1";
				else
					a_reencoder = "0";
			}
	
			/* Set encoding info */
			lvi->setText(2, a_reencoder);
	
			/* Could be devloped to handle no reencode in other formats if movies match */
			if ( projwid != 720 ) {
			lvi->setText(2, "1"); // Obviously all movies should be reecoded since it not a standard DVD project
			}
	
			/* Try to set symbol right to show that this video should be reencoded */
			if( lvi->text(0) != "Introduction video" ){
	
				if ( lvi->text(2) == "1" ) 
				{
				QImage wl_img1 = lvi->pixmap (0)->convertToImage ();
				QPixmap wl_pix1 (wl_img1);
			
				QImage wl_img2 = previcon_3->pixmap ()->convertToImage ();
				QImage im_audio = mp3_icon->pixmap ()->convertToImage ();

				QPixmap px_audio (im_audio);
				QPixmap wl_pix2 (wl_img2);

				::bitBlt (&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
				::bitBlt (&wl_pix1, 70, 45, &px_audio, 0, 0, 12, 12, Qt::CopyROP, false);

				theformat->setPixmap(px_audio);
				lvi->setPixmap (0, wl_pix1);
				bt_force->setDisabled (true);
				}
				else
				{
				QImage wl_img1 = lvi->pixmap (0)->convertToImage ();
				QPixmap wl_pix1 (wl_img1);
			
				QImage wl_img2 = previcon_2->pixmap ()->convertToImage ();
				QImage im_audio = mp3_icon->pixmap ()->convertToImage ();

				QPixmap px_audio (im_audio);
				QPixmap wl_pix2 (wl_img2);

				::bitBlt (&wl_pix1, 70, 45, &px_audio, 0, 0, 12, 12, Qt::CopyROP, false);
				::bitBlt (&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);

				lvi->setPixmap (0, wl_pix1);
				theformat->setPixmap(px_audio);
				bt_force->setEnabled (true);
				}
			}
	
			/* Terminate child-process */
			proc_format->tryTerminate ();
			QTimer::singleShot( 500, proc_format, SLOT( kill() ) );
		
			calculsize (0);
			lvi = lvi->nextSibling();
			}
		/* Need to sort, otherwise bizzare effects with size and intromovie */
		lst_video_1->setSorting (2, true);
		lst_video_1->sort ();

		/* Prepare to run thru the lists of movies again */
		QListViewItem *lst_v = lst_video_1->firstChild ();
	
		while ( lst_v ){
		/* Disable intro video button if Intro is found. Here it has to be string "9" !? Wierd :-p  */
			if( lst_v->text(0) == "Introduction video" ){
		
			/* Try to restore introduction video */
			lst_video_1->takeItem (lst_v);
	
			QListViewItem *i = new QListViewItem (lst_video_1, "Introduction video", path_video, "9",
						"", "", video_format, "", "");
			i->setPixmap (0, *previcon_1->pixmap ());
			bt_ajout_intro->setDisabled (true);
			bt_supprime_video->setEnabled (true);
			break;
			}
		lst_v = lst_v->nextSibling();
		}
	}
	else
	{
	   QMessageBox::warning (this, MANDVDVER, table_message[9]);
	}
}

	void
	mainfrm::toolButton72_2_clicked () {
	this->close ();
	}

	/* Capure a pic from the imported video and show it in the list */
	void
	mainfrm::capture_image_film () {
	QPixmap wl_pix1 (90, 61);
	::bitBlt (&wl_pix1, 0, 0, m_pMPlayerWidget, 10, 0, 90, 61, Qt::CopyROP,
		false);
	QImage wl_img1 = prevmaskfilm->pixmap ()->convertToImage ();
	QImage wl_img2 = prevmaskfilm_2->pixmap ()->convertToImage ();
	QPixmap wl_pix2 (wl_img1);
	QPixmap wl_pix3 (wl_img2);
	::bitBlt (&wl_pix3, 5, 5, &wl_pix1, 0, 0, -1, -1, Qt::CopyROP, false);
	::bitBlt (&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
	tmp_001 = textLabel2_11->text ();

	rc_002 = tmp_001.find (":", 0);
	
	if (rc_002 != -1)
	{
	tmp_002 = tmp_001.mid (rc_002 + 2, tmp_001.length () - (rc_002 + 2));
	}

	if (tmp_002 != QString::number (avvalue->value ()))
	{
	a_reencoder = "1";
	}
	wchapitres = "";
	QListViewItem *i = new QListViewItem (lst_video_1, titre_element->text (), path_video,
			a_reencoder, wchapitres,
			QString::number (audio_bitrate), video_format,
			"$$" + tmp_002 + "##" +
			QString::number (avvalue->value ()),
			lineEdit8->text ());

	if (a_reencoder == "0")
	{
	QImage wl_img3 = previcon_2->pixmap ()->convertToImage ();
	QPixmap wl_pix4 (wl_img3);
	::bitBlt (&wl_pix3, 3, 20, &wl_pix4, 0, 0, -1, -1, Qt::CopyROP, false);
	i->setPixmap (0, wl_pix3);
	}
	else
	{
	QImage wl_img3 = previcon_3->pixmap ()->convertToImage ();
	QPixmap wl_pix4 (wl_img3);
	::bitBlt (&wl_pix3, 3, 20, &wl_pix4, 0, 0, -1, -1, Qt::CopyROP, false);
	i->setPixmap (0, wl_pix3);
	}

	wchapitres = "";
	panneau_titre->hide ();
	panneau_bouton_1->setEnabled (true);
	nombre_video = nombre_video + 1;
	
	lst_video_1->setEnabled (true);
	bt_modifier_titre->setEnabled (true);
	bt_gest_sub_2->setEnabled (true);
	bt_supprime_video->setEnabled (true);
	bt_chapitres->setEnabled (true);
	bt_gest_sub->setEnabled (true);
	bt_cut_film->setEnabled (true);
	panneau_bouton_1->setEnabled (true);
	
	/*
	Setting defaultvalues on radiobuttons 
	*/
	if (video_format == "4/3")
	{
	btformat->setChecked (true);
	btformat_2->setChecked (false);
	}
	else
	{
	btformat->setChecked (false);
	btformat_2->setChecked (true);
	}
	
	/*
	Audioencoding default settings 
	*/
	audioencode->setChecked (true);
	audioencode2->setChecked (false);
	
	// *** Calcul de la taille du DVD ***
	calculsize (0);
	//   
	lst_video_1->setSelected (i, true);
	panneau_titre->setEnabled (true);
	}
	



	/* Open an image file for import for menu background */		
	void
	mainfrm::bt_charg_wall_clicked () {
	// ***************************
	// *** Slection du fond d'cran ***
	// ***************************
	QString myfic = QFileDialog::getOpenFileName (dossier_travail_2,
							"Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)",
							this, table_message[65], table_message[67] );
	if (myfic.isNull ())
	{
	}
	else
	{
	int i = myfic.findRev ('/');

	if (i != 1)
		{
		dossier_travail_2 = myfic.mid (0, i);
		}
	else
		{
		dossier_travail_2 = myfic;
		}

	QImage myimg (myfic, 0);
	QImage myimg_2 = myimg.scale (720, 576, QImage::ScaleMin);

	QPixmap mypix (myimg_2);
	QPixmap wl_pix1 (720, 576);
	wl_pix1.fill (Qt::black);
	QImage wl_img1 = wl_pix1.convertToImage ();
	::bitBlt (&wl_pix1, (720 - mypix.width ()) / 2,
			(576 - mypix.height ()) / 2, &mypix, 0, 0, -1, -1,
			Qt::CopyROP, false);
	QImage wl_img2 = wl_pix1.convertToImage ();
	apercu_fond->setPixmap (wl_pix1);
	path_fond = myfic;
	save_fond = wl_img2.copy (0, 0, 720, 576, 0);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap (wl_pix1);
	boite_effets->setEnabled (true);
	}
	}
	
	/* Probably sliders to fixate the menu position */
	void
	mainfrm::slider_x_valueChanged (int) {
	// **********************************
	// *** Dplacement horizontal du bouton ***
	// **********************************
	clqconstruct->setGeometry (1001, 0, longueur, hauteur);
	clqconstruct->setPixmap (save_fond_2.copy
				(slider_x->value (), slider_y->value (), longueur,
				hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter (this);
	mypainter.end ();
	mypainter.begin (clqconstruct->pixmap ());
	
	if (wpathbtmenu == "")
	{
	mypainter.setPen (couleur_1);
	mypainter.setFont (myfont);
	mypainter.drawText (0, hauteur / 2, nomfilm);
	}
	else
	{
	mypainter.drawImage (0, 0,
				wsavbtmenu.scale (longueur, hauteur,
						QImage::ScaleFree), 0, 0, -1,
				-1);
	}
	mypainter.end ();
	// *** On dplace les rgles ***
	regle_1->setGeometry (22 + slider_x->value (), 23, 1, 576);
	//
	if (23 + slider_x->value () > 400)
	{
	bt_dyna_modif->setGeometry (33, 40, 240, 250);
	}
	else
	{
	if (23 + slider_x->value () < 300)
		{
		bt_dyna_modif->setGeometry (490, 40, 240, 250);
		}
	}
	bt_fantome->setGeometry (23 + slider_x->value (), 23 + slider_y->value (),
				longueur, hauteur);
	::bitBlt (bt_fantome, 0, 0, clqconstruct->pixmap (), 0, 0, longueur,
		hauteur, Qt::CopyROP, false);
	}
	
	void
	mainfrm::slider_y_valueChanged (int) {
	// ********************************
	// *** Dplacement vertical du bouton ***
	// ********************************
	clqconstruct->setGeometry (1001, 0, longueur, hauteur);
	clqconstruct->setPixmap (save_fond_2.copy
				(slider_x->value (), slider_y->value (), longueur,
				hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter (this);
	mypainter.end ();
	mypainter.begin (clqconstruct->pixmap ());
	
	if (wpathbtmenu == "")
	{
	mypainter.setPen (couleur_1);
	mypainter.setFont (myfont);
	regle_2->setGeometry (23, 23 + slider_y->value () + taille_police + 2,
				720, 1);
	mypainter.drawText (0, hauteur / 2, nomfilm);
	// *** On dplace les rgles ***
	}
	else
	{
	mypainter.drawImage (0, 0,
				wsavbtmenu.scale (longueur, hauteur,
						QImage::ScaleFree), 0, 0, -1,
				-1);
	// *** On dplace les rgles ***
	regle_2->setGeometry (23, 23 + slider_y->value () + hauteur + 2, 720,
				1);
	
	}
	mypainter.end ();
	bt_fantome->setGeometry (23 + slider_x->value (), 23 + slider_y->value (),
				longueur, hauteur);
	::bitBlt (bt_fantome, 0, 0, clqconstruct->pixmap (), 0, 0, longueur,
		hauteur, Qt::CopyROP, false);
	}

/* Code for modifying and generation of DVD-menu (Best guess ) */ 
void
mainfrm::bt_valid_bt_clicked () {
// *******************************************

	// *** On dessine les boutons dans les diffrents tats ***
	// *******************************************
	// *** On cache le bouton fantme ***
	bt_fantome->hide ();
	bt_renew_all->setEnabled (true);
	bt_dyna_modif->hide ();
	// *** Blocage des sliders ***
	slider_x->setDisabled (true);
	slider_y->setDisabled (true);
	bt_valid_bt->setDisabled (true);
	bt_et04_con_2->setDisabled (true);
	after_lire->setDisabled (true);
	bt_annul_create_bt->setDisabled (true);
	// *** Chargement du bouton en mmoire ***
	QImage tmpimg = my_pixmap_001->pixmap ()->convertToImage ();
	QImage myimg = clqconstruct->pixmap ()->convertToImage ();
	// ********* IMAGE STANDARD *********
	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt (&tmpimg, slider_x->value (), slider_y->value (), &myimg, 0, 0,
		longueur, hauteur);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_001 (tmpimg);
	my_pixmap_001->setPixmap (mypix_001);
	
	if (wpathbtmenu == "")
	{
	// ********* IMAGE SURVOLEE *********
	tmpimg = my_pixmap_002->pixmap ()->convertToImage ();
	myimg = bt_fantome_2->pixmap ()->convertToImage ();
	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt (&tmpimg, slider_x->value (), slider_y->value () + (hauteur / 2),
		&myimg, 0, 0, longueur, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_002 (tmpimg);
	my_pixmap_002->setPixmap (mypix_002);
	
	// ********* IMAGE CLIQUEE *********
	tmpimg = my_pixmap_003->pixmap ()->convertToImage ();
	myimg = bt_fantome_3->pixmap ()->convertToImage ();
	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt (&tmpimg, slider_x->value (), slider_y->value () + (hauteur / 2),
		&myimg, 0, 0, longueur, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_003 (tmpimg);
	my_pixmap_003->setPixmap (mypix_003);
	}
	else
	{
	// ********* IMAGE SURVOLEE *********
	tmpimg = my_pixmap_002->pixmap ()->convertToImage ();
	myimg = bt_fantome_2->pixmap ()->convertToImage ();
	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt (&tmpimg, slider_x->value (), slider_y->value () + (hauteur - 2),
		&myimg, 0, 0, longueur, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_002 (tmpimg);
	my_pixmap_002->setPixmap (mypix_002);
	
	// ********* IMAGE CLIQUEE *********
	tmpimg = my_pixmap_003->pixmap ()->convertToImage ();
	myimg = bt_fantome_3->pixmap ()->convertToImage ();
	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt (&tmpimg, slider_x->value (), slider_y->value () + (hauteur - 2),
		&myimg, 0, 0, longueur, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_003 (tmpimg);
	my_pixmap_003->setPixmap (mypix_003);
	}
	
	// *** Sauvegarde des informations du bouton ***
	if (slider_x->value () > 0)
	{
	table_boutons_pos[max_boutons][0] = slider_x->value ();
	}
	else
	{
	table_boutons_pos[max_boutons][0] = 0;
	}
	if (slider_y->value () > 0)
	{
	table_boutons_pos[max_boutons][1] = slider_y->value ();
	}
	else
	{
	table_boutons_pos[max_boutons][1] = 0;
	}
	if (longueur < 720)
	{
	table_boutons_pos[max_boutons][2] = longueur;
	}
	else
	{
	table_boutons_pos[max_boutons][2] = 720;
	}
	if (hauteur < 576)
	{
	table_boutons_pos[max_boutons][3] = hauteur;
	}
	else
	{
	table_boutons_pos[max_boutons][3] = 576;
	}
	table_boutons_pos[max_boutons][4] = audio_bitrate;
	table_boutons_lien[max_boutons][0] = nomfilm;
	table_boutons_lien[max_boutons][1] = path_video;
	table_boutons_lien[max_boutons][2] = a_reencoder;
	table_boutons_lien[max_boutons][3] = wchapitres;
	table_boutons_lien[max_boutons][4] = after_lire->currentText ();
	if (yasubtitle == 1)
	{
	table_boutons_lien[max_boutons][5] =
		video_format + "$$$" + path_subtitle;
	}
	else
	{
	table_boutons_lien[max_boutons][5] = video_format;
	}
	table_boutons_lien[max_boutons][6] = type_video;
	table_boutons_lien[max_boutons][7] = wpathbtmenu;
	
	// *** Suppression de la liste de la listview ***
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	delete i;
	}
	// *** Dblocage de la liste et du bouton ***
	lst_video_2->setEnabled (true);
	bt_et04_con->setEnabled (true);
	bt_et04_con_2->setEnabled (true);
	bt_rename_chap->setDisabled (true);
	
	if (lst_video_2->childCount () == 0)
	{
	bt_tab_order->setEnabled (true);
	bt_maskedit->setEnabled (true);
	bt_add_film_menu->setDisabled (true);
	}
	else
	{
	bt_add_film_menu->setEnabled (true);
	}
	max_boutons = max_boutons + 1;
	
	regle_1->hide ();
	regle_2->hide ();
	}


/* Move to next layout from start window menu to background in main program or move back */
void
mainfrm::bt_et02_con_clicked () {
// *** Validation pour passage � l'�tape 3 ***
int nbremini = 0;
if (bt_ajout_intro->isEnabled () == false)
{
nbremini = 1;
}
if (nombre_video > nbremini)
{
Etape_02->hide ();
idtpage->setText (table_message[31]);
Etape_03->setGeometry (0, 110, 1000, 700);

if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}

vframe->hide ();
fautyrencoder = 1;
Etape_03->show ();
}
else
{
QMessageBox::warning (this, MANDVDVER, table_message[2]);
}
}

/* Move to next layout in main program or move back */
void
mainfrm::bt_et04_con_2_clicked () {
// *** Validation pour retour  l'tape 3 ***
if (max_boutons == 0)
{
Etape_04->hide ();
idtpage->setText (table_message[31]);
Etape_03->setGeometry (0, 110, 1000, 700);
Etape_03->show ();
}
else
{
if (QMessageBox::question
	(this, MANDVDVER, table_message[3], table_message[61], table_message[62], QString::null, 0,
	1) == 0)
	{
	max_boutons = 0;
	QPixmap mypix (save_fond);
	apercu_fond->setPixmap (mypix);
	my_pixmap_001->setPixmap (mypix);
	Etape_04->hide ();
	idtpage->setText (table_message[31]);
	Etape_03->setGeometry (0, 110, 1000, 700);
	Etape_03->show ();
	}
}
}

void
mainfrm::bt_et03_con_2_clicked () {

// ***********************************
// *** Validation pour passage ï¿œ l'ï¿œtape 2 ***
// ***********************************
Etape_03->hide ();
idtpage->setText (table_message[30]);
Etape_02->setGeometry (0, 110, 1000, 700);
vframe->setGeometry (31, 125, 115, 71);
vframe->show ();
vframe->raise ();
Etape_02->show ();
}

/* Move away from layaut main window background to window create DVD-menu */ 
void
mainfrm::bt_et03_con_clicked () {

// ***********************************
// *** Validation pour passage  l'tape 4 ***
// ***********************************
if (path_fond != "")
{
QString tmp_007;
Etape_03->hide ();
idtpage->setText (table_message[32]);
bt_dyna_modif->hide ();
// *** Chargement de la liste des vidos ***
lst_video_2->clear ();

int cpt_001 = 0;
int cpt_002;
int cpt_003;
after_lire->clear ();
after_lire->insertItem (table_message[53], -1);

QListViewItem *j;
QListViewItem *lvi = lst_video_1->firstChild ();

while (cpt_001 < nombre_video && cpt_001 < 39)
	{
	if (lvi->text (2) != "9") // Dont add intro video!
	{
	tmp_001 = lvi->text (0);
	tmp_002 = lvi->text (1);
	tmp_003 = lvi->text (2);
	tmp_004 = lvi->text (3);
	tmp_005 = lvi->text (4);
	tmp_006 = lvi->text (5);
	tmp_007 = lvi->text (6);
	tmp_008 = lvi->text (7);
	after_lire->insertItem (tmp_001, -1);
	j =
		new QListViewItem (lst_video_2, tmp_001, tmp_002, tmp_003,
				tmp_004, tmp_005, tmp_006, tmp_007,
				tmp_008);

	if (tmp_004.length () > 0)
		{
		cpt_002 = 0;
		cpt_003 = 1;
		while (tmp_004.mid (cpt_002, 8) != "        ")
		{
		new QListViewItem (j,
					prefchap + " " +
					QString::number (cpt_003),
					tmp_001 + "|||" +
					QString::number (cpt_003 + 1), "0",
					"$$CHAP$$", tmp_005, tmp_006,
					tmp_007, "");
		cpt_002 = cpt_002 + 9;
		cpt_003 = cpt_003 + 1;
		}
		}
	}
	lvi = lvi->nextSibling ();
	cpt_001 = cpt_001 + 1;
	}

Etape_04->setGeometry (0, 110, 1000, 700);
my_pixmap_002->setPixmap (*emptymask->pixmap ());
my_pixmap_003->setPixmap (*emptymask->pixmap ());
bt_rename_chap->setDisabled (true);
bt_tab_order->setDisabled (true);
bt_maskedit->setDisabled (true);
bt_add_film_menu->setEnabled (true);
Etape_04->show ();
}
else
{
QMessageBox::warning (this, MANDVDVER, table_message[4]);
}
}

/* Button clicked to go to last menu for generating DVD */	
void
mainfrm::bt_et04_con_clicked () {
// ***********************************
// *** Validation pour passage  l'tape 5 ***
// ***********************************
if (max_boutons > 0)
{
if (lst_video_2->childCount () == 0)
	{
	Etape_04->hide ();
	startfilm->clear ();
	startfilm->insertItem ("DVD_Menu", -1);
	startfilm->insertItem (table_boutons_lien[0][0], -1);
	idtpage->setText (table_message[33]);
	optencode->hide ();
	Etape_05->setGeometry (0, 110, 1000, 700);
	Etape_05->show ();
	}
else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[7]);
	}
}
else
{
QMessageBox::warning (this, MANDVDVER, table_message[7]);
}
}

/* Go back to menu 4 */ 
void
mainfrm::bt_et_05_clicked () {
// ******************
// *** Retour �tape 4 ***
// ******************
Etape_05->hide ();
myconsole->hide ();
idtpage->setText (table_message[32]);
Etape_04->setGeometry (0, 110, 1000, 700);
bt_rename_chap->setDisabled (true);
Etape_04->show ();
}



/* Add a video to the project in main menu */
void
mainfrm::add_video_clicked () {
	// *************************************
	// *** Ajout d'une vid�o � la liste des fichiers ***
	// *************************************
	
	if (nombre_video < 19)
	{
	QString myfic = QFileDialog::getOpenFileName (dossier_travail_2,
							"Videos (*.mpg *.MPG *.mpeg *.MPEG *.VOB *.vob *.avi *.AVI)",
							this, table_message[65], table_message[66] );
	if (myfic.isNull ())
		{
		}
	else
		{
		int i = myfic.findRev ('/');
		if (i != 1)
		{
		dossier_travail_2 = myfic.mid (0, i);
		}
		else
		{
		dossier_travail_2 = myfic;
		}
		video_size_ok = 0;
		video_codec_ok = 0;
		audio_freq_ok = 0;
		multiangle = 0;
		audio_bitrate = 0;
		yaaudio = 0;
		type_video = "0";
		rc_004 = 0;
		video_format = "4/3";
		pathnamevideo->hide ();
		theformat->hide ();
		panneau_bouton_1->setDisabled (true);
		lineEdit8->setText ("");
		appimgbt->hide ();
		panneau_titre->show ();
		panneau_titre->raise ();
		tmp_001 = myfic;

		int cpt_001 = tmp_001.length ();

		while (tmp_001.mid (cpt_001, 1) != "/" && cpt_001 != 0)
		{
		cpt_001 = cpt_001 - 1;
		}
	
		if (cpt_001 > 0)
		{
		titre_element->setText (tmp_001.mid (cpt_001 + 1,
							tmp_001.length () -
							(cpt_001 + 5)));
		}
		else
		{
		titre_element->setText ("");
		}

		path_video = myfic;
		bt_et02_con->setDisabled (true);
		a_reencoder = "0";

		// *** Pickup video information ***
		proc_001 = new QProcess (this);
		proc_001->addArgument ("tcprobe");
		proc_001->addArgument ("-i");
		proc_001->addArgument (myfic);
	
		connect (proc_001, SIGNAL (readyReadStdout ()), this, SLOT (test_type_video ()));
		connect (proc_001, SIGNAL (processExited ()), this, SLOT (fin_import ()));

		tmp_001 = "";
	
		if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER, table_message[0] + "tcprobe");
		}
		}
	}
	else
	{
	  QMessageBox::warning (this, MANDVDVER, table_message[1]);
	}
     }


	/* Add a movie to the DVD? menu or in a later stage */
	void
	mainfrm::bt_add_film_menu_clicked () {
	// **************************
	// *** Ajout du film sur le menu ***
	// **************************
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	// *** Dblocage des sliders ***
	slider_x->setEnabled (true);
	slider_y->setEnabled (true);
	slider_x->setValue (1);
	slider_y->setValue (1);
	bt_renew_all->setDisabled (true);
	bt_valid_bt->setEnabled (true);
	bt_annul_create_bt->setEnabled (true);

	if (i->text (3) != "$$CHAP$$")
		{
		after_lire->setEnabled (true);
		after_lire->setCurrentItem (0);
		}
	// *** Sauvegarde du titre du film ***
	tmp4sub = i->text (4);
	rc_001 = tmp4sub.find ("$$$", 0);

	if (rc_001 != -1)
		{
		tmp_002 =
		tmp4sub.mid (rc_001 + 3, tmp4sub.length () - (rc_001 + 3));
		path_subtitle = tmp_002;
		yasubtitle = 1;
		}
	else
		{
		path_subtitle = "";
		yasubtitle = 0;
		}

	if (rc_001 == -1)
		{
		rc_001 = tmp4sub.length ();
		}
	tmp_002 = tmp4sub.mid (0, rc_001);
	rc_001 = tmp_002.toInt (&ok, 10);

	if (ok == true)
		{
		if (rc_001 == 0)
		{
		audio_bitrate = DEFAULTAUDIOBR;
		}
		else
		{
		audio_bitrate = rc_001;
		}
		}
	//
	nomfilm = i->text (0);
	path_video = i->text (1);
	a_reencoder = i->text (2);
	wchapitres = i->text (3);
	video_format = i->text (5);
	type_video = i->text (6);
	wpathbtmenu = i->text (7);
	//
	if (wpathbtmenu == "")
		{
		QFontMetrics fm (myfont);
		longueur = fm.width ("\"" + nomfilm + "\"", -1);
		hauteur = (taille_police + 2) * 2;
		save_fond_2 = my_pixmap_001->pixmap ()->convertToImage ();
		bt_fantome->setPixmap (save_fond_2.copy
					(slider_x->value (), slider_y->value (),
					longueur, hauteur, 0));
		bt_fantome->setGeometry (23 + slider_x->value (),
					23 + slider_y->value (), longueur,
					hauteur);
		bt_fantome->show ();
		bt_fantome->raise ();
		myfont.setFixedPitch (true);
		// *** Dessin du texte sur le bouton tat normal ***********
		QPainter mypainter (this);
		mypainter.end ();
		mypainter.begin (bt_fantome->pixmap ());
		mypainter.setPen (couleur_1);
		mypainter.setFont (myfont);
		mypainter.drawText (0, hauteur / 2, nomfilm);
		mypainter.end ();
		bt_fantome_2->pixmap ()->fill (couleur_2);
		bt_fantome_3->pixmap ()->fill (couleur_3);
		// *** Rglage des barres de dfilement ***
		slider_x->setMaxValue (720 - longueur);
		slider_y->setMaxValue (576 - hauteur);
		}
	else
		{
		// *** Bouton image sur le menu ***
		wsavbtmenu.load (wpathbtmenu, 0);
		if (wsavbtmenu.width () > 700 || wsavbtmenu.height () > 500)
		{
		QImage reducesize (wpathbtmenu, 0);
		wsavbtmenu = reducesize.scale (500, 400, QImage::ScaleMax);
		}
		longueur = wsavbtmenu.width ();
		hauteur = wsavbtmenu.height ();
		wdefhaut = hauteur;
		wdeflong = longueur;
		save_fond_2 = my_pixmap_001->pixmap ()->convertToImage ();
		bt_fantome->setPixmap (save_fond_2.copy
					(slider_x->value (), slider_y->value (),
					longueur, hauteur, 0));
		bt_fantome->setGeometry (23 + slider_x->value (),
					23 + slider_y->value (), longueur,
					hauteur);
		bt_fantome->show ();
		bt_fantome->raise ();
		// *** Rglage des barres de dfilement ***
		slider_x->setMaxValue (720 - longueur);
		slider_y->setMaxValue (576 - hauteur);
		// *** Dessin du bouton image sur le bouton tat normal ***********
		QPainter mypainter (this);
		mypainter.end ();
		mypainter.begin (bt_fantome->pixmap ());
		mypainter.drawImage (0, 0,
				wsavbtmenu.scale (longueur, hauteur,
							QImage::ScaleMax), 0, 0, -1,
				-1);
		mypainter.end ();
		bt_fantome_2->pixmap ()->fill (couleur_2);
		bt_fantome_3->pixmap ()->fill (couleur_3);
		}
	// *** Blocage de la liste pendant le travail sur le bouton ***
	lst_video_2->setDisabled (true);
	bt_add_film_menu->setDisabled (true);
	bt_et04_con_2->setDisabled (true);
	bt_et04_con->setDisabled (true);
	bt_rename_chap->setDisabled (true);
	// *** On passe la zone de suret au plus haut niveau ***
	zs_1->raise ();
	zs_2->raise ();
	zs_3->raise ();
	zs_4->raise ();
	//
	if (wpathbtmenu == "")
		{
		regle_2->setGeometry (23,
					23 + slider_y->value () + taille_police + 2,
					720, 1);
		}
	else
		{
		regle_2->setGeometry (23, 23 + slider_y->value () + hauteur + 2,
					720, 1);
		slider5->setValue (0);
		slider6->setValue (0);
		slider7->setValue (0);
		slider5->setMinValue ((longueur * -1) + 60);
		slider6->setMinValue ((hauteur * -1) + 60);
		slider5->setMaxValue ((700 - longueur) - 60);
		slider6->setMaxValue ((550 - hauteur) - 60);
		if (wdeflong > wdefhaut)
		{
		slider7->setMinValue ((longueur * -1) + 60);
		slider7->setMaxValue ((700 - longueur) - 60);
		}
		else
		{
		slider7->setMinValue ((hauteur * -1) + 60);
		slider7->setMaxValue ((550 - hauteur) - 60);
		}
		}
	regle_1->setGeometry (22 + slider_x->value (), 23, 1, 576);
	regle_1->show ();
	regle_2->show ();
	regle_1->raise ();
	regle_2->raise ();
	if (wpathbtmenu != "")
		{
		bt_dyna_modif->show ();
		bt_dyna_modif->raise ();
		}
	clqconstruct->setGeometry (1001, 0, longueur, hauteur);
	clqconstruct->setPixmap (save_fond_2.copy
				(slider_x->value (), slider_y->value (),
					longueur, hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter (this);
	mypainter.end ();
	mypainter.begin (clqconstruct->pixmap ());
	
	if (wpathbtmenu == "")
		{
		mypainter.setPen (couleur_1);
		mypainter.setFont (myfont);
		mypainter.drawText (0, hauteur / 2, nomfilm);
		}
	else
		{
		mypainter.drawImage (0, 0,
				wsavbtmenu.scale (longueur, hauteur,
							QImage::ScaleFree), 0, 0, -1,
				-1);
		}
	mypainter.end ();
	}
	}

	/* Importing a video to the project: Child process called from add_video_clicked !?*/
	void
	mainfrm::fin_import () {
	// ****************************************
	// *** Fin de l'importation / contrle des fichiers ***
	// ****************************************
	rc_001 = tmp_001.find (" " + QString::number (projwid) + "x" +
			QString::number (projhau), 0);

	if (rc_001 != -1)
	{
	video_size_ok = 1;
	}

	rc_001 = tmp_001.find ("PTS", 0);

	if (rc_001 != -1)
	{
	video_codec_ok = 1;
	}

	rc_001 = tmp_001.find ("48000", 0);

	if (rc_001 != -1)
	{
	audio_freq_ok = 1;
	}
	
	rc_001 = tmp_001.find ("4:3", 0);
	if (rc_001 != -1)
	{
	video_format = "4/3";
	}
	
	rc_001 = tmp_001.find ("16:9", 0);
	if (rc_001 != -1)
	{
	video_format = "16/9";
	}
	
	rc_001 = tmp_001.find ("audio track:", 0);
	if (rc_001 != -1)
	{
	yaaudio = 1;
	}
	
	rc_001 = tmp_001.find ("bitrate", 0);
	if (rc_001 != -1 && yaaudio == 1)
	{
	rc_002 = tmp_001.find ("bitrate", rc_001 + 9);
	if (rc_002 != -1 && yaaudio == 1)
		{
		tmp_004 = tmp_001.mid (rc_002 + 8, 3);
		rc_003 = tmp_004.toInt (&ok, 10);
		if (ok == true)
		{
		audio_bitrate = rc_003;
		}
		else
		{
		audio_bitrate = 0;
		}
		}
	}
	
	rc_001 = tmp_001.find ("--av_fine_ms ", 0);
	if (rc_001 != -1)
	{
	if (tmp_001.mid (rc_001 + 13, 1) != "0")
		{
		audio_freq_ok = 0;
		//
		tmp_008 = "";
		rc_003 = rc_001 + 13;
		while (tmp_001.mid (rc_003, 1) != " ")
		{
		tmp_008 = tmp_008 + tmp_001.mid (rc_003, 1);
		rc_003 = rc_003 + 1;
		}
		textLabel2_11->setText ("A/V sync (ms) : " + tmp_008);
		rc_001 = tmp_008.toInt (&ok, 10);
		if (ok == true)
		{
		avvalue->setValue (rc_001);
		}
		else
		{
		avvalue->setValue (0);
		}
		//
		}
	else
		{
		tmp_008 = "0";
		textLabel2_11->setText ("A/V sync (ms) : " + tmp_008);
		avvalue->setValue (0);
		}
	}
	else
	{
	tmp_008 = "0";
	textLabel2_11->setText ("A/V sync (ms) : " + tmp_008);
	avvalue->setValue (0);
	}
	
	rc_001 = tmp_001.find ("-f " + QString::number (projfps), 0);
	if (rc_001 == -1)
	{
	audio_freq_ok = 0;
	}
	
	rc_001 = tmp_001.find ("presentation unit", 0);
	if (rc_001 != -1)
	{
	multiangle = 1;
	}
	//
	if (multiangle == 0)
	{
	panneau_titre->setEnabled (true);
	
	if (video_size_ok == 0 || video_codec_ok == 0 || audio_freq_ok == 0 ) 
		{
		a_reencoder = "1";
		}
	else
		{
		a_reencoder = "0";
		}
	}
	else
	{
	// *** DVD Multi angles ***
	panneau_titre->setEnabled (true);
	if (type_video == "0")
		{
		a_reencoder = "1";
		}
	else
		{
		a_reencoder = "0";
		}
	}
	}

	/* Test type of encoding of video */
	void
	mainfrm::test_type_video () {
	// **********************************
	// *** Test le type d'encodage de la vido ***
	// **********************************
	lineEdit1->setText (proc_001->readStdout ());
	tmp_001 = tmp_001 + lineEdit1->text ();
	}
	

	/* Button: Remove a video from the project clicked */
	void
	mainfrm::bt_supprime_video_clicked () {
	// ******************************************
	// *** Suppression d'une vido de la liste du projet  ***
	// ******************************************
	int nbremini = 0;

	QListViewItem *i = lst_video_1->selectedItem ();
	if (i != 0)
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotStop ();
		}

	path_video = i->text (1);
	nombre_video = nombre_video - 1;

	// *** Suppression de la ligne ***
	if (i->text (2) == "9")
		{
		bt_ajout_intro->setEnabled (true);
		}
	if (bt_ajout_intro->isEnabled () == false)
		{
		nbremini = 1;
		}
	
	lst_video_1->takeItem (i);
	pathnamevideo->hide ();
	theformat->hide ();
	//
	if (lst_video_1->childCount () == nbremini)
		{
		bt_force->setDisabled (true);

                if ( nbremini != 1 )
		  bt_supprime_video->setDisabled (true);

		bt_gest_sub->setDisabled (true);
		bt_chapitres->setDisabled (true);
		bt_modifier_titre->setDisabled (true);
		bt_gest_sub_2->setDisabled (true);
		bt_cut_film->setDisabled (true);
		volume->setText (table_message[52] + "<B>0 MB</B>");
		taille_DVD = 0;
		}
	else
		{
		calculsize (1);
		lst_video_1->setSelected (lst_video_1->currentItem (), true);
		}
	}
	}


	/* Cancel choose title for video */	
	void
	mainfrm::bt_cancel_titre_clicked () {
	// ***********************************
	// *** On annule l'ajout du titre  la video ***
	// ***********************************
	panneau_titre->hide ();
	lst_video_1->setEnabled (true);
	panneau_bouton_1->setEnabled (true);
	bt_et02_con->setEnabled (true);
	wchapitres = "";
	}

	/* Force to reecode video */
	void
	mainfrm::bt_force_clicked () {
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0)
	{
	QImage wl_img1 = i->pixmap (0)->convertToImage ();
	QPixmap wl_pix1 (wl_img1);

	QImage wl_img2 = previcon_3->pixmap ()->convertToImage ();
	QPixmap wl_pix2 (wl_img2);

	::bitBlt (&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
	i->setPixmap (0, wl_pix1);
	i->setText (2, "1");
	bt_force->setDisabled (true);
	}
	}
	
	/* Choose font */
	void
	mainfrm::bt_police_clicked () {
	// **********************************
	// *** Slection de la police de caractre ***
	// **********************************
	myfont = QFontDialog::getFont (&ok, QFont ("Helvetica [Cronyx]", 10), this);
	taille_police = myfont.pointSize ();
	}





	/* Add movie mPlayerWidget running */
	void
	mainfrm::bt_add_cont_clicked () {
	// *********************************
	// *** Ajout  du film  la liste des vidos ***
	// *********************************
	if (titre_element->text () != "")
	{
	if (rc_004 == 0)
		{
		m_pMPlayerWidget->setFilename (path_video);
		m_pMPlayerWidget->slotPlay ();
		m_pMPlayerWidget->slotSeek (10, 2); //TEST MB
		panneau_titre->setDisabled (true);
		// ***Cration d'un timer ***
		mytimer = new QTimer (this);
		connect (mytimer, SIGNAL (timeout ()),
			SLOT (capture_image_film ()));
		mytimer->start (1450, true);
		}
	else
		{
		QListViewItem *i = lst_video_1->selectedItem ();
		if (i != 0)
		{
		tmp_001 = textLabel2_11->text ();
		rc_002 = tmp_001.find (":", 0);
		if (rc_002 != -1)
			{
			tmp_002 =
			tmp_001.mid (rc_002 + 2,
					tmp_001.length () - (rc_002 + 2));
			}
		if (tmp_002 != QString::number (avvalue->value ()))
			{
			a_reencoder = "1";
			i->setText (2, "1");
			i->setPixmap (0, *previcon_3->pixmap ());
			//
			QImage wl_img1 = i->pixmap (0)->convertToImage ();
			QPixmap wl_pix1 (wl_img1);
			QImage wl_img2 = previcon_3->pixmap ()->convertToImage ();
			QPixmap wl_pix2 (wl_img2);
			::bitBlt (&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
			}
	
		i->setText (6, "$$" + tmp_002 + "##" + QString::number (avvalue->value ()));
		i->setText (0, titre_element->text ());
		i->setText (7, lineEdit8->text ());

		panneau_titre->hide ();
		lst_video_1->setEnabled (true);
		bt_modifier_titre->setEnabled (true);
		bt_supprime_video->setEnabled (true);
		bt_chapitres->setEnabled (true);
		bt_et02_con->setEnabled (true);
		panneau_bouton_1->setEnabled (true);
		}
		}
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[6]);
	}
	}
	

	/* Add introduction video on DVD!? m_pMPlayerWidget */	
	void
	mainfrm::bt_ajout_intro_clicked () {

	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	QString myfic = QFileDialog::getOpenFileName (dossier_travail_2,
							"Vidos (*.mpg *.MPG *.mpeg *.MPEG *.VOB *.vob)",
							this, table_message[65], table_message[66]);
	if (myfic.isNull ())
	{
	}
	else
	{
	pathintro = myfic;

	QListViewItem *i = new QListViewItem (lst_video_1, "Introduction video", pathintro, "9",
				"", "", video_format, "", "");

	i->setPixmap (0, *previcon_1->pixmap ());
	bt_ajout_intro->setDisabled (true);
	bt_supprime_video->setEnabled (true);
	nombre_video = nombre_video + 1;
	path_video = myfic;

	calculsize (0);
	}
	}



	/* The Gimp functions: Start extrenal process */	
	void
	mainfrm::bt_modif_gimp_2_clicked () {
	proc_001 = new QProcess (this);
	proc_001->addArgument ("gimp");
	proc_001->addArgument (table_images[num_photo->value () - 1][0]);
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_thegimp_2 ()));

	if (!proc_001->start ())
	{
	QMessageBox::warning (this, MANDVDVER, table_message[0] + "The Gimp");
	}
	else
	{
	this->setDisabled (true);
	}
	}
	
	void
	mainfrm::fin_thegimp_2 () {
	QPixmap loadimg (table_images[num_photo->value () - 1][0]);
	QImage myimg = loadimg.convertToImage ();
	QImage myimg_2 = myimg.scale (320, 256, QImage::ScaleMax);
	QLabel *pntloc = table_pnt_img[num_photo->value () - 1];
	pntloc->setPixmap (myimg_2);
	apercu_photo_diapo->setPixmap (myimg_2);
	this->setEnabled (true);
	}





/********* PROJECT SAVE AND LOAD FROM DISC ***********************************************************/	

	/* Open and restore a saved project */
	void
	mainfrm::goopenproj (QString myfic) {
	QString myrec;
	QFile myfichier (myfic);
	QTextStream mystream (&myfichier);
	QListViewItem *j;
	QString tmp_007;
	QImage wl_img1;
	nombre_video = 0;

        bt_ajout_intro->setEnabled (true);

	if (myfichier.open (IO_ReadOnly))
	{
		myrec = mystream.readLine ();
		rc_001 = myrec.toInt (&ok, 10);
	
		if (ok != true)
			{
			projfps = 25;
			}
		else
			{
			projfps = rc_001;
			}
	
		if( projfps == 25)
	  	   videostandard->setCurrentItem(0);
		else
 		   videostandard->setCurrentItem(1);

		myrec = mystream.readLine ();
		rc_001 = myrec.toInt (&ok, 10);
	
		if (ok != true)
			{
			projhau = 576;
			}
		else
			{
			projhau = rc_001;
			}
	
		myrec = mystream.readLine ();
		rc_001 = myrec.toInt (&ok, 10);
	
		if (ok != true)
			{
			projwid = 720;
			}
		else
			{
			projwid = rc_001;
			}
	
		if( projwid== 720)
	  	   videosizedef->setCurrentItem(0);
		else
 		   videosizedef->setCurrentItem(1);

		myrec = mystream.readLine ();
		wpathtotalproj = myrec;
		path_out->setText (myrec);
		myrec = mystream.readLine ();
		bt_ajout_intro->setEnabled (true);
	
		while (mystream.atEnd () == false && myrec != "$$FINMEDIAS$$")
			{
			myrec = mystream.readLine ();
			tmp_001 = myrec;
			myrec = mystream.readLine ();
			tmp_002 = myrec;
			myrec = mystream.readLine ();
			tmp_003 = myrec;
			myrec = mystream.readLine ();
			tmp_004 = myrec;
			myrec = mystream.readLine ();
			tmp_005 = myrec;
			myrec = mystream.readLine ();
			tmp_006 = myrec;
			myrec = mystream.readLine ();
			tmp_007 = myrec;
			myrec = mystream.readLine ();
			tmp_008 = myrec;
			j = new QListViewItem (lst_video_1, tmp_001, tmp_002, tmp_003,
					tmp_004, tmp_005, tmp_006, tmp_007, tmp_008);
			wl_img1.load (wpathtotalproj + "/minbtsize" +
					QString::number (nombre_video) + j->text(0)  + ".png");
	
			j->setPixmap (0, wl_img1);
			nombre_video = nombre_video + 1;
			path_video = tmp_002;

			// *** Calcul de la taille du DVD ***
			calculsize (0);

	    		/* Disable introvideobutton if intro is found */
	    		if( j->text(3) == 9 )
			   bt_ajout_intro->setDisabled (true);

			myrec = mystream.readLine ();
			}
	
		newproj->hide ();
		lineEdit11->setText (wpathtotalproj);
		Etape_02->setEnabled (true);
		lst_video_1->setEnabled (true);
		bt_modifier_titre->setEnabled (true);
		bt_gest_sub_2->setEnabled (true);
		bt_supprime_video->setEnabled (true);
		bt_chapitres->setEnabled (true);
		bt_gest_sub->setEnabled (true);
		bt_cut_film->setEnabled (true);
		panneau_bouton_1->setEnabled (true);
		volume->setText (table_message[52] + "<b>" + QString::number (taille_DVD) + table_message[76] + 
		"<br />" + "DVD: "  + videostandard->currentText () + " " + videosizedef->currentText ()  );
	}
}

	/* Save a current project to disc */
	void
	mainfrm::gosaveproj (QString myfic) {
	QFile outfic (myfic);

	if (outfic.open (IO_WriteOnly))
	{
	/* Test to sort before saving */
	lst_video_1->setSorting (2, true);
	lst_video_1->sort ();

	int cpt_001 = 0;
	QImage wl_img1;
	QString tmp_007;
	tmp_001 = QString::number (projfps);
	outfic.writeBlock (tmp_001 + "\n", tmp_001.length () + 1);
	tmp_001 = QString::number (projhau);
	outfic.writeBlock (tmp_001 + "\n", tmp_001.length () + 1);
	tmp_001 = QString::number (projwid);
	outfic.writeBlock (tmp_001 + "\n", tmp_001.length () + 1);
	tmp_001 = wpathtotalproj;
	outfic.writeBlock (tmp_001 + "\n", tmp_001.length () + 1);

	QListViewItem *lvi = lst_video_1->firstChild ();

	while (cpt_001 < nombre_video && cpt_001 < 39)
		{
		tmp_001 = lvi->text (0);
		tmp_002 = lvi->text (1);
		tmp_003 = lvi->text (2);
		tmp_004 = lvi->text (3);
		tmp_005 = lvi->text (4);
		tmp_006 = lvi->text (5);
		tmp_007 = lvi->text (6);
		tmp_008 = lvi->text (7);
		//
		outfic.writeBlock ("$$MEDIAS$$\n", 11);
		outfic.writeBlock (tmp_001 + "\n", tmp_001.length () + 1);
		outfic.writeBlock (tmp_002 + "\n", tmp_002.length () + 1);
		outfic.writeBlock (tmp_003 + "\n", tmp_003.length () + 1);
		outfic.writeBlock (tmp_004 + "\n", tmp_004.length () + 1);
		outfic.writeBlock (tmp_005 + "\n", tmp_005.length () + 1);
		outfic.writeBlock (tmp_006 + "\n", tmp_006.length () + 1);
		outfic.writeBlock (tmp_007 + "\n", tmp_007.length () + 1);
		outfic.writeBlock (tmp_008 + "\n", tmp_008.length () + 1);
		//
		wl_img1 = lvi->pixmap (0)->convertToImage ();
		wl_img1.save (path_out->text () + "/minbtsize" + 
				QString::number (cpt_001) + lvi->text(0) + ".png", "PNG");
		//
		lvi = lvi->nextSibling ();
		cpt_001 = cpt_001 + 1;
		}
	outfic.writeBlock ("$$FINMEDIAS$$\n", 14);
	outfic.close ();
	QMessageBox::warning (this, MANDVDVER, table_message[39]);
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[8]);
	}
	}


	/* Save and Open project functions */		
	void
	mainfrm::toolButton168_2_clicked () {
	QString myfic = QFileDialog::getOpenFileName (path_out->text (), "Pro ManDVD (*.pma)",
							this, table_message[74], table_message[74] );
	if (myfic.isNull ())
	{
	}
	else
	{

	/* Testing MB: Loading a new project while program is running */ 
	lst_video_1->clear();
 	taille_DVD = 0;
        bt_ajout_intro->setEnabled (true);

	/**************************************************************/

	goopenproj (myfic);

	}
	}

	void
	mainfrm::bt_save_1_clicked () {
	QString myfic = QFileDialog::getSaveFileName (path_out->text (),
							"Projet ManDVD (*.pma)",
							this, "Sauvegarde projet", "Sauvegarde projet");
	if (myfic.isNull ())
	{
	}
	else
	{
	if (myfic.right (4) != ".pma")
		{
		myfic = myfic + ".pma";
		}
	gosaveproj (myfic);
	}
	}

	/* Choose destination of DVD-project location */
	void
	mainfrm::toolButton71_clicked () {
	// *********************************
	// *** Paramtrage du dossier de travail ***
	// *********************************
	
	QString myfic = QFileDialog::getExistingDirectory ("~",
							this, "Dossier de destination", table_message[70], TRUE);
	if (myfic.isNull ())
	{
	}
	else
	{
	lineEdit11->setText (myfic);
	}
	}





	/*
	 *  TERMINATING PROGRAM
	 */

	/* This function starts process to clean up temporary files when closing down program */	
	void
	mainfrm::bt_quit_clicked () {
 	// ****************************
	// *** Fermeture de l'application ***
	// ****************************

	proc_001 = new QProcess (this);
	proc_001->addArgument ("bash");
	proc_001->addArgument (wpathtotalproj + "nettoyageglobal.sh");

	connect (proc_001, SIGNAL (processExited ()), this, SLOT (fin_netttout ()));
	proc_001->start ();

	}

	/* Just to close down */
	void
	mainfrm::fin_netttout () {
	this->close ();
	}

	/* What will happen when user wants to exit prog
	 * User should not be able to close down on main window
	 * without a warning dialog. 
 	 */
	void mainfrm::closeEvent(QCloseEvent *qcloseevent)
	{

	if (QMessageBox::question
	(this, MANDVDVER, table_message[17], table_message[61], table_message[62], QString::null, 0,
	1) == 0)
	
	{
	QFile myfic_2 (wpathtotalproj + "nettoyageglobal.sh");
	if (myfic_2.open (IO_WriteOnly))
		{
		tmp_001 = "#!/bin/bash\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "cd " + wpathtotalproj + "\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f gibmenanim*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f gibvideo*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f genmenu*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f dvdauthor.xml\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f *.sh\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f normal.jpg\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f cliquee.png\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f survolee.png\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f silent.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());

		/* More files to remove on close down */
		tmp_001 = "rm -f gibintromenu.mpg\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f nettoyageglobal.sh\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		myfic_2.close ();
		}
	qcloseevent->accept(); 
   	return;
	}

}


	



/*
*  Functions belonging to DVD-menu generation process
*/

	/* Choose colour to the menu!? DVD?? */	
	void
	mainfrm::bt_charg_wall_uni_clicked () {
	// ***************************************
	// *** Choix de la couleur uni du fond du menu ***
	// ***************************************
	QColor couleur_tmp;
	couleur_tmp =
	QColorDialog::getColor (couleur_tmp, this, table_message[71] );
	if (couleur_tmp.isValid ())
	{
	QImage myimg;
	apercu_fond->pixmap ()->fill (couleur_tmp);
	myimg = apercu_fond->pixmap ()->convertToImage ();
	QImage myimg_2 = myimg.scale (720, 576, QImage::ScaleFree);
	QPixmap mypix (myimg_2);
	apercu_fond->setPixmap (mypix);
	save_fond = myimg_2.copy (0, 0, 720, 576, 0);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap (*apercu_fond->pixmap ());
	boite_effets->setEnabled (true);
	path_fond = "Couleur unie";
	}
	}








 	/* Set tab order in DVD menu!? */
	void
	mainfrm::bt_tab_order_clicked () {
	int wcpt001;
	wcpt001 = 0;
	QListViewItem *j;
	lsttab->clear ();
	//
	while (wcpt001 < max_boutons)
	{
	if (table_boutons_lien[wcpt001][3] != "$$CHAP$$")
		{
		j =
		new QListViewItem (lsttab, table_boutons_lien[wcpt001][0],
				QString::number (wcpt001));
		}
	else
		{
		tmp_010 = table_boutons_lien[wcpt001][1];
		rc_001 = tmp_010.find ("|||", 0);
	
		if (rc_001 != -1)
		{
		tmp_011 = tmp_010.mid (0, rc_001);
		j =
			new QListViewItem (lsttab,
					tmp_011 + " - " +
					table_boutons_lien[wcpt001][0],
					QString::number (wcpt001));
		}
		}
	wcpt001 = wcpt001 + 1;
	}
	//
	Etape_04->setDisabled (true);
	tab_order->setGeometry (350, 110, 300, 480);
	tab_order->show ();
	lsttab->setSorting (1, true);
	lsttab->sort ();
	tab_order->raise ();
	lsttab->setSorting (-1, false);
	}
	
	/* Skriv tab order on DVD mneu!? */
	void
	mainfrm::bt_fermer_taborder_clicked () {
	//
	QString sav_bt_lien[60][8];
	int sav_bt_pos[60][5];
	int wcpt001;
	wcpt001 = 0;
	while (wcpt001 < max_boutons)
	{
	sav_bt_lien[wcpt001][0] = table_boutons_lien[wcpt001][0];
	sav_bt_lien[wcpt001][1] = table_boutons_lien[wcpt001][1];
	sav_bt_lien[wcpt001][2] = table_boutons_lien[wcpt001][2];
	sav_bt_lien[wcpt001][3] = table_boutons_lien[wcpt001][3];
	sav_bt_lien[wcpt001][4] = table_boutons_lien[wcpt001][4];
	sav_bt_lien[wcpt001][5] = table_boutons_lien[wcpt001][5];
	sav_bt_lien[wcpt001][6] = table_boutons_lien[wcpt001][6];
	sav_bt_lien[wcpt001][7] = table_boutons_lien[wcpt001][7];
	//
	sav_bt_pos[wcpt001][0] = table_boutons_pos[wcpt001][0];
	sav_bt_pos[wcpt001][1] = table_boutons_pos[wcpt001][1];
	sav_bt_pos[wcpt001][2] = table_boutons_pos[wcpt001][2];
	sav_bt_pos[wcpt001][3] = table_boutons_pos[wcpt001][3];
	sav_bt_pos[wcpt001][4] = table_boutons_pos[wcpt001][4];
	
	wcpt001 = wcpt001 + 1;
	}
	//
	QListViewItem *lvi = lsttab->firstChild ();
	wcpt001 = 0;
	while (wcpt001 < max_boutons)
	{
	tmp_001 = lvi->text (1);
	rc_001 = tmp_001.toInt (&ok, 10);
	if (ok == true)
		{
		table_boutons_lien[wcpt001][0] = sav_bt_lien[rc_001][0];
		table_boutons_lien[wcpt001][1] = sav_bt_lien[rc_001][1];
		table_boutons_lien[wcpt001][2] = sav_bt_lien[rc_001][2];
		table_boutons_lien[wcpt001][3] = sav_bt_lien[rc_001][3];
		table_boutons_lien[wcpt001][4] = sav_bt_lien[rc_001][4];
		table_boutons_lien[wcpt001][5] = sav_bt_lien[rc_001][5];
		table_boutons_lien[wcpt001][6] = sav_bt_lien[rc_001][6];
		table_boutons_lien[wcpt001][7] = sav_bt_lien[rc_001][7];
		//
		table_boutons_pos[wcpt001][0] = sav_bt_pos[rc_001][0];
		table_boutons_pos[wcpt001][1] = sav_bt_pos[rc_001][1];
		table_boutons_pos[wcpt001][2] = sav_bt_pos[rc_001][2];
		table_boutons_pos[wcpt001][3] = sav_bt_pos[rc_001][3];
		table_boutons_pos[wcpt001][4] = sav_bt_pos[rc_001][4];
		}
	else
		{
		printf ("INTERNAL ERROR --- Please contact me");
		}
	lvi = lvi->nextSibling ();
	wcpt001 = wcpt001 + 1;
	}
	//
	tab_order->hide ();
	Etape_04->setEnabled (true);
	}

	/* Tab order DVD menu: Move down!? */
	void
	mainfrm::bt_down_tab_clicked () {
	QListViewItem *i = lsttab->selectedItem ();
	
	if (i != 0)
	{
	if (i->itemBelow () != NULL)
		{
		i->moveItem (i->itemBelow ());
		}
	}
	}

	/* Tab order DVD menu: Move up!? */	
	void
	mainfrm::bt_up_ab_clicked () {
	QListViewItem *i = lsttab->selectedItem ();
	
	if (i != 0)
	{
	if (i->itemAbove () != NULL)
		{
		i->itemAbove ()->moveItem (i);
		}
	}
	}



	

	
	/* Go to enode/burn DVD !? */
	void
	mainfrm::bt_param_encode_clicked () {
	if (optencode->isVisible () == true)
	{
	optencode->hide ();
	}
	else
	{
	fautyrencoder = 1;
	optencode->show ();
	optencode->raise ();
	}
	}

	
	/*Slide: Videobitrate value before burning */
	void
	mainfrm::slidevbitrate_valueChanged (int) {
	textLabel1_29->setText ("Video bitrate : " +
				QString::number (slidevbitrate->value ()) +
				" kb/s");
	}

	
	/* Create iso-image */	
	void
	mainfrm::bt_grave_3_clicked () {
	pb_009->setProgress (0);
	creation_iso->setGeometry (314, 329, 371, 42);
	creation_iso->show ();
	creation_iso->raise ();
	rc_001 = 0;
	Etape_05->setDisabled (true);
	proc_003 = new QProcess (this);
	proc_003->addArgument ("mkisofs");
	proc_003->addArgument ("-o");
	proc_003->addArgument (path_out->text () + "/Mandvdiso.iso");
	proc_003->addArgument ("-dvd-video");
	proc_003->addArgument (path_out->text () + "/DVD/");

	connect (proc_003, SIGNAL (readyReadStderr ()), this, SLOT (stdout_mkiso ()));
	connect (proc_003, SIGNAL (processExited ()), this, SLOT (fin_iso ()));

	if (!proc_003->start ())
	{
	QMessageBox::warning (this, MANDVDVER, table_message[0] + "mkisofs");
	}
	}

	/* Process dvd iso-file */	
	void
	mainfrm::stdout_mkiso () {
	// ****************************
	// *** Lecture de la sortie console ***   
	// ****************************
	lineEdit1->setText (proc_003->readStderr ());
	tmp_001 = lineEdit1->text ();
	rc_001 = tmp_001.find ("%", 0);
	if (rc_001 != -1)
	{
	tmp_002 = tmp_001.mid (1, 2);
	rc_001 = tmp_002.toInt (&ok, 10);
	if (ok == true)
		{
		pb_009->setProgress (rc_001);
		}
	}
	tmp_001 = lineEdit1->text ();
	rc_001 = tmp_001.find ("error", 0);
	if (rc_001 != -1)
	{
	rc_002 = 1;
	}
	
	tmp_001 = lineEdit1->text ();
	rc_001 = tmp_001.find (" not recognized", 0);
	if (rc_001 != -1)
	{
	rc_002 = 1;
	}
	
	rc_001 = tmp_001.find ("Unable", 0);
	if (rc_001 != -1)
	{
	rc_002 = 1;
	}
	lecture_console->append (lineEdit1->text ());
	lecture_console->append (proc_003->readStdout ());
	}

	/* Finish dvd iso-file */	
	void
	mainfrm::fin_iso () {
	if (rc_002 == 0)
	{
	pb_009->setProgress (100);
	QMessageBox::warning (this, MANDVDVER,
				table_message[36] + path_out->text () +
				"Mandvdiso.iso");
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[37]);
	}
	creation_iso->hide ();
	Etape_05->setEnabled (true);
	}
	
	/* Generate DVD with K3b */	
	void
	mainfrm::bt_grave_2_clicked () {
	// ******************************
	// *** Generation du DVD avec K3B ***
	// ******************************
	proc_003 = new QProcess (this);
	proc_003->addArgument ("k3b");
	proc_003->addArgument ("--datadvd");
	proc_003->addArgument (path_out->text () + "DVD/AUDIO_TS");
	proc_003->addArgument (path_out->text () + "DVD/VIDEO_TS");
	if (!proc_003->start ())
	{
	QMessageBox::warning (this, MANDVDVER, table_message[0] + "K3B");
	}
	}



	/* Hide or show program console */	
	void
	mainfrm::affconsole_clicked () {

	if (myconsole->isVisible () == true)
	{
	myconsole->hide ();
	}
	else
	{
	myconsole->show ();
	myconsole->raise ();
	}
	
	}
	


