/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Implementation: chapter management
//
// Description: Functions (backend) for editing chapters
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//

#include "mandvd_global.h"
#include <chapter.h>
#include <mainfrm.h>

#include <qlabel.h>
#include <qtoolbutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qtextedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qmessagebox.h> 
#include <qlistview.h>
#include <qdatetimeedit.h> 
#include <qmplayerwidget.h>

/********* CHAPTER GENERATION METHODS WITH NO mPlayerWidget ***********************************************************/	

	/* Button to autgenerate chapters clicked. Other buttons activated!  */		
	void
	mainfrm::bt_add_chap_2_clicked () {
	// **************************
	// *** Chapitrage automatique ***
	// **************************
	chapauto->setEnabled (true);
	bt_add_chap->setDisabled (true);
	bt_sup_chap->setDisabled (true);
	bt_add_chap_2_2->setDisabled (true);
	bt_fermer_chapitre->setDisabled (true);
	}

	/* Generate information in chapters view window !? */	
	void
	mainfrm::bt_chapitres_clicked () {
	// *********************************************
	// *** Affichage de la fentre de cration des chapitres ***
	// *********************************************
	
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0 && i->text (2) != "9")
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotStop ();
		}

	max_chapitres = 0;

	// *** Ajout des chapitres  la listview ***
	chapauto->setDisabled (true);
	bt_add_chap_2_2->setDisabled (true);
	group_add_chap->hide ();
	lst_chap->clear ();
	int cpt_001 = 0;
	tmp_001 = "";
	QListViewItem *lvi = lst_video_1->selectedItem ();
	tmp_001 = lvi->text (3);
	
	if (tmp_001.length () > 0)
		{
		while (tmp_001.mid (cpt_001, 8) != "        ")
		{
	        QListViewItem *j = new QListViewItem( lst_chap, tmp_001.mid(cpt_001,8) ); // Gives compiler warning, ignore!!!!
		max_chapitres = max_chapitres + 1;
		cpt_001 = cpt_001 + 9;
		}
		bt_add_chap_2_2->setEnabled (true);
		}
	//              
	Etape_02->setDisabled (true);
	tmp_008 = i->text (1);
	m_pMPlayerWidget->setFilename (tmp_008);

	/* Textlabel at top of window */
	video_chapitre->setText (table_message[68] + lvi->text (0) + "</b></i>");

	if (max_chapitres == 0)
		{
		bt_sup_chap->setDisabled (true);
		bt_sup_chap_2->setDisabled (true);
		}
	else
		{
		bt_sup_chap->setEnabled (true);
		bt_sup_chap_2->setEnabled (true);
		}

	creation_chapitres->raise ();
	QTime time_001 (4, 0, 0);
	value_time->setMaxValue (time_001);
	durfilmchap = 0;
	creation_chapitres->setGeometry (125, 85, 750, 530);
	vframe->setGeometry (435, 135, 430, 330);
	vframe->show ();
	vframe->raise ();
	creation_chapitres->show ();
	}
	}
	
        /* This is a slot for pressing button to close window for chapters */
	void
	mainfrm::bt_fermer_chapitre_clicked () {
	// *********************************************
	// *** Fermeture de la fentre de cration des chapitres ***
	// *********************************************
	Etape_02->setEnabled (true);
	// *** Ajout des chapitres  la listview ***
	if (max_chapitres > 0)
	   {
		lst_chap->setSorting (0, true);
		lst_chap->sort ();
	
		int cpt_001 = 0;
		tmp_001 = "";

		QString tmptopchap;
		tmptopchap = "$$$";

		QListViewItem *j;
		QListViewItem *lvi = lst_chap->firstChild ();

		while (cpt_001 < max_chapitres)
		    {
			/* Dom't add chapters that at strat of movie 00:00:00 */
			if (tmptopchap != lvi->text (0)  &&  lvi->text (0) != "00:00:00"  ) 
			   {
 				tmp_001 = tmp_001 + lvi->text (0) + ",";
			   }

			tmptopchap = lvi->text (0);
			lvi = lvi->nextSibling ();
			cpt_001 = cpt_001 + 1;
		    }

		tmp_001 = tmp_001 + "        ";
		j = lst_video_1->selectedItem ();
		j->setText (3, tmp_001);
	   }

	else
	   {
		QListViewItem *j;
		tmp_001 = "";
		j = lst_video_1->selectedItem ();
		j->setText (3, tmp_001);
	   }

	if (m_pMPlayerWidget->isPlaying () == true)
	   {
		m_pMPlayerWidget->slotStop ();
	   }
	
	vframe->setGeometry (31, 125, 115, 71);
	vframe->raise ();
	
	creation_chapitres->hide ();
        }

	/* Add a chapter button clicked() */
	void
	mainfrm::bt_add_chap_clicked () {
	// *********************
	// *** Ajout du chapitre ***
	// *********************

	/* Get current time of running movie */
	get_current_time();

	/* Only add chapters if mplayer is running. */
	if (m_pMPlayerWidget->isPlaying () == true)
	   {
		/* Only add chapters if mplayer isn't paused. Start it! Else chapter will be 00:00:00 */
		if ( fElapsedTime != 0 )
		{
// 			bt_stop_play_chap_clicked ();
//   		}
// 		else
// 		{
			int iHour;
			int iMin;
			int iSec;
			QTime mytime;
	
			iHour = (int) (fElapsedTime / 3600.0);
			iMin = (int) ((fElapsedTime - iHour * 3600) / 60.0);
			iSec = (int) (fElapsedTime - iHour * 3600 - iMin * 60);
			mytime.setHMS (iHour, iMin, iSec);
			
			QListViewItem *j = new QListViewItem( lst_chap,mytime.toString("hh:mm:ss") );
			
			// Increase the number of chapters
			max_chapitres = max_chapitres + 1;
		
			bt_sup_chap_2->setEnabled (true);
			bt_sup_chap->setEnabled (true);
			bt_add_chap_2_2->setEnabled (true);
		
			// Sort, bye time
			lst_chap->sort ();
		}
	   }
	}

	/* Set the current time to variable fElapsedTime */
	void
	mainfrm::get_current_time() {

	float Time;
	fElapsedTime = m_pMPlayerWidget->m_rxParseElapsedTime.cap (1).toFloat ();

        }


        /* Remove chapter */
	void
	mainfrm::bt_sup_chap_clicked () {
	// ***************************
	// *** Suppression d'un chapitre ***
	// ***************************
	QListViewItem *i = lst_chap->selectedItem ();
	
	if (i != 0)
	 {
		lst_chap->takeItem (i);
		max_chapitres = max_chapitres - 1;
	
		if (max_chapitres == 0)
			{
			bt_sup_chap->setDisabled (true);
			bt_add_chap_2_2->setDisabled (true);
			bt_sup_chap_2->setDisabled (true);
			}
	 }
	}
	
        /* Modify a chapter in the list */
	void
	mainfrm::bt_new_chap_clicked () {
	// ************************************
	// *** Modification d'un chapitre de la liste ***
	// ************************************
	QTime mytime;
	mytime = value_time->time ();
	QListViewItem *i = lst_chap->selectedItem ();

	if (i != 0)
	  {
		i->setText (0, mytime.toString ("hh:mm:ss"));
	  }

	group_add_chap->hide ();
	grpbtchapt->setEnabled (true);
	bt_fermer_chapitre->setEnabled (true);

	lst_chap->sort ();
	}

	/* */
	void
	mainfrm::bt_new_chap_2_clicked () {
	// **********************************
	// *** Annulation de l'ajout d'un chapitre ***
	// **********************************
	group_add_chap->hide ();
	grpbtchapt->setEnabled (true);
	bt_fermer_chapitre->setEnabled (true);

	if (max_chapitres == 0)
	  {
		bt_sup_chap->setDisabled (true);
	  }
	else
	  {
		bt_sup_chap->setEnabled (true);
	  }

	}

	/* Something with chapter managment */	
	void
	mainfrm::lst_video_1_selectionChanged () {
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0)
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotStop ();
		}
	pathnamevideo->setText (i->text (1));
	if (i->text (5) == "")
		{
		theformat->setText ("Video format : ...");
		}
	else
		{
		theformat->setText ("Video format : " + i->text (5));
		}
	if (i->text (2) == "0")
		{
		bt_force->setEnabled (true);
		}
	else
		{
		bt_force->setDisabled (true);
		}
	if (i->text (2) == "9")
		{
		bt_modifier_titre->setDisabled (true);
		bt_cut_film->setDisabled (true);
		bt_chapitres->setDisabled (true);
		bt_gest_sub->setDisabled (true);
		bt_gest_sub_2->setDisabled (true);
		}
	else
		{
		bt_modifier_titre->setEnabled (true);
		bt_cut_film->setEnabled (true);
		bt_chapitres->setEnabled (true);
		bt_gest_sub->setEnabled (true);
		bt_gest_sub_2->setEnabled (true);
		}
	pathnamevideo->show ();
	theformat->show ();
	}
	}

	/* Modify a chapter */ 	
	void
	mainfrm::bt_add_chap_2_2_clicked () {
	// ***********************
	// *** Modifier un chapitre ***
	// ***********************
	QListViewItem *i = lst_chap->selectedItem ();
	
	if (i != 0)
	{
	tmp_001 = i->text (0).mid (0, 2);
	tmp_002 = i->text (0).mid (3, 2);
	tmp_003 = i->text (0).mid (6, 2);
	int heures = tmp_001.toInt (&ok, 10);
	int minutes = tmp_002.toInt (&ok, 10);
	int secondes = tmp_003.toInt (&ok, 10);
	QTime mylocaltime (heures, minutes, secondes);
	value_time->setTime (mylocaltime);
	group_add_chap->show ();
	group_add_chap->raise ();
	grpbtchapt->setDisabled (true);
	bt_fermer_chapitre->setDisabled (true);
	}
	}

	/* Something with chapters chapters */ 		
	void
	mainfrm::scroll_timeline_valueChanged (int) {
	// ****************************
	// *** Dplacement de la timeline ***
	// ****************************
	timeline->setGeometry (scroll_timeline->value () * -1, 25, 13500, 140);
	}

	/* Something with chapters chapters */ 			
	void
	mainfrm::btokrename_clicked () {
	Renamefilm->hide ();
	Etape_04->setEnabled (true);
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	i->setText (0, txttorename->text ());
	}
	}

	/* Something with chapters chapters */ 			
	void
	mainfrm::bt_rename_chap_clicked () {
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	if (i->text (3) == "$$CHAP$$")
		{
		Etape_04->setDisabled (true);
		txttorename->setText (i->text (0));
		Renamefilm->setGeometry (295, 275, 410, 150);
		Renamefilm->show ();
		Renamefilm->raise ();
		}
	}
	}

	/* Something with chapters chapters */ 			
	void
	mainfrm::bt_annul_create_bt_clicked () {
	slider_x->setDisabled (true);
	slider_y->setDisabled (true);
	bt_valid_bt->setDisabled (true);
	bt_renew_all->setEnabled (true);
	bt_et04_con_2->setDisabled (true);
	after_lire->setDisabled (true);
	bt_annul_create_bt->setDisabled (true);
	lst_video_2->setEnabled (true);
	bt_add_film_menu->setEnabled (true);
	bt_et04_con->setEnabled (true);
	bt_et04_con_2->setEnabled (true);
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	if (i->text (3) == "$$CHAP$$")
		{
		bt_rename_chap->setEnabled (true);
		}
	else
		{
		bt_rename_chap->setDisabled (true);
		}
	}
	else
	{
	bt_rename_chap->setDisabled (true);
	}
	regle_1->hide ();
	regle_2->hide ();
	bt_dyna_modif->hide ();
	bt_fantome->hide ();
	}

	/* Something with chapters chapters */ 			
	void
	mainfrm::lst_video_2_selectionChanged () {
	QListViewItem *i = lst_video_2->selectedItem ();
	if (i != 0)
	{
	if (i->text (3) == "$$CHAP$$")
		{
		bt_rename_chap->setEnabled (true);
		}
	else
		{
		bt_rename_chap->setDisabled (true);
		}
	}
	}




	/* Stop playing chapter button clicked */ 			
	void
	mainfrm::bt_stop_play_chap_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotPause ();
	}
	}

	/* Move forward in the movie */ 			
	void
	mainfrm::bt_defil_2_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotForward ();
	}
	}

	/* Move backwards in the movies */ 			
	void
	mainfrm::bt_defil_1_clicked () {
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotBack ();
	}
	}

	/* Call from play button I think :-p  */
	void
	mainfrm::bt_lire_pr_chap_clicked () {
	// **********************
	// *** Lecture de la video ***
	// **********************
	if (tmp_008 != "" )
	{
	m_pMPlayerWidget->slotPlay ();
	}
	}





	/* Something with chapters chapters */ 			
	void
	mainfrm::lst_chap_clicked (QListViewItem *) {
	QListViewItem *i = lst_chap->selectedItem ();
	
	if (i != 0)
	{
	tmp_001 = i->text (0).mid (0, 2);
	tmp_002 = i->text (0).mid (3, 2);
	tmp_003 = i->text (0).mid (6, 2);
	int heures = tmp_001.toInt (&ok, 10);
	int minutes = tmp_002.toInt (&ok, 10);
	int secondes = tmp_003.toInt (&ok, 10);
	float wpositionnow;
	wpositionnow = (heures * 3600) + (minutes * 60) + secondes;
	if (m_pMPlayerWidget->isPlaying () == false)
		{
		m_pMPlayerWidget->slotPlay ();
		}
	m_pMPlayerWidget->slotSeek (wpositionnow, 2);
	}
	}

	/* Something with chapters chapters */ 		
	void
	mainfrm::bt_modifier_titre_clicked () {
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0 && i->text (2) != "9")
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotStop ();
		}

	bt_et02_con->setDisabled (true);
	panneau_bouton_1->setDisabled (true);
	lst_video_1->setDisabled (true);
	
	tmp_004 = i->text (6);
	rc_003 = tmp_004.find ("$$", 0);	// Warningfix MB int
	
	if (rc_003 != -1)
		{
		rc_003 = rc_003 + 2;
		tmp_008 = "";
		while (tmp_004.mid (rc_003, 2) != "##"
			&& rc_003 < tmp_004.length ())
		{
		tmp_008 = tmp_008 + tmp_004.mid (rc_003, 1);
		rc_003 = rc_003 + 1;
		}
		textLabel2_11->setText ("A/V sync (ms) : " + tmp_008);
		rc_003 = tmp_004.find ("##", 0);
		if (rc_003 != -1)
		{
		tmp_008 = "";
		rc_003 = rc_003 + 2;
		while (rc_003 < tmp_004.length ())
			{
			tmp_008 = tmp_008 + tmp_004.mid (rc_003, 1);
			rc_003 = rc_003 + 1;
			}
		rc_001 = tmp_008.toInt (&ok, 10);
		if (ok == true)
			{
			avvalue->setValue (rc_001);
			}
		else
			{
			avvalue->setValue (0);
			}
		}
		else
		{
		avvalue->setValue (0);
		}
		}
	else
		{
		textLabel2_11->setText ("A/V sync (ms) : 0");
		avvalue->setValue (0);
		}
	//
	lineEdit8->setText (i->text (7));
	titre_element->setText (i->text (0));
	path_video = i->text (1);
	if (lineEdit8->text () != "")
		{
		QImage myimg (lineEdit8->text (), 0);
		QPixmap mypix (myimg);
		appimgbt->setPixmap (mypix);
		appimgbt->show ();
		}
	else
		{
		appimgbt->hide ();
		}
	panneau_titre->show ();
	panneau_titre->raise ();
	rc_004 = 1;
	}
	}

	/* Something with chapters chapters */ 			
	void
	mainfrm::slider5_valueChanged (int) {
	// ****************************************
	// *** Changement / aggrandissement du bouton ***
	// ****************************************
	longueur = wdeflong + slider5->value ();
	//
	if (720 - longueur > 60)
	{
	clqconstruct->setGeometry (1001, 0, longueur, hauteur);
	clqconstruct->setPixmap (save_fond_2.copy
				(slider_x->value (), slider_y->value (),
					longueur, hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter (this);
	mypainter.end ();
	mypainter.begin (clqconstruct->pixmap ());
	
	mypainter.drawImage (0, 0,
				wsavbtmenu.scale (longueur, hauteur,
						QImage::ScaleFree), 0, 0, -1,
				-1);
	mypainter.end ();
	bt_fantome->setGeometry (23 + slider_x->value (),
				23 + slider_y->value (), longueur, hauteur);
	bt_fantome->setPixmap (*clqconstruct->pixmap ());
	// *** Rglage des barres de dfilement ***
	slider_x->setMaxValue (720 - longueur);
	}
	else
	{
	longueur = wdeflong - slider5->value ();
	}
	}
	
	