/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Node;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.ParserConstants;
import org.apache.taglibs.standard.lang.jpath.expression.ParserTreeConstants;
import org.apache.taglibs.standard.lang.jpath.expression.Token;
import org.apache.taglibs.standard.lang.jpath.expression.ValidationException;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;
    protected String image;
    protected int beginColumn;
    protected int endColumn;
    protected int beginLine;
    protected int endLine;
    protected Token firstToken;
    protected Token lastToken;
    protected Object val;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Parser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + " ");
                }
                ++i;
            }
        }
    }

    public String stringDump(String prefix) {
        String result = prefix + this.toString() + "\n";
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    result = result + n.stringDump(prefix + "     ");
                }
                ++i;
            }
        }
        return result;
    }

    public String toNormalizedString() {
        String normalized = "toNormalizedString() not implemented in [" + ParserTreeConstants.jjtNodeName[this.id] + "]";
        return normalized;
    }

    public String toOriginalString() {
        String result = "";
        Token t = this.firstToken;
        boolean finished = false;
        while (!finished) {
            result = result + this.getSpecialTokenString(t);
            if (t.image != null) {
                while (result.length() < t.beginColumn - 1) {
                    result = result + " ";
                }
                result = result + t.image;
            }
            if (t == this.lastToken) {
                finished = true;
                continue;
            }
            t = t.next;
        }
        return result;
    }

    public String rootOriginalString() {
        SimpleNode current = this;
        while (current.parent != null) {
            current = (SimpleNode)current.parent;
        }
        return current.toOriginalString();
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext) throws EvaluationException {
        throw new EvaluationException(this, "evaluate not supported in  [" + ParserTreeConstants.jjtNodeName[this.id] + "]");
    }

    public String getTokenImage(int tokenNumber) {
        String tokenImage = ParserConstants.tokenImage[tokenNumber];
        return tokenImage.substring(1, tokenImage.length() - 1);
    }

    private String getSpecialTokenString(Token t) {
        String result = t.specialToken == null ? "" : this.getSpecialTokenString(t) + t.image;
        return result;
    }

    public void validate() throws ValidationException {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.validate();
                }
                ++i;
            }
        }
    }

    public Node simplify() {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    SimpleNode simpleNode = (SimpleNode)n.simplify();
                }
                ++i;
            }
        }
        return this;
    }
}

