/*
 * Copyright (c) 2005-2007 Laf-Widget Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Laf-Widget Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.lafwidget.animation;

/**
 * Fade animation kind.
 * 
 * @author Kirill Grouchnikov.
 */
public class FadeKind {
	/**
	 * Fade kind ID.
	 */
	protected String id;

	/**
	 * Creates a new fade kind which is allowed by default.
	 * 
	 * @param id
	 *            Fade kind ID.
	 */
	public FadeKind(String id) {
		this(id, true);
	}

	/**
	 * Creates a new fade kind.
	 * 
	 * @param id
	 *            Fade kind ID.
	 * @param isDefaultAllowed
	 *            Indicates whether the newly create fade kind is allowed by
	 *            default.
	 */
	public FadeKind(String id, boolean isDefaultAllowed) {
		this.id = id;
		if (isDefaultAllowed) {
			FadeConfigurationManager.getInstance().allowFades(this);
		}
	}

	/**
	 * Arming a component.
	 */
	public static final FadeKind ARM = new FadeKind("lafwidgets.core.arm");

	/**
	 * Pressing a component.
	 */
	public static final FadeKind PRESS = new FadeKind("lafwidgets.core.press");

	/**
	 * Focusing a component.
	 */
	public static final FadeKind FOCUS = new FadeKind("lafwidgets.core.focus");

	/**
	 * <p>
	 * Fade kind for focus loop animation. Disabled by default, use
	 * {@link FadeConfigurationManager#allowFades(FadeKind)} to enable.
	 * </p>
	 * 
	 * @since version 3.0
	 */
	public static final FadeKind FOCUS_LOOP_ANIMATION = new FadeKind(
			"lafwidgets.core.focusLoopAnimation", false);

	/**
	 * Enabling a component.
	 */
	public static final FadeKind ENABLE = new FadeKind("lafwidgets.core.enable");

	/**
	 * Rollover a component.
	 */
	public static final FadeKind ROLLOVER = new FadeKind(
			"lafwidgets.core.rollover");

	/**
	 * Selecting a component.
	 */
	public static final FadeKind SELECTION = new FadeKind(
			"lafwidgets.core.selection");

	/**
	 * Fade kind that specifies the "ghosting image" effects on button icons
	 * when the button is rolled-over. Disabled by default, use
	 * {@link FadeConfigurationManager#allowFades(FadeKind)} to enable.
	 */
	public static final FadeKind GHOSTING_ICON_ROLLOVER = new FadeKind(
			"lafwidgets.core.ghosting.iconRollover", false);

	/**
	 * Fade kind that specifies the "ghosting image" effects on buttons when the
	 * button is pressed. Disabled by default, use
	 * {@link FadeConfigurationManager#allowFades(FadeKind)} to enable.
	 */
	public static final FadeKind GHOSTING_BUTTON_PRESS = new FadeKind(
			"lafwidgets.core.ghosting.buttonPress", false);

	/**
	 * Fade kind that specifies the "glow" effects on icons when the relevant
	 * control is rolled over. Disabled by default, use
	 * {@link FadeConfigurationManager#allowFades(FadeKind)} to enable.
	 */
	public static final FadeKind ICON_GLOW = new FadeKind(
			"lafwidgets.core.iconGlow", false);

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return this.id.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof FadeKind) {
			return this.id.equals(((FadeKind) obj).id);
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.id;
	}

	// /**
	// * Marking a component as modified.
	// */
	// public static final FadeKind MARKED_MODIFIED = new FadeKind(
	// "lafwidgets.core.arm");
}