/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.object-refinery.com/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2003, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ------------------------------
 * GroupListTest.java
 * ------------------------------
 * (C)opyright 2003, by Thomas Morgner and Contributors.
 *
 * Original Author:  Thomas Morgner;
 * Contributor(s):   David Gilbert (for Simba Management Limited);
 *
 * $Id: GroupListTest.java,v 1.2 2003/06/10 18:17:26 taqua Exp $
 *
 * Changes
 * -------------------------
 * 30.05.2003 : Initial version
 *
 */

package com.jrefinery.report.ext.junit.base.basic;

import com.jrefinery.report.Group;
import com.jrefinery.report.GroupList;
import junit.framework.TestCase;

public class GroupListTest extends TestCase
{
  public GroupListTest(String s)
  {
    super(s);
  }

  public void testCreate()
  {
    GroupList gl = new GroupList();
    gl.clear();
    assertNotNull(gl.clone());
    assertNotNull(gl.iterator());
    assertNotNull(gl.toString());
  }

  public void testMethods()
  {
    GroupList gl = new GroupList();
    try
    {
      gl.add(null);
    }
    catch (NullPointerException npe)
    {
    }

    Group g1 = new Group();
    gl.add(g1);
    gl.add(g1);
    assertTrue(gl.size() == 1); // the old instance gets removed and replaced by the new group
    gl.add(new Group());
    assertTrue(gl.size() == 1); // the old instance gets removed and replaced by the new group

    Group g2 = new Group();
    g2.addField("Test");

    Group g3 = new Group();
    g3.addField("Failure");

    // group g2 and g3 are unreleated, g2 is no child or parent of g3
    gl.add(g2);
    try
    {
      gl.add(g3);
      fail();
    }
    catch (IllegalArgumentException iea)
    {
    }
    assertTrue(gl.size() == 2);
  }
}
