/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.transporter.ssl;

import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transporter.TransporterServer;
import org.jboss.remoting.InvokerLocator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Server
{

   private TransporterServer server;

   /**
    * runs and starts the Server
    *
    * @param args
    */
   public static void main(String[] args)
   {
      Server server = new Server();
      server.init();
   }

   public void init()
   {
      String locatorURL = "sslsocket://127.0.0.1:7070";

      HandlerInterface handler = new Handler();
      try
      {
         Map config = getConfiguration();
         server = TransporterServer.createTransporterServer(locatorURL,
                                                            handler, HandlerInterface.class.getName(), config, false);
         server.start();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

   }

   /**
    * creates a ServerSocketFactory that is configured by using an
    * SSLSocketBuilder
    *
    * @return configuration Map
    * @throws IOException if the Factory could not be created
    */
   private HashMap getConfiguration()
   {
      HashMap sslConfig = new HashMap();

      String keyStoreFilePath = this.getClass().getResource("certificate/.keystore").getFile();
      String trustStoreFilePath = this.getClass().getResource("certificate/.truststore").getFile();

      sslConfig.put(SSLSocketBuilder.REMOTING_KEY_STORE_FILE_PATH,
                    keyStoreFilePath);
      sslConfig.put(SSLSocketBuilder.REMOTING_KEY_STORE_PASSWORD, "unit-tests-server");
      sslConfig.put(SSLSocketBuilder.REMOTING_TRUST_STORE_FILE_PATH,
                    trustStoreFilePath);
      sslConfig.put(SSLSocketBuilder.REMOTING_TRUST_STORE_PASSWORD,
                    "unit-tests-client");
      sslConfig.put(SSLSocketBuilder.REMOTING_CLIENT_AUTH_MODE,
                    SSLSocketBuilder.CLIENT_AUTH_MODE_NEED);
      sslConfig.put("numAcceptThreads", "2");
      return sslConfig;
	}
}