/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

import javax.management.MBeanServer;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ConfigurationTestClient extends TestCase
{
   protected static Logger log = Logger.getLogger(ConfigurationTestClient.class);
   protected static ServerSocket syncServerSocket;
   protected static Socket syncSocket;
   protected static OutputStream os;
   
   protected void setUp()
   {
      if (syncServerSocket == null)
      {
         try
         {
            syncServerSocket = new ServerSocket();
            InetSocketAddress syncAddress = new InetSocketAddress(ConfigurationTestServer.syncHost,
                  ConfigurationTestServer.syncPort);
            syncServerSocket.bind(syncAddress);
            syncSocket = syncServerSocket.accept();
            os = syncSocket.getOutputStream();
         }
         catch (Exception e)
         {
            log.error(e);
            e.printStackTrace();
         }
      }
   }
   
   protected void tearDown()
   {
      try
      {
         // Tell test server test is over.
         os.write(17);
         
         // Give server a chance to shut down.
         Thread.sleep(2000);
         
         os.close();
         syncSocket.close();
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
      }
      
   }

   
   public static class SampleInvocationHandler implements ServerInvocationHandler
   {
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         return new Object();
      }

      public void addListener(InvokerCallbackHandler callbackHandler)
      {
      }

      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
      }

      public void setMBeanServer(MBeanServer server)
      {
      }

      public void setInvoker(ServerInvoker invoker)
      {
      }
   }
}
