/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import org.workingfrog.i18n.util.Localizer;
import org.workingfrog.i18n.util.Validator;

public class Translator {
    public static final int NONE = 0;
    public static final int L10N = 1;
    public static final int I18N = 2;
    public static final int NAMING = 3;
    public static final int ALL = 4;
    private static int level = 4;
    private static String path;
    private static HashSet loadedBundles;
    private static Validator validator;
    private static Locale defaultLocale;

    static {
        loadedBundles = new HashSet();
        validator = new Validator();
        defaultLocale = new Locale("en", "");
    }

    public static void setBundlesPath(String path) {
        Translator.path = path;
    }

    public static void loadBundle(String binding, String resource) {
        boolean succeeded = true;
        try {
            loadedBundles.add(binding);
            Localizer.addResource(binding, resource);
        }
        catch (MissingResourceException e) {
            Translator.log("Resource " + resource + " not found.");
            succeeded = false;
        }
        if (succeeded) {
            validator.storeBundle(binding);
        }
    }

    public static void loadBundle(String binding) {
        Translator.loadBundle(binding, String.valueOf(path) + "." + binding);
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale;
    }

    public static void setLocale(Locale locale) {
        Localizer.switchCurrentLocale(locale);
        validator.clearLogs();
    }

    public static String localize(String i18nKey, Object source) {
        Translator.lazyLoadBundle(validator.getBinding(i18nKey));
        if (!validator.check(i18nKey)) {
            Translator.log(validator.getReport());
        }
        String result = validator.getLocalizedValue();
        if (validator.isValidBundle()) {
            return result;
        }
        return result;
    }

    private static void lazyLoadBundle(String binding) {
        if (!loadedBundles.contains(binding)) {
            Translator.loadBundle(binding);
        }
    }

    public static void check(int level) {
        Translator.level = level;
    }

    public static boolean isChecking(int level) {
        return Translator.level == 4 || Translator.level == level;
    }

    public static void checkKey(String i18nKey, Object source) {
        if (!validator.checkName(i18nKey)) {
            Translator.log(validator.getReport());
        }
    }

    public static boolean isValidBundle(String i18nKey) {
        Translator.lazyLoadBundle(validator.getBinding(i18nKey));
        return validator.checkBundle(validator.getBinding(i18nKey));
    }

    public static String checkValue(String binding, String i18nKey, Object source) {
        return Translator.localize(i18nKey, source);
    }

    public static boolean checkObject(Object object, Object source) {
        return validator.isLocaleListener(object, source);
    }

    public static void log(int level, String message) {
        if (Translator.isChecking(level)) {
            Translator.log(message);
        }
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static Locale[] getLocales(Object object) {
        Locale[] locales = Localizer.getLocales(object);
        Locale[] result = new Locale[locales.length + 1];
        result[0] = defaultLocale;
        int i = 0;
        while (i < locales.length) {
            result[i + 1] = locales[i];
            ++i;
        }
        return result;
    }
}

