/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.workingfrog.i18n.swing.I18NAction;
import org.workingfrog.i18n.swing.I18NActionWrapper;
import org.workingfrog.i18n.swing.I18NJMenuItem;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJMenu
extends JMenu
implements LocaleListener {
    private String bundle = "menu";
    private String i18nKey = "menu.error";

    public I18NJMenu(String i18nKey) {
        super(i18nKey);
        if (this.bundle != null && i18nKey != null) {
            this.setText(Translator.checkValue(this.bundle, i18nKey, this));
        }
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
    }

    public JMenuItem add(Action a) {
        JMenuItem mi = this.createActionComponent(a);
        mi.setAction(a);
        if (a instanceof LocaleListener) {
            mi.setText(Translator.checkValue(this.bundle, ((I18NAction)a).getKey(), this));
        }
        this.add(mi);
        return mi;
    }

    protected JMenuItem createActionComponent(Action a) {
        I18NJMenuItem mi = a instanceof I18NAction || a instanceof I18NActionWrapper ? new I18NJMenuItem(a instanceof I18NAction ? ((I18NAction)a).getKey() : ((I18NActionWrapper)a).getKey()) : new I18NJMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = I18NJMenu.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        return mi;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
        if (this.i18nKey != null) {
            this.setText(Translator.checkValue(bundle, this.i18nKey, this));
        }
    }

    public void localeChanged(LocaleEvent event) {
        this.setText(Translator.checkValue(this.bundle, this.i18nKey, this));
        int componentNumber = this.getMenuComponentCount();
        System.out.println("componentNumber (JMenu) = " + componentNumber);
        int i = 0;
        while (i < componentNumber) {
            Component component = this.getMenuComponent(i);
            if (component instanceof LocaleListener) {
                ((LocaleListener)((Object)component)).localeChanged(event);
            } else if (!(component instanceof JPopupMenu.Separator)) {
                Translator.log(2, "JMenu, N : " + component.toString());
            }
            ++i;
        }
    }
}

