/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJButton
extends JButton
implements LocaleListener {
    private String bundle = "button";
    private String i18nKey = "button.error";
    private String i18nToolTipKey = "button.error";

    public I18NJButton() {
    }

    public I18NJButton(Icon icon) {
        super(icon);
    }

    public I18NJButton(String bundle, String i18nKey) {
        super(i18nKey);
        this.setText(Translator.checkValue(bundle, i18nKey, this));
        this.bundle = bundle;
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
    }

    public I18NJButton(String bundle, String i18nKey, Icon icon) {
        this(bundle, i18nKey);
        this.setModel(new DefaultButtonModel());
        this.setIcon(icon);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setToolTipText(String i18nToolTipKey) {
        this.i18nToolTipKey = i18nToolTipKey;
        if (i18nToolTipKey != null) {
            super.setToolTipText(Translator.checkValue(this.bundle, i18nToolTipKey, this));
        }
    }

    public void localeChanged(LocaleEvent event) {
        Action action = this.getAction();
        if (action != null) {
            if (action instanceof LocaleListener) {
                ((LocaleListener)((Object)action)).localeChanged(event);
            }
        } else if (this.i18nKey != null) {
            this.setText(Translator.checkValue(this.bundle, this.i18nKey, this));
        }
        if (this.i18nToolTipKey != null) {
            super.setToolTipText(Translator.checkValue(this.bundle, this.i18nToolTipKey, this));
        }
    }
}

