/* Diameter.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.standard;

import org.grinvin.GraphBundleView;
import org.grinvin.invariants.IntegerValue;
import org.grinvin.invariants.computers.AbstractInvariantComputer;

/**
 * Computes the diameter of the graph.
 */
public class Diameter extends AbstractInvariantComputer {
    
    public IntegerValue compute (GraphBundleView bundle) {
        int[] eccentricityList = bundle.eccentricityList();
        int n = eccentricityList.length;
        if (n <= 1) {
            if (n == 0)
                return IntegerValue.undefinedValue (this);
            else 
                return new IntegerValue (0, this);
        }
        if(eccentricityList[1]==Integer.MAX_VALUE)
            return IntegerValue.positiveInfinity (this);
        int diam = 0;
        for (int eccentricity : eccentricityList) {
            if (eccentricity > diam)
                diam = eccentricity;
        }
        return new IntegerValue (diam, this);
    }
    
    public String getInvariantId () {
        return "org.grinvin.invariants.Diameter";
    }
}
