/* NumberOfVerticesOfDegree.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.simple;

import org.grinvin.GraphBundleView;
import org.grinvin.factories.AbstractFactory;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.invariants.IntegerValue;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantComputerFactory;
import org.grinvin.invariants.InvariantFactory;

/**
 * Factory for an invariant computer which counts the number of vertices of a
 * given degree.
 */
public class NumberOfVerticesOfDegree extends AbstractFactory implements InvariantComputerFactory {
    
    //
    private static class Computer implements InvariantComputer {
        
        
        Computer () {
            // prevents creation of access type
        }
        
        //
        public int degree;
        
        //
        public String id;
        
        //
        public String version;
        
        //
        public String invariantId;
        
        //
        public String getId () {
            return id;
        }
        
        //
        public String getInvariantId () {
            return invariantId;
        }
        
        //
        public String getVersion () {
            return version;
        }
        
        public IntegerValue compute (GraphBundleView bundle) {
            int count = 0;
            for (int[] neighbours : bundle.adjacencyList ())
                if (neighbours.length == degree)
                    count ++;
            return new IntegerValue (count, this);
        }
    }
    
    public InvariantComputer createInvariantComputer (InvariantFactory invFactory) throws FactoryParameterException {
        
        assert invFactory.getId ().equals (getInvariantId ());
        
        int degree = ((Integer)invFactory.getParameterValues ()[0]).intValue();
        if (degree < 0)
            throw new  FactoryParameterException ("Degree should be positive");
        Computer computer = new Computer ();
        computer.degree = degree;
        computer.id = getClass().getName () + "(" + degree + ")";
        computer.invariantId = getInvariantId() + "?degree=" + degree;
        computer.version = getVersion ();
        return computer;
    }
    
    public String getVersion () {
        return "1.0";
    }

    public String getInvariantId () {
        return "org.grinvin.invariants.NumberOfVerticesOfDegree";
    }

    public String getId () {
        return "org.grinvin.invariants.NumberOfVerticesOfDegree";
    }
    
}
