/* NumberOfTriangles.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.simple;

import org.grinvin.GraphBundleView;
import org.grinvin.invariants.IntegerValue;
import org.grinvin.invariants.computers.AbstractInvariantComputer;

/**
 * Invariant computer which returns the number of triangles in the graph.
 */
public class NumberOfTriangles extends AbstractInvariantComputer {
    
    public IntegerValue compute(GraphBundleView bundle) {
        int[][] adjlist = bundle.adjacencyList();
        boolean[][] adjmatrix = bundle.booleanAdjacencyMatrix();
        int count = 0;
        
        for(int i = 0; i < adjlist.length - 1; i++)
            for(int j = 0; j < adjlist[i].length-1; j++)
                if(adjlist[i][j]>i)
                    for(int k = j+1; k < adjlist[i].length; k++)
                        if(adjlist[i][k]>i //adjlist[i] is not sorted!!!
                            && adjmatrix[adjlist[i][j]][adjlist[i][k]])
                            count++;
        return new IntegerValue(count, this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.NumberOfTriangles";
    }
    
}
