/* SaveConjectureHistoryAction.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet.actions;

import be.ugent.caagt.swirl.actions.SimpleAction;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

import org.grinvin.worksheet.WorksheetModel;
import org.grinvin.io.list.ConjectureHistoryListSaver;
import org.grinvin.io.DirectorySectionSaver;

/**
 * Action to save the conjecture history to file.
 */
public class SaveConjectureHistoryAction extends SimpleAction {
    
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.worksheet.actions.resources");
    
    //
    private WorksheetModel model;
    
    /** Creates a new instance of SaveTestAction */
    public SaveConjectureHistoryAction(WorksheetModel model) {
        super(BUNDLE, "chist.save.description", null);
        this.model = model;
    }
    
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setFileFilter(new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".chistory");
            }
            
            public String getDescription() {
                return BUNDLE.getString("chist.filetype.description");
            }
        } );
        chooser.setMultiSelectionEnabled(false);
        if(chooser.showSaveDialog(null)==chooser.APPROVE_OPTION){
            File f = chooser.getSelectedFile();
            if(!f.getName().toLowerCase().endsWith(".chistory"))
                f = new File(f.getParent(), f.getName() + ".chistory");
            if(f.exists() && !f.isDirectory()){
                JOptionPane.showMessageDialog(null, MessageFormat.format(BUNDLE.getString("chist.file.no.directory"), f.getAbsolutePath()), BUNDLE.getString("chist.error"), JOptionPane.DEFAULT_OPTION);
                return;
            }
            if(f.exists() || f.mkdirs())
                try {
                    ConjectureHistoryListSaver.save(model.getConjectureHistoryList(), new DirectorySectionSaver(f));
                } catch (IOException ex) {
                    // TODO: log
                }
        }
    }
}
