/* GraphListPanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet;

import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.grinvin.gui.components.GraphListComponent;
import org.grinvin.gui.components.GraphPropertiesComponent;

import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListModel;

/**
 * Panel that contains a {@link GraphListComponent}.
 */
public class GraphListPanel extends JSplitPane {
    
    //
    private final GraphListComponent graphList;
    
    //
    private final GraphPropertiesComponent panel;
    
    /** Default constructor */
    public GraphListPanel(GraphListModel listModel, ListSelectionModel selectionModel) {
        super(HORIZONTAL_SPLIT, true);
        
        graphList = new GraphListComponent(listModel, selectionModel);
        setLeftComponent(new JScrollPane(graphList));
        
        panel = new GraphPropertiesComponent();
        setRightComponent(panel);
        
        selectionModel.addListSelectionListener(new Listener());
    }
    

    //
    public void setGraphPropertiesComponentDividerLocation(int location){
        panel.setDividerLocation(location);
    }
    
    public int getGraphPropertiesComponentDividerLocation(){
        return panel.getDividerLocation();
    }
    
    private class Listener implements ListSelectionListener {
        //TODO: fix listeners
        public void valueChanged(ListSelectionEvent e) {
            if (! e.getValueIsAdjusting()) {
                Object[] values = graphList.getSelectedValues();
                if (values.length > 0)
                    panel.setElement((GraphListElement)values[0]);
                else
                    panel.setElement(null);
            }
        }
    }
    
}
