/* SaveWorkspaceToDirectory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.main.actions;

import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.grinvin.gui.FileFilters;
import org.grinvin.io.WorkspaceSaver;
import be.ugent.caagt.swirl.actions.FileSaveAction;
import org.grinvin.workspace.Workspace;
import org.grinvin.workspace.WorkspaceException;

/**
 * Action to save the current workspace to a directory.
 */
public class SaveWorkspaceToDirectory extends FileSaveAction {
    // TODO: factor out code in common with SvaeWorkspaceAs
    //
    private static final String BUNDLE_NAME = "org.grinvin.main.actions.resources";
    //
    private static final Logger LOGGER = Logger.getLogger("org.grinvin.io");

    public SaveWorkspaceToDirectory(Window parent) {
        super(parent, FileFilters.WORKSPACE_FILTER);
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    }

    protected boolean showFileExistsDialog(File file) {
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);

        return JOptionPane.showConfirmDialog(
                parent,
                MessageFormat.format(bundle.getString("workspace.overwrite.message"), file.getName()),
                bundle.getString("workspace.overwrite.title"),
                JOptionPane.YES_NO_CANCEL_OPTION) == JOptionPane.YES_OPTION;
    }

    protected void saveFile(File file) {
        if (Workspace.getInstance().getLocation().equals(file)) {
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            JOptionPane.showMessageDialog(parent,
                    bundle.getString("workspace.current.message"),
                    bundle.getString("workspace.current.title"),
                    JOptionPane.OK_OPTION);
        } else {
            try {
                file.mkdirs();
                WorkspaceSaver.saveAs(Workspace.getInstance(), file);
            } catch (WorkspaceException e) {
                LOGGER.log(Level.SEVERE, "Saving workspace failed", e);
            }
        }
    }
}
