/* DefaultWorksheetListModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import java.text.MessageFormat;
import java.util.ResourceBundle;

import org.grinvin.worksheet.WorksheetWindow;
import org.grinvin.worksheet.WorksheetWindowListModel;
import org.grinvin.worksheet.WorksheetWindowModel;
import org.grinvin.worksheet.WorksheetWindowModel.SubwindowType;

/**
 * Model that contains a list of available graph lists and the current sequence number.
 */
public class DefaultWorksheetListModel implements WorksheetListModel {
    
    //
    private static final ResourceBundle BUNDLE
            = ResourceBundle.getBundle("org.grinvin.list.worksheetlist");
  
    //
    private WorksheetWindowListModel model;
    
    //
    private int listSequenceNumber;
    
    /**
     * Return the current sequence number, used for
     * the name of a new list to be added to this window.
     */
    public int getListSequenceNumber() {
        return listSequenceNumber;
    }
    
    /**
     * Set the list sequence number.
     */
    public void setListSequenceNumber(int listSequenceNumber) {
        this.listSequenceNumber = listSequenceNumber;
    }
    
    /**
     * Return the list model for this window.
     */
    public WorksheetWindowListModel getWorksheetWindowListModel() {
        return this.model;
    }
    
    /**
     * Create a new worksheet window and add it to this list. The list
     * sequence number is used for the name of this worksheet, and is incremented.
     * @return the new window
     */
    public WorksheetWindow createNewWorksheetWindow() {
        String name = MessageFormat.format(BUNDLE.getString("newworksheetname.text"), listSequenceNumber);
        listSequenceNumber ++;
        WorksheetWindowModel worksheetWindowModel = new WorksheetWindowModel();
        worksheetWindowModel.getSubwindowModel(SubwindowType.GENERATORINSTANCELIST).setVisible(false);
        worksheetWindowModel.getSubwindowModel(SubwindowType.FILTERLIST).setVisible(false);
        worksheetWindowModel.getSubwindowModel(SubwindowType.ENGINEPANEL).setVisible(false);
        worksheetWindowModel.getSubwindowModel(SubwindowType.CONJECTURELIST).setVisible(false);
        worksheetWindowModel.setName(name);
        WorksheetWindow result = new WorksheetWindow(worksheetWindowModel);
        model.add(result);
        return result;
    }
    
    /**
     * Create a new graph lists model, backed by the given listmodel.
     */
    public DefaultWorksheetListModel(WorksheetWindowListModel model) {
        this.model = model;
        this.listSequenceNumber = 1;
    }
}
