/* WorkspaceFileView.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.File;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

import org.grinvin.graphs.GraphURIType;

/**
 * <code>FileView</code> for a <code>JFileChooser</code> to open workspaces.
 */
public class WorkspaceFileView extends FileView {
    
    @Override
    public Icon getIcon(File f) {
        if(f.getName().toLowerCase().endsWith(".workspace") && new File(f, "meta.xml").exists())
            return GraphURIType.OLD_WORKSPACE.getSmallIcon();
        else if(f.getName().toLowerCase().endsWith(".gws"))
            return GraphURIType.WORKSPACE.getSmallIcon();
        else
            return null;
    }

    @Override
    public Boolean isTraversable(File f) {
        if(f.getName().toLowerCase().endsWith(".workspace") && new File(f, "meta.xml").exists())
            return false;
	return null;
    }
}
