/* AbstractInvariantComputerFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers;

import org.grinvin.factories.AbstractFactory;
import org.grinvin.graphs.GraphBundleView;
import org.grinvin.invariants.InvariantComputer;
import org.grinvin.invariants.InvariantComputerFactory;
import org.grinvin.invariants.InvariantValue;

/**
 * Abstract superclass used by most invariant computer factories. Provides a
 * standard identifier and version.
 */
public abstract class AbstractInvariantComputerFactory extends AbstractFactory implements InvariantComputerFactory {
    
    //
    private String factoryId;

    public AbstractInvariantComputerFactory() {
        initId();
    }
    
    //
    private void initId() {
        factoryId = getClass().getName();
    }
    
    public String getId() {
        return factoryId;
    }

    /**
     * {@inheritDoc}<p>
     * This implementation returns the string <code>1.0</code>.
     */
    public String getVersion() {
        return "1.0";
    }
    
    //
    protected static abstract class Computer<T extends InvariantValue> implements InvariantComputer {
        
        protected Computer () {
            // prevents creation of access type
        }
        
        //
        public String id;
        
        //
        public String version;
        
        //
        public String invariantId;
        
        //
        public String getId () {
            return id;
        }
        
        //
        public String getInvariantId () {
            return invariantId;
        }
        
        //
        public String getVersion () {
            return version;
        }
        
        public abstract T compute (GraphBundleView bundle);
        
    }

}
