/* InvariantDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import org.grinvin.gui.components.AcceptsInvariant;
import org.grinvin.invariants.Invariant;

/**
 * Common DropHandler to drop invariants on objects that support {@link AcceptsInvariant}.
 */
public class InvariantDropHandler extends AbstractDropHandler {
    
    // cannot be instantiated by clients
    private InvariantDropHandler() {
        super(Invariant.class, true);
    }
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle ("org.grinvin.gui.dnd.resources");

    /**
     * The unique shared object of this type.
     */
    private static final InvariantDropHandler DROP_HANDLER = new InvariantDropHandler();
    
    public static InvariantDropHandler getInstance() {
        return DROP_HANDLER;
    }
    
    public boolean acceptDrop (JComponent target, Object object, int seqNr) {
        if(!target.isEnabled())
            return seqNr != 0;
        if (target instanceof AcceptsInvariant && object instanceof Invariant) {
            switch (((AcceptsInvariant)target).acceptsInvariant((Invariant)object)) {
                case SUCCESS:
                    ((AcceptsInvariant)target).addInvariant((Invariant)object);
                    return true;
                case DUPLICATE:
                    JOptionPane.showMessageDialog(target, MessageFormat.format(BUNDLE.getString("droperror.invariant.duplicate"), object), BUNDLE.getString("droperror.title"), JOptionPane.DEFAULT_OPTION);
                    return true; //continue with adding remaining invariants
                case WRONG_TYPE:
                    JOptionPane.showMessageDialog(target, MessageFormat.format(BUNDLE.getString("droperror.invariant.wrong_type"), object), BUNDLE.getString("droperror.title"), JOptionPane.DEFAULT_OPTION);
                    return true; //continue with adding remaining invariants
                default:
                    return false;
            }
        } else {
            return false;
        }
    }
    
    
}
