/* RunConjecturing.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;
import java.util.ResourceBundle;

import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;

import org.grinvin.engine.AbstractInequalityEngine;
import org.grinvin.engine.EngineRunner;
import org.grinvin.engine.EngineRunner.Status;
import org.grinvin.graphbrowser.ConjecturingWindow;
import org.grinvin.graphbrowser.ConjecturingWindowListener;
import org.grinvin.invariants.Invariant;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 * GUI command which runs the QD-engine on the invariant table of a given window
 * and outputs the result to the given text area.
 */
public class RunConjecturing extends ActionCommand implements ConjecturingWindowListener {
    
    //
    private EngineRunner runner;
    
    //
    private ConjecturingWindow window;
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.list.commands.resources");
    
    /**
     * Listens to the engine and adds all generated results to the results area.
     * Disables the command while running.
     */
    private class Listener implements ChangeListener {
        //
        public void stateChanged(ChangeEvent e) {
            Status status = runner.getStatus();
            window.setStatus(status);
            if(status == Status.STOPPED)
                window.addResult(runner.getResult());
            setEnabled();
        }
        
    }
    
    public RunConjecturing(CommandManager manager, String id) {
        super(manager, id);
        window  = (ConjecturingWindow)((AttributedCommandManager)manager).getAttribute(ConjecturingWindow.class.getName());
        this.runner = window.getEngineRunner();
        runner.addChangeListener(new Listener());
        window.addConjecturingWindowListener(this);
        setEnabled();
    }
    
    // implements handleExecute
    public void handleExecute() {
        if (window.getUsableInvariantsCount()<=1){
            JOptionPane.showMessageDialog(window, BUNDLE.getString("Conjecturing.not.enough"), BUNDLE.getString("Conjecturing.warning.title"), JOptionPane.DEFAULT_OPTION);
        } else {
            Invariant invariant = window.getSelectedInvariant();
            if (invariant != null) {
                ((AbstractInequalityEngine)runner.getEngine()).setMainInvariant(runner.getSortedUsableInvariants().indexOf(invariant));
                new Thread(runner).start();
            }
        }
    }
    
    private void setEnabled(){
        setEnabled(runner.getStatus() == Status.STOPPED && window.getUsableInvariantsCount()>1 && window.getSelectedInvariant()!=null);
    }
    
    public void valueChanged(ListSelectionEvent e) {
        setEnabled();
    }
    
    public void intervalAdded(ListDataEvent e) {
        setEnabled();
    }
    
    public void intervalRemoved(ListDataEvent e) {
        setEnabled();
    }
    
    public void contentsChanged(ListDataEvent e) {
        setEnabled();
    }
}
