/* RenamePanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import be.ugent.caagt.swirl.SelectOnFocusGained;
import be.ugent.caagt.swirl.dialogs.DialogPanel;
import be.ugent.caagt.swirl.dialogs.SimpleDialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;

import org.grinvin.list.HasName;

/**
 *
 * @author adpeeter
 */
public abstract class RenamePanel extends DialogPanel {
    
    private JTextField oldName;
    
    private JTextField newName;
    
    //
    private static final Insets LEFT_INSETS = new Insets(3, 0, 3, 11);
    
    //
    private static final Insets RIGHT_INSETS = new Insets(3, 0, 3, 0);
    
    //
    public RenamePanel() {
        super(new GridBagLayout());
        
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        
        gbc.gridx = 0;
        gbc.weightx = 0;
        gbc.insets = LEFT_INSETS;
        gbc.gridy = 0;
        add(new JLabel(getOldLabelText()), gbc);
        gbc.gridy = 1;
        add(new JLabel(getNewLabelText()), gbc);
        
        oldName = new JTextField(20);
        oldName.setEditable(false);
        oldName.setFocusable(false);
        newName = new JTextField(20);
        SelectOnFocusGained.register(newName);
        
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = RIGHT_INSETS;
        gbc.gridy = 0;
        add(oldName, gbc);
        gbc.gridy = 1;
        add(newName, gbc);
    }
    
    //
    protected abstract String getOldLabelText();
    
    //
    protected abstract String getNewLabelText();
    
    //
    protected abstract String getPanelTitle();
    
    //
    protected JTextField getOldName() {
        return oldName;
    }
    
    //
    protected JTextField getNewName() {
        return newName;
    }
    
    public void showDialog(HasName element, Icon icon, Component parent) {
        assert element != null : "Dialog shown without corresponding element";
        String name = element.getName();
        getOldName().setText(name);
        getNewName().setText(name);
        SimpleDialog dialog  = createDialog(parent, getPanelTitle(), icon, true);
        getNewName().requestFocusInWindow();
        if (dialog.launchAtPointerPosition() == SimpleDialog.APPROVE_OPTION)
            element.setName(getNewName().getText());
        dialog.dispose();
    }
    
}
