/* GraphPropertiesWindow.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import java.awt.BorderLayout;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import org.grinvin.GraphURI;
import org.grinvin.graphbrowser.NamedGraphComponent;
import org.grinvin.invariants.Invariant;
import org.grinvin.render.Renderer;

import org.pietschy.command.LoadException;

/**
 * Window that displays a drawing of the graph as well as its known invariants.
 */
public class GraphPropertiesWindow extends JFrame implements GraphListElementListener {
    
    //
    private GraphListElement element;
    
    //
    private Renderer renderer;
    
    //TODO: when this window closes, discard it, and remove the listener!
    
    public GraphPropertiesWindow(GraphListElement element) {
        
        this.element = element;
        
        ResourceBundle rbundle = ResourceBundle.getBundle("org.grinvin.list.graphpropertieswindow");
        
        AttributedCommandManager commandManager = new AttributedCommandManager();
        commandManager.setAttribute(GraphPropertiesWindow.class.getName(), this);
        commandManager.setResourceBundle(rbundle);
        
        try {
            InputStream ins = GraphPropertiesWindow.class.getResourceAsStream("graphpropertieswindow.cmds");
            commandManager.load(ins);
        } catch (LoadException lex) {
            System.out.println(lex);
            throw new RuntimeException("Could not initialize menus", lex);
        }
        
        setJMenuBar(commandManager.getGroup("main.menu").createMenuBar());
        
        JScrollPane propertiestable = new JScrollPane(new GraphPropertiesTable(new GraphPropertiesTableModel(element)));

        setTitle(element.getName());
        
        NamedGraphComponent graph = new NamedGraphComponent(element);
        
        JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, graph, propertiestable);
        sp.setOpaque(true);
        sp.setBackground(GraphURI.getType(element.getURI()).getIconBackgroundColor());
        getContentPane().add(sp, BorderLayout.CENTER);
        
        element.addGraphListElementListener(this);
        
        pack();
    }
    
    public GraphListElement getModel() {
        return element;
    }
    
    public void graphListElementURIChanged(GraphListElement element) {
        //ignore
    }

    public void graphListElementNameChanged(GraphListElement element) {
        setTitle(element.getName());
    }

    public void graphListElementInvariantComputed(GraphListElement element, Invariant invariant) {
        //ignore
    }

    public void graphListElementGraphChanged(GraphListElement element) {
        //ignore
    }
    
}
