/* GraphPropertiesTable.java
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.dnd.LocalTransferHandler;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.help.CSH;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellRenderer;

import org.grinvin.graphbrowser.AcceptsInvariant;
import org.grinvin.graphbrowser.InvariantDropHandler;
import org.grinvin.graphbrowser.InvariantFactoryDropHandler;
import org.grinvin.help.GraphPropertiesTableHelpManager;
import org.grinvin.help.HelpManager;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantValue;

/**
 * Table to display a GraphPropertiesTableModel.
 */
public class GraphPropertiesTable extends JTable implements AcceptsInvariant, GraphPropertiesTableModelListener {
    
    // shared transfer handler
    private static final LocalTransferHandler TRANSFER_HANDLER;
    
    static {
        TRANSFER_HANDLER = new LocalTransferHandler();
        TRANSFER_HANDLER.addDropHandler(InvariantDropHandler.DROP_HANDLER);
        TRANSFER_HANDLER.addDropHandler(InvariantFactoryDropHandler.DROP_HANDLER);
    }
    
    //
    private GraphListElement gle;
    
    /** Creates a new instance of GraphPropertiesTable */
    public GraphPropertiesTable(final GraphPropertiesTableModel model) {
        super(model);
        setElement(model.getGraphListElement());
        setTransferHandler(TRANSFER_HANDLER);
        setDefaultRenderer(Invariant.class, new InvariantTableCellRenderer());
        setDefaultRenderer(InvariantValue.class, new InvariantValueTableCellRenderer());
        HelpManager.enableHelpKey(this, "intro");
        CSH.addManager(new GraphPropertiesTableHelpManager(this));

        addHierarchyListener(new HierarchyListener() {
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & HierarchyEvent.SHOWING_CHANGED) == HierarchyEvent.SHOWING_CHANGED) {
                    if (GraphPropertiesTable.this.isShowing()) {
                        model.addGraphPropertiesTableModelListener(GraphPropertiesTable.this);
                    } else {
                        model.removeGraphPropertiesTableModelListener(GraphPropertiesTable.this);
                    }
                }
            }
        });
        
    }
    
    private void setElement(GraphListElement element) {
        gle = element;
    }
    
    public boolean addInvariant(Invariant invariant) {
        ((GraphPropertiesTableModel)super.getModel()).getGraphListElement().getInvariantNow(invariant);
        return true;
    }
    
    public void graphListElementChanged() {
        setElement(((GraphPropertiesTableModel)getModel()).getGraphListElement());
    }
    
    // allow dropping below the table,
    // solution from http://weblogs.java.net/blog/shan_man/archive/2006/01/enable_dropping.html
    public boolean getScrollableTracksViewportHeight() {
        // fetch the table's parent
        Container viewport = getParent();
        
        // if the parent is not a viewport, calling this isn't useful
        if (!(viewport instanceof JViewport)) {
            return false;
        }
        
        // return true if the table's preferred height is smaller
        // than the viewport height, else false
        return getPreferredSize().height < viewport.getHeight();
    }

}
