/* SVGURLConnection.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import org.grinvin.gui.icons.SvgIconManager;

class SVGURLConnection extends URLConnection{
    
    private String svg;
    private int width;
    private int height;
    
    SVGURLConnection(URL url) throws IOException {
        super(url);
        svg = url.getPath();
        parseQuery(url.getQuery());
    }
    
    synchronized public void connect() throws IOException {
        //do nothing
    }
    

    synchronized public InputStream getInputStream() throws IOException {
        return SvgIconManager.getInstance().getImageAsStream(svg,width,height);
    }
    
    public String getContentType() {
        return "image/png";
    }
    
    private void parseQuery(String query){
        if(query==null)
            return;
        String[] parameters = query.split("&");
        for(String parameter : parameters)
            parseParameter(parameter);
    }
    
    //simply return when an error occurs
    //this class should not create exception because of wrong parameters
    private void parseParameter(String parameter){
        if(parameter.length()==0)
            return;
        int pos = parameter.indexOf('=');
        if (pos < 0 || parameter.indexOf(pos+1, '=') >= 0)
            return;
        try {
            String parameterName = URLDecoder.decode(parameter.substring(0, pos), "UTF-8");
            int parameterValue = Integer.parseInt(URLDecoder.decode(parameter.substring(pos+1), "UTF-8"));
            if(parameterName.equalsIgnoreCase("width"))
                width = parameterValue;
            else if(parameterName.equalsIgnoreCase("height"))
                height = parameterValue;
            else if(parameterName.equalsIgnoreCase("size")) {
                width = parameterValue;
                height = parameterValue;
            }
        } catch (UnsupportedEncodingException ex) {
            //do nothing
        } catch (NumberFormatException ex) {
            //do nothing
        }

    }
}
