/* NewWorkspaceCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin.commands;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.grinvin.workspace.Workspace;
import org.grinvin.workspace.WorkspaceException;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 *
 * @author adpeeter
 */
public class NewWorkspaceCommand extends ActionCommand {

    //
    private static final ResourceBundle BUNDLE 
            = ResourceBundle.getBundle("org.grinvin.grinvin.commands.resources");

    public NewWorkspaceCommand(CommandManager manager, String commandId) {
        super(manager, commandId);
    }
    
    // implements handleExecute
    public void handleExecute() {
        try {
            File directory = selectNewWorkspaceLocation();
            if (directory != null)
                Workspace.getInstance().newWorkspace(directory);
        } catch (WorkspaceException ex) {
            throw new RuntimeException ("Could not create new workspace");
        }
    }

    /**
     * Ask the user for a workspace location.
     * @return directory which will hold the workspace, or null when no directory
     * could be chosen.
     */
    public static File selectNewWorkspaceLocation () {
            // TODO: factor out common functionality with SaveWorkspaceAsCommand
            // TODO: do not derive SaveWorkspaceAsCommand from AbstractSaveAsCommand
        
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        ExtensionFileFilter filter = 
                new ExtensionFileFilter("workspace", BUNDLE.getString ("workspace.folder"));
        chooser.setFileFilter(filter);
        
        if (chooser.showDialog(null, BUNDLE.getString("workspace.save.caption")) 
            == JFileChooser.APPROVE_OPTION) {
            
            File directory = filter.checkAndAddExtension(chooser.getSelectedFile());
            if (directory.exists()) {
                int response = JOptionPane.showConfirmDialog(null,
                        MessageFormat.format(BUNDLE.getString("workspace.overwrite.message"), directory),
                        BUNDLE.getString("workspace.overwrite.title"),
                        JOptionPane.YES_NO_CANCEL_OPTION);
                if (response == JOptionPane.YES_OPTION)
                    return directory;
                else if (response == JOptionPane.NO_OPTION)
                    return selectNewWorkspaceLocation();
            }
            else {
                if (directory.mkdir())
                    return directory;
                else
                    throw new RuntimeException ("Could not create new workspace");
            }    
        }
        return null;
    }
}
