/* GuidesTool.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.guides;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

import org.grinvin.GraphURIType;
import org.grinvin.gred.GraphPanel;
import org.grinvin.gred.Guides;
import org.grinvin.help.HelpManager;

/**
 * Dialog window with buttons to change the guides for a given graph panel.
 */
public class GuidesTool extends JDialog {
    
    private class ChangeGuides implements ActionListener {
        
        private Guides guides;
        
        public ChangeGuides (Guides guides) {
            this.guides = guides;
        }
        
        public void actionPerformed (ActionEvent e) {
            graphPanel.setGuides (guides);
        }
        
    }
    
    
    // TODO: should be configurable
    private static final Guides[] GUIDES =
    new Guides[] {
        new GridLines (2,2),
        new GridLines (3,3),
        new GridLines (4,4),
        new GridLines (5,5),
        new GridLines (2,3),
        new GridLines (2,4),
        new GridLines (3,4),
        new NullGuides (),
        new BullsEye (2,4),
        new BullsEye (2,5),
        new BullsEye (2,6),
        new BullsEye (2,8),
        new BullsEye (3,4),
        new BullsEye (3,5),
        new BullsEye (3,6),
        new BullsEye (3,8),
        new BullsEye (3,0),
        new BullsEye (4,0),
        new BullsEye (5,0),
        new BullsEye (6,0),
        new VerticalIsometricGrid (5),
        new VerticalIsometricGrid (6),
        new VerticalIsometricGrid (7),
        new VerticalIsometricGrid (8)
    };
    
    //
    private JButton createButton (Guides guides) {
        JButton button = new JButton (guides.getButtonIcon ());
        button.addActionListener (new ChangeGuides (guides));
        button.setPreferredSize (new Dimension (35,35));
        button.setOpaque (true);
        button.setBackground (GraphURIType.GRAPH_SESSION.getIconBackgroundColor());
        return button;
    }
    
    //
    private GraphPanel graphPanel;
    
    /**
     * Create a tool of this type which is connected to the given graph panel
     * and owner.
     */
    public GuidesTool (JFrame owner, GraphPanel graphPanel, ResourceBundle bundle) {
        super (owner, bundle.getString ("guidesTool.title"), false);
        this.graphPanel = graphPanel;
        
        JPanel panel = new JPanel (new GridLayout (0, 4));
        for (Guides guides : GUIDES)
            panel.add (createButton (guides));
        
        setResizable (false);
        setContentPane (panel);
        setDefaultCloseOperation (HIDE_ON_CLOSE);
        pack ();
        
        //help
        HelpManager.setHelpIDString(this, "org.grinvin.window.editor.guides");
        HelpManager.enableHelpKey(this.getRootPane(), "org.grinvin.window.editor.guides");
   }
    
}
