/* DeleteSelectedGraphs.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import javax.swing.ListSelectionModel;

import org.grinvin.list.DefaultGraphList;
import org.grinvin.list.GraphList;
import org.pietschy.command.ActionCommand;

import org.pietschy.command.CommandManager;

/**
 * Action that removes the current selected graphs in a given GraphList.
 * GraphList and SelectionModel must be installed
 * as attributes to the command manager with keys
 * {@code GraphList.class.getName()} and {@code SelectionModel.class.getName()}
 */
public class DeleteSelectedGraphs extends ActionCommand {
    
    //
    private ListSelectionModel selectionModel;
    
    //
    private GraphList graphList;
    
    /**
     * Construct an action of this kind.
     */
    public DeleteSelectedGraphs(CommandManager manager, String id) {
        super(manager, id);
        this.graphList = (GraphList)((AttributedCommandManager)manager).getAttribute(GraphList.class.getName());
        this.selectionModel = (ListSelectionModel)((AttributedCommandManager)manager).getAttribute(ListSelectionModel.class.getName());
    }
    
    /**
     * delete the current selected graphs in the snapshot list.
     */
    public void handleExecute() {
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        
        if (iMin < 0 || iMax < iMin)
            return ; // no selection
        
        // gather all elements to be deleted
        GraphList list = new DefaultGraphList();
        for(int i = iMax; i >= iMin; i--)
            if (selectionModel.isSelectedIndex(i))
                list.add(graphList.get(i));
        
        // and remove them
        graphList.removeAll(list);
    }
    
}
