/* InvariantDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import be.ugent.caagt.swirl.dnd.DropHandler;
import java.text.MessageFormat;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import org.grinvin.invariants.Invariant;

/**
 * Common DropHandler to drop invariants on objects that support {@link HasInvariantList}.
 */
public class InvariantDropHandler implements DropHandler {
    
    // cannot be instantiated by clients
    private InvariantDropHandler() {
        // empty
    }
    
    //
    private static final Class INVARIANT = Invariant.class;
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle ("org.grinvin.graphbrowser.resources");

    /**
     * The unique shared object of this type.
     */
    public static final InvariantDropHandler DROP_HANDLER = new InvariantDropHandler();
    
    public boolean allowsMultipleDrops (JComponent target) {
        return true;
    }

    public Class<?> getDropClass (JComponent target) {
        return INVARIANT;
    }

    public boolean acceptDrop (JComponent target, Object object, int seqNr) {
        if (target instanceof HasInvariantList && object instanceof Invariant) {
            if(!((HasInvariantList)target).getInvariantList().contains(object)){
                ((HasInvariantList)target).getInvariantList().add((Invariant)object);
                return true;
            } else {
                JOptionPane.showMessageDialog(target, MessageFormat.format(BUNDLE.getString("InvariantList.duplicate"), object), BUNDLE.getString("InvariantList.warning.title"), JOptionPane.DEFAULT_OPTION);
                return true; //continue with adding remaining invariants
            }
        } else if (target instanceof AcceptsInvariant && object instanceof Invariant) {
            ((AcceptsInvariant)target).addInvariant((Invariant)object);
            return true;
        } else {
            return false;
        }
    }
    
    
}
