/* GraphBrowserMultiPanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;

import org.grinvin.list.GraphInvariantListModel;
import org.grinvin.list.GraphList;

/**
 * Component that holds different views for a {@link GraphInvariantListModel}.
 */
public class GraphBrowserMultiPanel extends JPanel {
    
    //
    private Map<String,GraphBrowserPanel> panels;
    
    //
    private GraphInvariantListModel graphInvariantListModel;
    
    //
    private JPanel panel;
    
    //
    private CardLayout cardLayout;
    
    //
    private ListSelectionModel selectionModel;
    
    //
    private String currentComponent;
    
    //
    public GraphInvariantListModel getGraphInvariantListModel() {
        return graphInvariantListModel;
    }
    
    /**
     * Return the graph list model for this window.
     */
    //TODO: remove this getGraphListModel?
    public GraphList getGraphList() {
        return graphInvariantListModel.getGraphList();
    }
    
    /**
     * Return the selection model for this window.
     */
    //TODO: remove this getSelectionModel
    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }
    
    
    /** Creates a new instance of GraphBrowserMultiPanel */
    public GraphBrowserMultiPanel(GraphInvariantListModel model) {
        super(new CardLayout());
        
        this.graphInvariantListModel = model;
        this.panels = new HashMap<String, GraphBrowserPanel>();
        
        // panel that contains the different views
        this.cardLayout = new CardLayout();
        this.panel = new JPanel(cardLayout);
        //next line can be removed?
        //add (panel, BorderLayout.SOUTH); // bug #102
        add(panel, BorderLayout.CENTER);
        
        this.selectionModel = new DefaultListSelectionModel();
        
        GraphTablePanel graphInvariantTable = new GraphTablePanel(graphInvariantListModel, selectionModel);
        panels.put("graphInvariantTable", graphInvariantTable);
        
        GraphCellListPanel graphCellList = new GraphCellListPanel(graphInvariantListModel.getGraphListModel(), selectionModel);
        panels.put("graphCellList", graphCellList);
        
        GraphListPanel graphList = new GraphListPanel(graphInvariantListModel.getGraphListModel(), selectionModel);
        panels.put("graphList", graphList);
        
        panel.add(graphCellList, "graphCellList"); // displayed by default
        panel.add(graphInvariantTable, "graphInvariantTable");
        panel.add(graphList, "graphList");
    }
    
    //
    String getCurrentComponent() {
        return currentComponent;
    }
    
    //
    private void showComponent(String component){
        cardLayout.show(panel, component);
        currentComponent = component;
        panels.get(component).requestFocusInWindow();
    }
    
    /**
     * Bring up the view representing the table of invariants.
     */
    public void showInvariantTable() {
        showComponent("graphInvariantTable");
    }
    
    /**
     * Bring up the graph cell list view of this window.
     */
    public void showGraphCellList() {
        showComponent("graphCellList");
    }
    
    /**
     * Bring up the graph list  view of this window.
     */
    public void showGraphList() {
        showComponent("graphList");
    }
    
    public void setInvariantTableDividerLocation(int location){
        ((GraphTablePanel)panels.get("graphInvariantTable")).setDividerLocation(location);
    }
    
    public int getInvariantTableDividerLocation(){
        return ((GraphTablePanel)panels.get("graphInvariantTable")).getDividerLocation();
    }
    
    public void setGraphListDividerLocation(int location){
        ((GraphListPanel)panels.get("graphList")).setDividerLocation(location);
    }
    
    public int getGraphListDividerLocation(){
        return ((GraphListPanel)panels.get("graphList")).getDividerLocation();
    }
    
    public void setGraphPropertiesComponentDividerLocation(int location){
        ((GraphListPanel)panels.get("graphList")).setGraphPropertiesComponentDividerLocation(location);
    }
    
    public int getGraphPropertiesComponentDividerLocation(){
        return ((GraphListPanel)panels.get("graphList")).getGraphPropertiesComponentDividerLocation();
    }
}
