/* CommonGraphListTransferHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import be.ugent.caagt.swirl.dnd.LocalTransferHandler;
import be.ugent.caagt.swirl.dnd.DragHandler;

import javax.swing.JComponent;

import org.grinvin.list.FactoryDropHandler;
import org.grinvin.list.GraphList;
import org.grinvin.list.GraphListElement;
import org.grinvin.list.GraphListElementDropHandler;

/**
 * Common TransferHandler for all graph list components in {@link org.grinvin.graphbrowser}.
 */
public class CommonGraphListTransferHandler extends LocalTransferHandler {
    
    //
    public static final CommonGraphListTransferHandler TRANSFER_HANDLER = new CommonGraphListTransferHandler();
    
    //
    private static final Class GRAPH_LIST_ELEMENT = GraphListElement.class;
    
    //
    private CommonGraphListTransferHandler() {
        super();
        addDropHandler(GraphListElementDropHandler.DROP_HANDLER);
        addDropHandler(FactoryDropHandler.DROP_HANDLER);
        setDragHandler(new CommonGraphListDragHandler(LocalTransferHandler.COPY_OR_MOVE));
    }
    
    // drag handler for lists of type SomeList
    private static class CommonGraphListDragHandler implements DragHandler {
        
        //
        private int sourceActions;
        
        public CommonGraphListDragHandler(int sourceActions) {
            this.sourceActions = sourceActions;
        }
        
        //
        public int getSourceActions(JComponent source) {
            return sourceActions;
        }
        
        //
        public void exportDone(JComponent source, JComponent target, Object[] objects, Class<?> type, int action) {
            // TODO: should check underlying model?
            if (action == LocalTransferHandler.MOVE) {
                if (source == target) {
                    return; // no moves within the same component
                } else if (source instanceof HasGraphList) {
                    if (target instanceof HasGraphList &&
                            ((HasGraphList)source).getGraphList() == ((HasGraphList)target).getGraphList()) {
                        return; // no moves within the same model
                    } else {
                        GraphList model = ((HasGraphList)source).getGraphList();
                        //TODO: check that these objects are GraphListElements
                        for (Object obj: objects)
                            model.remove(obj);
                    }
                }
            }
            
        }
        
        // copy to another type array
        public  Object[] getExportedObjects(JComponent source) {
            Object[] values = ((HasSelectableGraphList)source).getSelectedValues();
            //TODO: should this be copied?
            Object[] result = new Object[values.length];
            System.arraycopy(values, 0, result, 0, values.length);
            return result;
        }
        
        //
        public Class getExportedClass(JComponent source) {
            return GRAPH_LIST_ELEMENT;
        }
        
        //
        public boolean isTransferAllowed(JComponent source, JComponent target) {
            if (source == target)
                return false;
            else if (source instanceof HasGraphList && target instanceof HasGraphList)
                return (((HasGraphList)source).getGraphList() != ((HasGraphList)target).getGraphList());
            else
                return true;
        }
        
    }
    
    
}
