/* FactoryManager.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories; // NOPMD

import be.ugent.caagt.swirl.dialogs.SimpleDialog;

import java.util.ResourceBundle;

import org.grinvin.params.ParameterList;
import org.grinvin.params.ParameterPanel;

/**
 * Helper class to handle configuration of {@link Factory} objects.
 */
public class FactoryManager {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.factories.resources";
    
    public static boolean configureFactory(Factory factory) throws FactoryParameterException {
        // open a factory parameter window if at least one parameter
        // is present
        ParameterList list = factory.getParameters();
        int paramCount = list.getCount();
        if (paramCount > 0) {
            ParameterPanel panel = new ParameterPanel(list);
            SimpleDialog dialog = panel.createDialog(null,
                    ResourceBundle.getBundle(BUNDLE_NAME).getString("Parameters.title"),
                    true);
            if (factory instanceof VisualFactory)
                dialog.setIcon(((VisualFactory)factory).getIcon());
            if (dialog.launchAtPointerPosition() == SimpleDialog.APPROVE_OPTION) {
                Object[] values = new Object[paramCount];
                panel.getValues(values);
                factory.setParameterValues(values);
            } else {
                return false;
            }
        }
        return true;
    }
    
}
