/* AbstractInequalityEngine.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.engine;

import org.grinvin.invariants.InvariantValue;

public abstract class AbstractInequalityEngine implements InequalityEngine {
    
    //
    private int mainInvariant = 0;
    
    //
    public void setMainInvariant(int index) {
        this.mainInvariant = index;
    }
    
    //
    public int getMainInvariant() {
        return mainInvariant;
    }
    
    /**
     * Translates substring of type I&lt;number&gt; with the corresponding
     * invariant.
     */
    String translate(String src, String[] names) {
        // TODO: use Scanner?
        StringBuilder result = new StringBuilder(2*src.length());
        int len = src.length();
        int i=0;
        while (i < len) {
            char ch = src.charAt(i);
            if (ch == 'I') {
                int total = 0;
                i++;
                ch = src.charAt(i);
                while (ch >= '0' && ch <= '9') {
                    total = 10*total + ch - '0';
                    i++;
                    ch = src.charAt(i);
                }
                result.append(names[total]);
            } else {
                result.append(ch);
                i++;
            }
        }
        return result.toString();
    }
    
    //
    public abstract String run(InvariantValue [][] values);
    
}
