/* VersionTableModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.about;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 * Table which displays module version information.
 */
public class VersionTableModel extends AbstractTableModel {
    
    /** Default constructor */
    private VersionTableModel () {
        this.rowList = new ArrayList<VersionInfo> ();
    }
    
    //
    private static final VersionTableModel THE_TABLE_MODEL = new VersionTableModel ();
    
    static {
        THE_TABLE_MODEL.addVersionForModel ("dist");
        THE_TABLE_MODEL.addVersionForModel ("core");
        THE_TABLE_MODEL.addVersionForModel ("factories");
        THE_TABLE_MODEL.addVersionForModel ("invariants");
        THE_TABLE_MODEL.addVersionForModel ("graphs");
        THE_TABLE_MODEL.addVersionForModel ("help");
    }
    
    /**
     * Return the unique table model containing versioning information
     * for all modules that are active during the current build.
     */
    public static VersionTableModel getInstance () {
        return THE_TABLE_MODEL;
    }
    
    //
    private final List<VersionInfo> rowList;
    
    /**
     * Add a row to the table for the module of the given name.
     * No row is added if version information for that module
     * cannot be found.
     */
    public void addVersionForModel (String name) {
        VersionInfo info = VersionInfo.loadVersionInfo(name);
        if (info != null)
            rowList.add (info);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return rowList.get(rowIndex).getColumn(columnIndex);
    }

    public int getRowCount() {
        return rowList.size();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        return null; // TODO: use proper names? (internationalized)
    }

    private static final Class<String> STRING_CLASS = String.class;
    
    public Class<?> getColumnClass(int columnIndex) {
        return STRING_CLASS;
    }
    
    
    
}
