/* GraphURIType.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

import java.awt.Color;
import javax.swing.Icon;

import org.grinvin.gui.icons.SvgIconManager;

public enum GraphURIType {
    
    /**
     * Type constant which denotes a graph which was created by an editor
     * but not yet assigned an URI.
     */
    GRAPH_SESSION(
            new Color(237, 237, 181),
            "/org/grinvin/icons/type-new.svg"
    ),
            
    /**
     * Type constant which denotes a graph which is globally identifyable.
     */
    GRAPH_GLOBAL(
            new Color(210, 255, 210),
            "/org/grinvin/icons/type-graph.svg"
    ),
            
    /**
     * Type constant for a graph stored into local persistent storage (file, database, ...).
     */
    GRAPH_LOCAL(
            new Color(255, 210, 210),
            "/org/grinvin/icons/type-file.svg"
    ),
            
    /**
     * Type constant for a factory.
     */
    FACTORY(
            new Color(187, 221, 221),
            "/org/grinvin/icons/type-factory.svg"
    ),
            
    /**
     * Type constant for an invariant.
     */
    INVARIANT(
            new Color(221, 187, 187),
            "/org/grinvin/icons/type-invariant.svg"
    ),
            
    /**
     * Type constant for a list of graphs.
     */
    LIST(
            new Color(0, 0, 135),
            "/org/grinvin/icons/type-list.svg"
    ),
            
    /**
     * Type constant for an invariant factory (or parametrized invariant)
     */
    INVARIANT_FACTORY(
            new Color(221, 187, 221),
            "/org/grinvin/icons/type-invariant-factory.svg"
    );
    
    //
    public Color color;
    
    //
    public Icon icon;
    
    //
    GraphURIType(Color color, String iconPath) {
        this.color = color;
        this.icon = SvgIconManager.getInstance().getIcon(iconPath, 12);
    }
    
    //
    public Color getIconBackgroundColor() {
        return color;
    }
    
    public Icon getSmallIcon() {
        return icon;
    }
    
    
}
