// $Id: DiagramFactory.java,v 1.3 2005/07/18 15:00:34 bobtarling Exp $
// Copyright (c) 1996-2005 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.tigris.gef.base;

import java.util.List;
import java.util.Vector;

/**
* Provide a factory to create diagrams. Applications can override this
* to force their own initialisation.
* @author Bob Tarling
*/
public class DiagramFactory {
 
    private static DiagramFactory diagramFactory = new DiagramFactory();
 
    private List diagrams = new Vector();
    
    protected DiagramFactory() {
    }

    public static DiagramFactory getInstance() {
        return diagramFactory;
    }
    
    public void setDiagramFactory(DiagramFactory factory) {
        diagramFactory = factory;
    }
 
    /**
     * Factory method to create a new instance of a Class Diagram
     * @param type The class of rendering diagram to create
     * @param model The model that this class diagram represents
     * @param owningElement The modelElement which own this diagram (can be the model)
     * @return the newly instantiated class diagram
     */
    public Diagram createDiagram(Class type) {
        try {
            return (Diagram)type.newInstance();
        } catch (Exception e) {
            return null;
        }
    }
}
