/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import java.math.BigDecimal;

public final class NumericValue
extends Value {
    private double value;
    static /* synthetic */ Class class$com$icl$saxon$expr$NumericValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public NumericValue(double d) {
        this.value = d;
    }

    public NumericValue(String string) {
        this.value = Value.stringToNumber(string);
    }

    public String asStringOLD() {
        if (Double.isNaN(this.value)) {
            return "NaN";
        }
        if (Double.isInfinite(this.value)) {
            return this.value > 0.0 ? "Infinity" : "-Infinity";
        }
        if (this.value == 0.0) {
            return "0";
        }
        double d = Math.abs(this.value);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value < 0.0) {
            stringBuffer.append('-');
        }
        int n = this.value < 0.0 ? 1 : 0;
        double d2 = Math.floor(d);
        double d3 = d - d2;
        if (d2 >= 1.0) {
            while (d2 >= 1.0) {
                int n2 = (int)(d2 % 10.0);
                char c = (char)(n2 + 48);
                stringBuffer.insert(n, c);
                d2 = Math.floor(d2 / 10.0);
            }
        } else {
            stringBuffer.append('0');
        }
        if (d3 > 0.0) {
            stringBuffer.append('.');
            while (d3 > 0.0) {
                double d4 = d3 * 10.0;
                if (d4 < 1.000000000001 && d4 > 0.999999999999) {
                    d4 = 1.0;
                }
                double d5 = Math.floor(d4);
                char c = (char)((int)d5 + 48);
                stringBuffer.append(c);
                d3 = d4 % 1.0;
            }
        }
        return stringBuffer.toString();
    }

    public String asString() {
        String string;
        int n;
        if (!Double.isInfinite(this.value) && (this.value >= 9.007199254740992E15 || -this.value >= 9.007199254740992E15)) {
            return new BigDecimal(this.value).toString();
        }
        String string2 = Double.toString(this.value);
        if (string2.charAt((n = string2.length()) - 2) == '.' && string2.charAt(n - 1) == '0') {
            if ((string2 = string2.substring(0, n - 2)).equals("-0")) {
                return "0";
            }
            return string2;
        }
        int n2 = string2.indexOf(69);
        if (n2 < 0) {
            return string2;
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        if (string2.charAt(0) == '-') {
            string = "-";
            string2 = string2.substring(1);
            --n2;
        } else {
            string = "";
        }
        int n4 = n2 - 2;
        if (n3 >= n4) {
            return string + string2.substring(0, 1) + string2.substring(2, n2) + NumericValue.zeros(n3 - n4);
        }
        if (n3 > 0) {
            return string + string2.substring(0, 1) + string2.substring(2, 2 + n3) + "." + string2.substring(2 + n3, n2);
        }
        return string + "0." + NumericValue.zeros(-1 - n3) + string2.substring(0, 1) + string2.substring(2, n2);
    }

    private static String zeros(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    public double asNumber() {
        return this.value;
    }

    public boolean asBoolean() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public int getDataType() {
        return 2;
    }

    public int conversionPreference(Class clazz) {
        if (clazz.isAssignableFrom(class$com$icl$saxon$expr$NumericValue == null ? (class$com$icl$saxon$expr$NumericValue = NumericValue.class$("com.icl.saxon.expr.NumericValue")) : class$com$icl$saxon$expr$NumericValue)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumericValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 15;
        }
        if (clazz == Byte.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumericValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 13;
        }
        if (clazz == Character.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = NumericValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 11;
        }
        if (clazz == Double.TYPE) {
            return 0;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NumericValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NumericValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumericValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 7;
        }
        if (clazz == Long.TYPE) {
            return 4;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NumericValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 5;
        }
        if (clazz == Short.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NumericValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 9;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NumericValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 16;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = NumericValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 17;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = NumericValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(class$com$icl$saxon$expr$NumericValue == null ? (class$com$icl$saxon$expr$NumericValue = NumericValue.class$("com.icl.saxon.expr.NumericValue")) : class$com$icl$saxon$expr$NumericValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumericValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NumericValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.asString();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.value);
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NumericValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE) {
            return new Float(this.value);
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NumericValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE) {
            return new Long((long)this.value);
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NumericValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE) {
            return new Integer((int)this.value);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NumericValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE) {
            return new Short((short)this.value);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NumericValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)this.value);
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NumericValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE) {
            return new Character((char)this.value);
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = NumericValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        throw new XPathException("Conversion of number to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(Expression.indent(n) + "number (" + this.asString() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

