#!/bin/sh -e
# Copyright (c) 2002 by Kevin M. Rosenberg
# License: GPL-2

remote_dir=ftp.xanalys.com/pub/software_tools/downloads/patches/lwl42
base_url=ftp://${remote_dir}
lw_dir=/usr/lib/lispworks
doc_dir=/usr/share/doc/lw-pro-installer
patch_dir=${lw_dir}/patch-downloads

if [ "$(ping -q -c 2 ftp.xanalys.com >|/dev/null && echo ok)" = ok ]; then
    mkdir -p ${patch_dir}
    wget --quiet -nd -N --directory-prefix=${patch_dir} --passive  "${base_url}/*" -R .rpm || true 

    patch_archive=`ls ${patch_dir}/*.tar.gz | sort -rn | head -1 2> /dev/null || true` 
    if [ -f "$patch_archive" ]; then
	tar xzf ${patch_archive} --directory ${lw_dir}
    fi
else
	echo "Unable to find ftp.xanalys.com on network. Skipping patch download." >& 2
fi
