/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl;

import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Occurances;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.impl.ImplMessages;
import org.apache.hivemind.impl.SchemaProcessorImpl;
import org.apache.hivemind.impl.ServiceImplementationFactoryParametersImpl;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.internal.ServiceImplementationConstructor;
import org.apache.hivemind.internal.ServicePoint;
import org.apache.hivemind.schema.Schema;

public final class InvokeFactoryServiceConstructor
extends BaseLocatable
implements ServiceImplementationConstructor {
    private String _factoryServiceId;
    private ServicePoint _serviceExtensionPoint;
    private Module _contributingModule;
    private List _parameters;
    private ServiceImplementationFactory _factory;
    private List _convertedParameters;
    static /* synthetic */ Class class$org$apache$hivemind$ServiceImplementationFactory;

    public Object constructCoreServiceImplementation() {
        if (this._factory == null) {
            ServicePoint factoryPoint = this._contributingModule.getServicePoint(this._factoryServiceId);
            Occurances expected = factoryPoint.getParametersCount();
            this._factory = (ServiceImplementationFactory)factoryPoint.getService(class$org$apache$hivemind$ServiceImplementationFactory == null ? (class$org$apache$hivemind$ServiceImplementationFactory = InvokeFactoryServiceConstructor.class$("org.apache.hivemind.ServiceImplementationFactory")) : class$org$apache$hivemind$ServiceImplementationFactory);
            Schema schema = factoryPoint.getParametersSchema();
            ErrorLog errorLog = this._serviceExtensionPoint.getErrorLog();
            SchemaProcessorImpl processor = new SchemaProcessorImpl(errorLog, schema);
            processor.process(this._parameters, this._contributingModule);
            this._convertedParameters = processor.getElements();
            this.checkParameterCounts(errorLog, expected);
        }
        try {
            ServiceImplementationFactoryParametersImpl factoryParameters = new ServiceImplementationFactoryParametersImpl(this._serviceExtensionPoint, this._contributingModule, this._convertedParameters);
            return this._factory.createCoreServiceImplementation(factoryParameters);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), this.getLocation(), ex);
        }
    }

    private void checkParameterCounts(ErrorLog log, Occurances expected) {
        int actual = this._convertedParameters.size();
        if (expected.inRange(actual)) {
            return;
        }
        String message = ImplMessages.wrongNumberOfParameters(this._factoryServiceId, actual, expected);
        log.error(message, this.getLocation(), null);
    }

    public Module getContributingModule() {
        return this._contributingModule;
    }

    public void setContributingModule(Module module) {
        this._contributingModule = module;
    }

    public List getParameters() {
        return this._parameters;
    }

    public ServicePoint getServiceExtensionPoint() {
        return this._serviceExtensionPoint;
    }

    public void setParameters(List list) {
        this._parameters = list;
    }

    public void setFactoryServiceId(String string) {
        this._factoryServiceId = string;
    }

    public void setServiceExtensionPoint(ServicePoint point) {
        this._serviceExtensionPoint = point;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

