/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class LNLogEntry
implements LogEntry,
LoggableObject,
NodeLogEntry {
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private Txn txn;
    private static final byte ABORT_KNOWN_DELETED_MASK = 1;
    private Class logClass;
    private LogEntryType entryType;
    private long nodeId;
    private boolean isTransactional;

    public LNLogEntry(Class logClass, boolean isTransactional) {
        this.logClass = logClass;
        this.isTransactional = isTransactional;
    }

    public LNLogEntry(LogEntryType entryType, LN ln, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn) {
        this.entryType = entryType;
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKnownDeleted;
        this.txn = txn;
        this.isTransactional = txn != null;
        this.logClass = ln.getClass();
        this.nodeId = ln.getNodeId();
    }

    public void readEntry(ByteBuffer entryBuffer, int entrySize, byte entryTypeVersion, boolean readFullItem) throws DatabaseException {
        try {
            if (readFullItem) {
                this.ln = (LN)this.logClass.newInstance();
                this.ln.readFromLog(entryBuffer, entryTypeVersion);
                this.nodeId = this.ln.getNodeId();
                this.dbId = new DatabaseId();
                this.dbId.readFromLog(entryBuffer, entryTypeVersion);
                this.key = LogUtils.readByteArray(entryBuffer);
                if (this.isTransactional) {
                    this.abortLsn = LogUtils.readLong(entryBuffer);
                    if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                        this.abortLsn = -1L;
                    }
                    this.abortKnownDeleted = (entryBuffer.get() & 1) != 0;
                    this.txn = new Txn();
                    this.txn.readFromLog(entryBuffer, entryTypeVersion);
                }
            } else {
                int endPosition = entryBuffer.position() + entrySize;
                this.nodeId = LogUtils.readLong(entryBuffer);
                entryBuffer.position(endPosition);
                this.ln = null;
            }
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.ln.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        sb.append(Key.dumpString(this.key, 0));
        if (this.isTransactional) {
            if (this.abortLsn != -1L) {
                sb.append(DbLsn.toString(this.abortLsn));
            }
            sb.append("<knownDeleted val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            this.txn.dumpLog(sb, verbose);
        }
        return sb;
    }

    public Object getMainItem() {
        return this.ln;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public long getTransactionId() {
        if (this.isTransactional) {
            return this.txn.getId();
        }
        return 0L;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public LogEntryType getLogType() {
        return this.entryType;
    }

    public boolean marshallOutsideWriteLatch() {
        return this.ln.marshallOutsideWriteLatch();
    }

    public boolean countAsObsoleteWhenLogged() {
        return this.ln.isDeleted();
    }

    public void postLogWork(long justLoggedLsn) throws DatabaseException {
        if (this.isTransactional) {
            this.txn.addLogInfo(justLoggedLsn);
        }
    }

    public int getLogSize() {
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + LogUtils.getByteArrayLogSize(this.key);
        if (this.isTransactional) {
            size += LogUtils.getLongLogSize();
            ++size;
            size += this.txn.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer destBuffer) {
        this.ln.writeToLog(destBuffer);
        this.dbId.writeToLog(destBuffer);
        LogUtils.writeByteArray(destBuffer, this.key);
        if (this.isTransactional) {
            LogUtils.writeLong(destBuffer, this.abortLsn);
            byte aKD = 0;
            if (this.abortKnownDeleted) {
                aKD = (byte)(aKD | 1);
            }
            destBuffer.put(aKD);
            this.txn.writeToLog(destBuffer);
        }
    }

    public LN getLN() {
        return this.ln;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getDupKey() {
        if (this.ln.isDeleted()) {
            return null;
        }
        return this.ln.getData();
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public Long getTxnId() {
        if (this.isTransactional) {
            return new Long(this.txn.getId());
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.isTransactional) {
            return this.txn;
        }
        return null;
    }
}

