#include "liveice.h"

/* random useful functions for URL decoding */

#define HEX_ESCAPE '%'
#define ACCEPTABLE(a)  (a >= 32 && a < 128 && ((isAcceptable[a - 32]) & mask))

unsigned char isAcceptable[96] =
{
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF,0xE,0x0,0xF,0xF,0xC, 
  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x8,0x0,0x0,0x0,0x0,0x0, 
  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF, 
  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0x0,0x0,0xF, 
  0x0,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF, 
  0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0xF,0x0,0x0,0x0,0x0,0x0  
};

char *hex = "0123456789ABCDEF";

int mask = 0x8; 

char * url_encode (char *str, char **result_p)
{
  const char *p;
  char *q;
  char *result;
  int unacceptable = 0;

  if (!str) 
  {
	  return NULL;
  }

  for (p = str; *p; p++)
    if (!ACCEPTABLE((unsigned char) (*p)))
      unacceptable++;

  result = (char  *) malloc (p - str + unacceptable + unacceptable + 1);

  *result_p = result;

  for (q = result, p = str; *p; p++) 
    {
      unsigned char a = *p;
      if (!ACCEPTABLE(a)) 
	{
	  *q++ = HEX_ESCAPE;  /* Means hex commming */
	  *q++ = hex[a >> 4];
	  *q++ = hex[a & 15];
	}
      else *q++ = *p;
    }
  *q++ = 0;                   /* Terminate */
  return result;
}

/* I'll put the url decodign stuff in here too.... why not */

void getword(char *word, char *line, char stop) {
    int x = 0,y;

    for(x=0;((line[x]) && (line[x] != stop));x++)
        word[x] = line[x];

    word[x] = '\0';
    if(line[x]) ++x;
    y=0;

    while(line[y++] = line[x++]);
}


char x2c(char *what) {
    register char digit;

    digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
    digit *= 16;
    digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
    return(digit);
}

void unescape_url(char *url) {
    register int x,y;

    for(x=0,y=0;url[y];++x,++y) {
        if((url[x] = url[y]) == '%') {
            url[x] = x2c(&url[y+1]);
            y+=2;
        }
    }
    url[x] = '\0';
}


void plustospace(char *str) {
    register int x;

    for(x=0;str[x];x++) if(str[x] == '+') str[x] = ' ';
}

int string_contains(char *string,char *seek){
	int i,j,k;
	
	i=j=0;
	if(!string || !seek){
		return 0;
	}
	while(string[i]){
		if(seek[0]==string[i]){
			j=i+1;
			k=1;
			while(seek[k]==string[j] && seek[k] && string[j]){
				j++;
				k++;
			}
			if(!seek[k]){
				return 1;
			} 
			if(!string[j]){
				return 0;
			}
		}
		i++;
	}
	return 0;
}

void strtoupper(char *string){
  int i=0;
  if(string){
    while(string[i]){
      string[i]=toupper(string[i]);
      i++;
    }
  }
}

