/****************************************************************************
**
** Copyright (C) 2002-2004 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@lincvs.org>
**
**
**----------------------------------------------------------------------------
**
** This class holds all the project specific settings, and enables quick and
** easy access. There must be only one instance!!!
** The keys are defined in globals.h, to ensure being available everywhere
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef PROJECTSETTINGS_H
#define PROJECTSETTINGS_H


#include "config.h"


#include <qstring.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdict.h>
#include <qsettings.h>


class ProjectSettings {

 public:

  typedef QMap<QString,QString> StringMap;
  typedef QMap<QString,int> IntMap;

  ProjectSettings();
  virtual ~ProjectSettings();

  bool renameProject( QString, QString);
  bool removeProject( QString);
  bool removeSubProject( QString, QString);

  void addSubProject( QString, QString);
  void setSubProjects( QString, QStringList);
  void set( const QString, const QString, bool);
  void set( const QString, const QString, int);
  void set( const QString, const QString, QString);
  void set( const QString, const QString, QStringList);
  void set( const QString, const QString, StringMap);
  void set( const QString, const QString, IntMap);

  bool getProjects( QStringList&);
  bool getTopLevelProjects( QStringList&);
  bool getSubProjects( const QString&, QStringList&);
  bool get( const QString, const QString, bool&);
  bool get( const QString, const QString, int&);
  bool get( const QString, const QString, QString&);
  bool get( const QString, const QString, QStringList&);
  bool get( const QString, const QString, StringMap&);
  bool get( const QString, const QString, IntMap&);

  void writeToSettings( QSettings*, const QString);
  void readFromSettings( QSettings*, const QString);

  void test();

 protected:

 private:

  typedef QMap<QString,QString> SettingsMap;

  static const char SUBPROJECTS[];

  SettingsMap* getAndCreateProjectSettings( QString);
  SettingsMap* getProjectSettings( QString);
  QDict<SettingsMap> projectMap;

};

#endif   //PROJECTSETTINGS_H
