#ifndef PATCHDIALOGIMPL_H
#define PATCHDIALOGIMPL_H

#include "PatchDialog.h"

class PatchDialogImpl : public PatchDialog
{
   Q_OBJECT

signals:
   void getSelectedTags();
   void getProjectTags();
   void accept();
   void reject();

public:

   PatchDialogImpl( QString, QString, QStringList *, QString,
	 const QIconSet &, QWidget *);
   PatchDialogImpl( QString, QStringList, QStringList *, QString,
	 const QIconSet &, QWidget *);
   ~PatchDialogImpl();

   void init(const QIconSet &);
   QString getPatchFile();
   QString getCvsCmd();
  
public slots:
   void tagListUpdated();
   void detailsToggled(bool);
   void enterWhatsThisMode();
   
protected slots:
   void closeEvent(QCloseEvent *);
   void fileNameChanged(const QString &);
   
private slots:
   void okClicked();
   void cancelClicked();
   void fetchClicked();
   void browseClicked();
   void setSelectionFirstTag();
   void activatedFirstTag(const QString &);
   void textChangedFirstTag(const QString &);
   
private:
   void readProjectNameList();
   void setPixmaps(QComboBox *);
   void removeRevisionSelection();
   QWidget * m_parent;
   QString m_name;
   
   QString m_dirName;
   QString m_file;
   QStringList * m_pSelectedTagList;
   QString m_topModuleName;
   bool m_fetchOverall;
   bool m_firstTagListOnEdit;
   QPixmap * m_pOldFirstTagPixmap;
   
   QStringList m_ProjectTagList;
   int m_oldFirstTagIdx;
   bool m_firstTagListOnUpdate;
   QString m_oldFirstTagText;
   int m_lastFirstTagLen;
   
   bool m_running;
   QString m_patchFile;
};

#endif
